/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitEvents {
    @SubscribeEvent
    public void mineSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack tool = event.getEntityPlayer().field_71071_by.func_70448_g();
        if (this.isTool(tool) && !ToolHelper.isBroken(tool)) {
            NBTTagList list = TagUtil.getTraitsTagList(tool);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
                if (trait == null) continue;
                trait.miningSpeed(tool, event);
            }
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        ItemStack tool = event.getPlayer().field_71071_by.func_70448_g();
        if (this.isTool(tool) && !ToolHelper.isBroken(tool)) {
            NBTTagList list = TagUtil.getTraitsTagList(tool);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
                if (trait == null) continue;
                trait.beforeBlockBreak(tool, event);
            }
        }
    }

    @SubscribeEvent
    public void blockDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)event.getHarvester(), event.getState());
        if (this.isTool(tool) && !ToolHelper.isBroken(tool)) {
            NBTTagList list = TagUtil.getTraitsTagList(tool);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
                if (trait == null) continue;
                trait.blockHarvestDrops(tool, event);
            }
        }
    }

    @SubscribeEvent
    public void playerBlockEvent(LivingHurtEvent event) {
        if (event.getEntity() == null || !(event.getEntity() instanceof EntityPlayer) || !((EntityPlayer)event.getEntity()).func_184585_cz()) {
            return;
        }
        for (ItemStack tool : event.getEntity().func_184214_aD()) {
            if (!this.isTool(tool) || ToolHelper.isBroken(tool)) continue;
            NBTTagList list = TagUtil.getTraitsTagList(tool);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
                if (trait == null) continue;
                trait.onBlock(tool, (EntityPlayer)event.getEntity(), event);
            }
        }
    }

    @SubscribeEvent
    public void onRepair(TinkerToolEvent.OnRepair event) {
        ItemStack tool = event.itemStack;
        NBTTagList list = TagUtil.getTraitsTagList(tool);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.onRepair(tool, event.amount);
        }
    }

    private boolean isTool(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ToolCore;
    }
}

