/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModReinforced
extends ModifierTrait {
    private static final float chancePerLevel = 0.2f;

    public ModReinforced() {
        super("reinforced", 5254787, 5, 0);
    }

    private float getReinforcedChance(NBTTagCompound modifierTag) {
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        return (float)data.level * 0.2f;
    }

    @Override
    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        NBTTagCompound tag;
        float chance;
        if (!entity.func_130014_f_().field_72995_K && (chance = this.getReinforcedChance(tag = TinkerUtil.getModifierTag(tool, this.identifier))) >= random.nextFloat()) {
            newDamage -= damage;
        }
        return Math.max(0, newDamage);
    }

    @Override
    public String getLocalizedDesc() {
        return String.format(super.getLocalizedDesc(), Util.dfPercent.format(0.2f));
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        if (data.level == this.maxLevel) {
            return Util.translate("modifier.%s.unbreakable", this.getIdentifier());
        }
        return super.getTooltip(modifierTag, detailed);
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        if (I18n.func_94522_b((String)loc)) {
            float chance = this.getReinforcedChance(modifierTag);
            String chanceStr = Util.dfPercent.format(chance);
            if (chance >= 1.0f) {
                chanceStr = Util.translate("modifier.%s.unbreakable", this.getIdentifier());
            }
            return ImmutableList.of((Object)Util.translateFormatted(loc, chanceStr));
        }
        return super.getExtraInfo(tool, modifierTag);
    }
}

