/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.entity.EntityShuriken;

public class Shuriken
extends ProjectileCore {
    private static PartMaterialType shurikenPMT = new PartMaterialType(TinkerTools.knifeBlade, "head", "extra");

    public Shuriken() {
        super(shurikenPMT, shurikenPMT, shurikenPMT, shurikenPMT);
        this.addCategory(Category.NO_MELEE, Category.PROJECTILE);
    }

    @Override
    public float damagePotential() {
        return 0.7f;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (ToolHelper.isBroken(itemStackIn)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 4);
        if (!worldIn.field_72995_K) {
            boolean usedAmmo = this.useAmmo(itemStackIn, (EntityLivingBase)playerIn);
            EntityProjectileBase projectile = this.getProjectile(itemStackIn, itemStackIn, worldIn, playerIn, 2.1f, 0.0f, usedAmmo);
            worldIn.func_72838_d((Entity)projectile);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public ProjectileNBT buildTagData(List<Material> materials) {
        ProjectileNBT data = new ProjectileNBT();
        data.head((HeadMaterialStats)materials.get(0).getStatsOrUnknown("head"), (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head"), (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head"), (HeadMaterialStats)materials.get(3).getStatsOrUnknown("head"));
        data.extra((ExtraMaterialStats)materials.get(0).getStatsOrUnknown("extra"), (ExtraMaterialStats)materials.get(1).getStatsOrUnknown("extra"), (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra"), (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra"));
        data.attack += 1.0f;
        data.accuracy = 1.0f;
        return data;
    }

    @Override
    public EntityProjectileBase getProjectile(ItemStack stack, ItemStack launcher, World world, EntityPlayer player, float speed, float inaccuracy, boolean usedAmmo) {
        return new EntityShuriken(world, player, speed, inaccuracy *= ProjectileNBT.from((ItemStack)stack).accuracy, this.getProjectileStack(stack, world, player, usedAmmo), launcher);
    }
}

