/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.energy;

import com.google.common.base.Predicate;
import com.tomevoll.routerreborn.API.energy.ITileBlockUpdate;
import com.tomevoll.routerreborn.API.energy.TileGeneratorBase;
import com.tomevoll.routerreborn.API.energy.TileMachineBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMachineBase
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static boolean keepInventory;
    protected final boolean isActive;

    public BlockMachineBase(boolean isActive) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.isActive = isActive;
    }

    public BlockMachineBase(Material mat) {
        super(mat);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.isActive = false;
    }

    public static void setState(boolean active, World worldIn, BlockPos pos, Block activeblock, Block inactiveblock) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            worldIn.func_180501_a(pos, activeblock.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180501_a(pos, activeblock.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180495_p(pos).func_177230_c().func_149715_a(0.8f);
        } else {
            worldIn.func_180501_a(pos, inactiveblock.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180501_a(pos, inactiveblock.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180495_p(pos).func_177230_c().func_149715_a(0.0f);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    private static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float f = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > stack.field_77994_a) {
                i = stack.field_77994_a;
            }
            stack.field_77994_a -= i;
            EntityItem entityitem = new EntityItem(worldIn, x + (double)f, y + (double)f1, z + (double)f2, new ItemStack(stack.func_77973_b(), i, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            float f3 = 0.05f;
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)f3;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)f3 + (double)0.2f;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)f3;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j(state) && !block1.func_149730_j(state)) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j(state) && !block.func_149730_j(state)) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j(state) && !block3.func_149730_j(state)) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j(state) && !block2.func_149730_j(state)) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.field_149784_t = this.isActive ? 13 : 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileMachineBase || tileentity instanceof TileGeneratorBase) {
            this.openGUI(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
        }
        return true;
    }

    public abstract boolean openGUI(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4, EnumFacing var5, float var6, float var7, float var8);

    public abstract Block getActiveBlock();

    public abstract Block getInActiveBlock();

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileMachineBase) {
            ((TileMachineBase)tileentity).setCustomInventoryName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!keepInventory) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileMachineBase) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileMachineBase)tileentity));
                if (((TileMachineBase)tileentity).processingItem != null) {
                    BlockMachineBase.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ((TileMachineBase)tileentity).processingItem);
                }
                worldIn.func_175666_e(pos, (Block)this);
            }
            if (tileentity instanceof TileGeneratorBase) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileGeneratorBase)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World worldIn, BlockPos pos) {
        return Item.func_150898_a((Block)this);
    }

    public int getRenderType() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof ITileBlockUpdate) {
            ((ITileBlockUpdate)tile).onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        }
        super.func_189540_a(state, worldIn, pos, neighborBlock);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile;
        if (world instanceof World && !((World)world).field_72995_K && (tile = world.func_175625_s(pos)) instanceof ITileBlockUpdate) {
            ((ITileBlockUpdate)tile).onNeighborTileChange(world, pos, neighbor);
        }
        super.onNeighborChange(world, pos, neighbor);
    }
}

