/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.energy;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEnergyConsumerBase
extends TileEntity
implements ITickable,
IEnergyReceiver {
    protected EnergyStorage storage = new EnergyStorage(32000);
    protected int RFTick = 0;
    protected int tmpRFT = 0;

    public TileEnergyConsumerBase(int storage, int maxTransfer) {
        this.storage.setCapacity(storage);
        this.storage.setMaxTransfer(maxTransfer);
    }

    public void setEnergyStored(EnumFacing facing, int value) {
        this.storage.setEnergyStored(value);
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing facing, int value, boolean simulate) {
        int ret = this.storage.receiveEnergy(value, simulate);
        if (!simulate) {
            this.tmpRFT += ret;
        }
        return ret;
    }

    public boolean useEnergy(int value) {
        if (value <= this.storage.getEnergyStored()) {
            this.storage.modifyEnergyStored(0 - value);
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.RFTick = this.tmpRFT / 20;
            this.tmpRFT = 0;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.storage.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
    }
}

