/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.energy;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.tomevoll.routerreborn.API.BlockUtil;
import com.tomevoll.routerreborn.API.energy.ITileBlockUpdate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEnergyProducerBase
extends TileEntity
implements ITickable,
ITileBlockUpdate,
IEnergyProvider {
    protected EnergyStorage storage = new EnergyStorage(32000);
    protected IEnergyReceiver[] out = new IEnergyReceiver[6];
    protected boolean hadInit = false;
    protected int RFTick = 0;
    protected int tmpRFT = 0;

    public static EnumFacing getFaceFromPos(BlockPos pos1, BlockPos pos2) {
        EnumFacing ret = EnumFacing.func_176737_a((float)(pos1.func_177958_n() - pos2.func_177958_n()), (float)(pos1.func_177956_o() - pos2.func_177956_o()), (float)(pos1.func_177952_p() - pos2.func_177952_p()));
        return ret;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void onLoad() {
        this.hadInit = false;
        BlockUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
        super.onLoad();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.hadInit && this.field_145850_b.func_175697_a(this.field_174879_c, 10)) {
                this.hadInit = true;
                this.onNeighborBlockChange(this.field_145850_b, this.field_174879_c, null, null);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.RFTick = this.tmpRFT / 20;
                this.tmpRFT = 0;
            }
            this.TransmitEnergy();
        }
    }

    void TransmitEnergy() {
        int ret;
        IEnergyReceiver t;
        int i;
        int max = this.storage.getMaxExtract();
        int total = 0;
        int count = 0;
        for (i = 0; i < this.out.length; ++i) {
            t = this.out[i];
            if (t == null) continue;
            ret = t.receiveEnergy(EnumFacing.field_82609_l[i].func_176734_d(), max, true);
            total += ret;
            if (ret <= 0) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        if (total == 0) {
            return;
        }
        max = Math.min(total / count, max / count);
        max = Math.min(max, this.storage.getEnergyStored() / count);
        for (i = 0; i < this.out.length; ++i) {
            t = this.out[i];
            if (t == null) continue;
            ret = t.receiveEnergy(EnumFacing.field_82609_l[i].func_176734_d(), max, false);
            this.tmpRFT += ret;
            if (ret <= 0) continue;
            this.storage.extractEnergy(ret, false);
        }
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        EnumFacing f = TileEnergyProducerBase.getFaceFromPos(pos, neighbor);
        IEnergyReceiver r = this.out[f.func_176734_d().ordinal()];
        if (r != null && !((TileEntity)r).func_145837_r()) {
            return;
        }
        if (neighbor == null || world == null) {
            return;
        }
        TileEntity t = world.func_175625_s(neighbor);
        this.out[f.func_176734_d().ordinal()] = t instanceof IEnergyReceiver ? (IEnergyReceiver)t : null;
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity t = world.func_175625_s(pos.func_177972_a(facing));
            if (t instanceof IEnergyReceiver) {
                if (!((IEnergyReceiver)t).canConnectEnergy(facing.func_176734_d())) continue;
                this.out[facing.ordinal()] = (IEnergyReceiver)t;
                continue;
            }
            this.out[facing.ordinal()] = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.storage.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int res = this.storage.extractEnergy(maxExtract, simulate);
        if (res > 0 && !simulate) {
            this.tmpRFT += res;
        }
        return res;
    }
}

