/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.energy;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.tomevoll.routerreborn.API.energy.BlockMachineBase;
import com.tomevoll.routerreborn.API.energy.TileEnergyProducerBase;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class TileGeneratorBase
extends TileEnergyProducerBase
implements ISidedInventory {
    protected final int[] slotsTop = new int[]{0};
    protected final int[] slotsBottom = new int[]{0};
    protected final int[] slotsSides = new int[]{0};
    protected ItemStack[] itemStacks = new ItemStack[2];
    protected String customName;
    protected boolean isActive = false;
    protected int ENERGY_TICK = 10;
    private int totalBurnTime = 0;
    private int burnTime = 0;
    private int storagePerc = 0;
    private int powerLB = 0;
    private int powerHB = 0;
    private int maxPowerLB = 0;
    private int maxPowerHB = 0;

    public TileGeneratorBase(int storage, int maxTransfer) {
        this.storage.setCapacity(storage);
        this.storage.setMaxTransfer(maxTransfer);
    }

    public TileGeneratorBase() {
        this.storage.setCapacity(20000);
        this.storage.setMaxTransfer(200);
    }

    public abstract Block getActiveBlock();

    public abstract Block getInActiveBlock();

    public abstract int getBurnTime(ItemStack var1);

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean flag = this.isActive();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime <= this.totalBurnTime && this.totalBurnTime > 0) {
                this.isActive = true;
                ++this.burnTime;
                if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                    int max = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), this.ENERGY_TICK);
                    this.storage.modifyEnergyStored(max);
                }
                if (this.burnTime == this.totalBurnTime) {
                    this.burnTime = 0;
                    this.totalBurnTime = 0;
                    boolean res = this.eatItemAndStart();
                    if (res) {
                        flag1 = true;
                    }
                }
            } else if (!this.eatItemAndStart()) {
                this.isActive = false;
                flag1 = true;
            }
            if (flag != this.isActive()) {
                flag1 = true;
                BlockMachineBase.setState(this.isActive(), this.field_145850_b, this.field_174879_c, this.getActiveBlock(), this.getInActiveBlock());
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean eatItemAndStart() {
        if (this.storage.getEnergyStored() >= this.storage.getMaxEnergyStored()) {
            return false;
        }
        int res = this.getTotalBurnTimeFromSlot();
        if (res > 0) {
            --this.itemStacks[0].field_77994_a;
            if (this.itemStacks[0].field_77994_a <= 0) {
                this.itemStacks[0] = null;
            }
            this.totalBurnTime = res;
            return true;
        }
        return false;
    }

    private int getTotalBurnTimeFromSlot() {
        if (this.itemStacks[0] == null) {
            return 0;
        }
        int res = this.getBurnTime(this.itemStacks[0]);
        return res;
    }

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.itemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.itemStacks[index] != null) {
            if (this.itemStacks[index].field_77994_a <= count) {
                ItemStack itemstack1 = this.itemStacks[index];
                this.itemStacks[index] = null;
                return itemstack1;
            }
            ItemStack itemstack = this.itemStacks[index].func_77979_a(count);
            if (this.itemStacks[index].field_77994_a == 0) {
                this.itemStacks[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.itemStacks[index] != null) {
            ItemStack itemstack = this.itemStacks[index];
            this.itemStacks[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.itemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.itemStacks[index]);
        this.itemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? "routerreborn:" + this.customName : "routerreborn:container.machinebase";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.customName = p_145951_1_;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.itemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.itemStacks.length) continue;
            this.itemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.burnTime = compound.func_74765_d("burnTime");
        this.totalBurnTime = compound.func_74765_d("totalBurnTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("burnTime", (short)this.burnTime);
        compound.func_74777_a("totalBurnTime", (short)this.totalBurnTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom : (side == EnumFacing.UP ? this.slotsTop : this.slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.isActive ? 1 : 0;
            }
            case 1: {
                return this.storage.getEnergyStored();
            }
            case 2: {
                return this.burnTime;
            }
            case 3: {
                return this.totalBurnTime;
            }
            case 4: {
                if (this.field_145850_b.field_72995_K) {
                    return this.storagePerc;
                }
                int res = (int)((float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 100.0f);
                return res;
            }
            case 5: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[2], (byte)tt[3]);
                    this.powerLB = t;
                }
                return this.powerLB;
            }
            case 6: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[0], (byte)tt[1]);
                    this.powerHB = t;
                }
                return this.powerHB;
            }
            case 7: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getMaxEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[2], (byte)tt[3]);
                    this.maxPowerLB = t;
                }
                return this.maxPowerLB;
            }
            case 8: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getMaxEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[0], (byte)tt[1]);
                    this.maxPowerHB = t;
                }
                return this.maxPowerHB;
            }
            case 9: {
                if (this.field_145850_b.field_72995_K) {
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    buf.writeShort(this.powerHB);
                    buf.writeShort(this.powerLB);
                    this.storage.setEnergyStored(buf.readInt());
                }
                return this.storage.getEnergyStored();
            }
            case 10: {
                if (this.field_145850_b.field_72995_K) {
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    buf.writeShort(this.maxPowerHB);
                    buf.writeShort(this.maxPowerLB);
                    this.storage.setCapacity(buf.readInt());
                }
                return this.storage.getMaxEnergyStored();
            }
            case 11: {
                return this.RFTick;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.isActive = value == 1;
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
                break;
            }
            case 2: {
                this.burnTime = value;
                break;
            }
            case 3: {
                this.totalBurnTime = value;
            }
            case 4: {
                this.storagePerc = value;
            }
            case 5: {
                this.powerLB = value;
                break;
            }
            case 6: {
                this.powerHB = value;
                break;
            }
            case 7: {
                this.maxPowerLB = value;
                break;
            }
            case 8: {
                this.maxPowerHB = value;
                break;
            }
            case 11: {
                this.RFTick = value;
            }
        }
    }

    public int func_174890_g() {
        return 12;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            this.itemStacks[i] = null;
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.func_70005_c_().substring("routerreborn".length() + 1), new Object[0]) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

