/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.energy;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.tomevoll.routerreborn.API.energy.BlockMachineBase;
import com.tomevoll.routerreborn.API.energy.TileEnergyConsumerBase;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMachineBase
extends TileEnergyConsumerBase
implements ISidedInventory {
    private static final int[] slotsTop = new int[]{0, 1};
    private static final int[] slotsBottom = new int[]{0, 1};
    private static final int[] slotsSides = new int[]{0, 1};
    public ItemStack[] furnaceItemStacks = new ItemStack[2];
    public ItemStack processingItem = null;
    protected int ENERGY_TICK = 10;
    private int cookTimeUsed;
    private int totalCookTimeNeeded;
    private String furnaceCustomName;
    private boolean isActive = false;
    private int storagePerc = 0;
    private int powerLB = 0;
    private int powerHB = 0;
    private int maxPowerLB = 0;
    private int maxPowerHB = 0;

    public TileMachineBase(int storage, int maxTransfer) {
        super(storage, maxTransfer);
    }

    public TileMachineBase() {
        super(20000, 20);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory p_174903_0_) {
        return p_174903_0_.func_174887_a_(0) > 0;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.furnaceItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.furnaceItemStacks[index] != null) {
            if (this.furnaceItemStacks[index].field_77994_a <= count) {
                ItemStack itemstack1 = this.furnaceItemStacks[index];
                this.furnaceItemStacks[index] = null;
                return itemstack1;
            }
            ItemStack itemstack = this.furnaceItemStacks[index].func_77979_a(count);
            if (this.furnaceItemStacks[index].field_77994_a <= 0) {
                this.furnaceItemStacks[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.furnaceItemStacks[index] != null) {
            ItemStack itemstack = this.furnaceItemStacks[index];
            this.furnaceItemStacks[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.furnaceItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.furnaceItemStacks[index]);
        this.furnaceItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? "routerreborn:" + this.furnaceCustomName : "routerreborn:container.machinebase";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && this.furnaceCustomName.length() > 0;
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.furnaceCustomName = p_145951_1_;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j >= 0 && j < this.furnaceItemStacks.length) {
                this.furnaceItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
                continue;
            }
            this.processingItem = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.cookTimeUsed = compound.func_74765_d("CookTime");
        this.totalCookTimeNeeded = compound.func_74765_d("CookTimeTotal");
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("CookTime", (short)this.cookTimeUsed);
        compound.func_74777_a("CookTimeTotal", (short)this.totalCookTimeNeeded);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (this.processingItem != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)this.furnaceItemStacks.length);
            this.processingItem.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.isActive;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.processingItem != null && this.storage.getEnergyStored() >= this.ENERGY_TICK) {
                if (this.useEnergy(this.ENERGY_TICK)) {
                    ++this.cookTimeUsed;
                    this.isActive = true;
                } else {
                    this.isActive = false;
                }
                if (this.cookTimeUsed == this.totalCookTimeNeeded) {
                    this.cookTimeUsed = 0;
                    this.totalCookTimeNeeded = this.getProcessTime(this.furnaceItemStacks[0]);
                    this.smeltItem();
                    this.processingItem = null;
                    flag1 = true;
                }
            } else if (this.processingItem == null && this.canProcess()) {
                this.processingItem = this.furnaceItemStacks[0].func_77946_l();
                this.processingItem.field_77994_a = 1;
                --this.furnaceItemStacks[0].field_77994_a;
                if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                    this.furnaceItemStacks[0] = null;
                }
                this.totalCookTimeNeeded = this.getProcessTime(this.processingItem);
                this.cookTimeUsed = 0;
                this.func_70296_d();
            } else {
                this.isActive = false;
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockMachineBase.setState(this.isBurning(), this.field_145850_b, this.field_174879_c, this.getActiveBlock(), this.getInActiveBlock());
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public abstract Block getActiveBlock();

    public abstract Block getInActiveBlock();

    public int getProcessTime(ItemStack stack) {
        return 200;
    }

    private boolean canProcess() {
        if (this.furnaceItemStacks[0] == null) {
            if (this.processingItem == null) {
                return false;
            }
            ItemStack itemstack = this.getResult(this.processingItem);
            if (itemstack == null) {
                return false;
            }
            if (this.furnaceItemStacks[1] == null) {
                return true;
            }
            if (!this.furnaceItemStacks[1].func_77969_a(itemstack)) {
                return false;
            }
            int result = this.furnaceItemStacks[1].field_77994_a + itemstack.field_77994_a;
            return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[1].func_77976_d();
        }
        if (this.storage.getEnergyStored() < this.ENERGY_TICK) {
            return false;
        }
        ItemStack itemstack = this.getResult(this.furnaceItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[1] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[1].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[1].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[1].func_77976_d();
    }

    private void smeltItem() {
        if (this.canProcess()) {
            ItemStack itemstack = this.getResult(this.processingItem);
            if (this.furnaceItemStacks[1] == null) {
                this.furnaceItemStacks[1] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[1].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[1].field_77994_a += itemstack.field_77994_a;
            }
        }
    }

    public abstract ItemStack getResult(ItemStack var1);

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (index == 1) {
            return false;
        }
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.isActive ? 1 : 0;
            }
            case 1: {
                return this.storage.getEnergyStored();
            }
            case 2: {
                return this.cookTimeUsed;
            }
            case 3: {
                return this.totalCookTimeNeeded;
            }
            case 4: {
                if (this.field_145850_b.field_72995_K) {
                    return this.storagePerc;
                }
                int res = (int)((float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 100.0f);
                return res;
            }
            case 5: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[2], (byte)tt[3]);
                    this.powerLB = t;
                }
                return this.powerLB;
            }
            case 6: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[0], (byte)tt[1]);
                    this.powerHB = t;
                }
                return this.powerHB;
            }
            case 7: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getMaxEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[2], (byte)tt[3]);
                    this.maxPowerLB = t;
                }
                return this.maxPowerLB;
            }
            case 8: {
                if (!this.field_145850_b.field_72995_K) {
                    byte[] tt = Ints.toByteArray((int)this.storage.getMaxEnergyStored());
                    short t = Shorts.fromBytes((byte)tt[0], (byte)tt[1]);
                    this.maxPowerHB = t;
                }
                return this.maxPowerHB;
            }
            case 9: {
                if (this.field_145850_b.field_72995_K) {
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    buf.writeShort(this.powerHB);
                    buf.writeShort(this.powerLB);
                    this.storage.setEnergyStored(buf.readInt());
                    return this.storage.getEnergyStored();
                }
            }
            case 10: {
                if (this.field_145850_b.field_72995_K) {
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    buf.writeShort(this.maxPowerHB);
                    buf.writeShort(this.maxPowerLB);
                    this.storage.setCapacity(buf.readInt());
                }
                return this.storage.getMaxEnergyStored();
            }
            case 11: {
                return this.RFTick;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.isActive = value == 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.cookTimeUsed = value;
                break;
            }
            case 3: {
                this.totalCookTimeNeeded = value;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.powerLB = value;
                break;
            }
            case 6: {
                this.powerHB = value;
                break;
            }
            case 7: {
                this.maxPowerLB = value;
                break;
            }
            case 8: {
                this.maxPowerHB = value;
                break;
            }
            case 11: {
                this.RFTick = value;
            }
        }
    }

    public int func_174890_g() {
        return 12;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            this.furnaceItemStacks[i] = null;
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.func_70005_c_().substring("routerreborn".length() + 1), new Object[0]) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

