/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class InventoryHelper {
    public static ItemStack putStackInInventoryAllSlotsLimited(IInventory inventory, ItemStack stack, EnumFacing side, int maxTransfer) {
        if (stack == null) {
            return null;
        }
        if (maxTransfer <= 0) {
            return null;
        }
        ItemStack transfer = stack.func_77946_l();
        transfer.field_77994_a = Math.min(stack.field_77994_a, maxTransfer);
        ItemStack ret = TileEntityHopper.func_174918_a((IInventory)inventory, (ItemStack)transfer.func_77946_l(), (EnumFacing)side);
        if (ret == null) {
            return transfer.func_77946_l();
        }
        transfer.field_77994_a -= ret.field_77994_a;
        return transfer.func_77946_l();
    }

    public static boolean oreDictMatch(ItemStack stack, ItemStack stack2) {
        if (stack == null) {
            return false;
        }
        if (stack2 == null) {
            return false;
        }
        int[] ore1 = OreDictionary.getOreIDs((ItemStack)stack);
        int[] ore2 = OreDictionary.getOreIDs((ItemStack)stack2);
        if (ore1 != null && ore2 != null && ore1.length != 0 && ore2.length != 0) {
            for (int s = 0; s < ore1.length; ++s) {
                for (int t = 0; t < ore2.length; ++t) {
                    if (ore1[s] != ore2[t]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ItemStack> getContentOfInventory(IItemHandler inventory) {
        ArrayList<ItemStack> lst = new ArrayList<ItemStack>();
        for (int s = 0; s < inventory.getSlots(); ++s) {
            lst.add(inventory.getStackInSlot(s) == null ? null : inventory.getStackInSlot(s).func_77946_l());
        }
        return lst;
    }

    public static List<ItemStack> getContentOfInventory(IInventory inventory, EnumFacing side) {
        ArrayList<ItemStack> lst = new ArrayList<ItemStack>();
        if (inventory instanceof IDeepStorageUnit) {
            IDeepStorageUnit deep = (IDeepStorageUnit)inventory;
            ItemStack s = deep.getStoredItemType();
            if (s != null) {
                lst.add(s.func_77946_l());
            }
        } else {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack s = inventory.func_70301_a(i);
                if (s == null) continue;
                lst.add(s.func_77946_l());
            }
        }
        return lst;
    }

    private static void getContentFromSide(ISidedInventory isidedinventory, EnumFacing side, List<ItemStack> lst) {
        int[] aint = isidedinventory.func_180463_a(side);
        for (int k = 0; k < aint.length; ++k) {
            ItemStack s = isidedinventory.func_70301_a(aint[k]);
            if (s == null || !isidedinventory.func_180461_b(aint[k], s, side)) continue;
            lst.add(s.func_77946_l());
        }
    }

    public static ItemStack extractFromInventory(IInventory inventory, ItemStack toExtract, EnumFacing side, int slot) {
        return InventoryHelper.extractFromSlot(inventory, toExtract, side, slot);
    }

    public static ItemStack extractFromSlot(IInventory inventory, ItemStack toExtract, EnumFacing side, int slot) {
        if (inventory instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length; ++k) {
                boolean res;
                if (aint[k] != slot && slot != -1) continue;
                ItemStack s = isidedinventory.func_70301_a(aint[k]);
                if (toExtract != null && (s == null || !InventoryHelper.isStacksEqual(toExtract, s, true)) || !(res = isidedinventory.func_180461_b(aint[k], s, side))) continue;
                return isidedinventory.func_70298_a(aint[k], toExtract.field_77994_a);
            }
        } else {
            int i = inventory.func_70302_i_();
            if (slot > i) {
                return null;
            }
            if (slot == -1) {
                for (int x = 0; x < i; ++x) {
                    ItemStack s = inventory.func_70301_a(x);
                    if (s == null || !InventoryHelper.isStacksEqual(toExtract, s, true)) continue;
                    return inventory.func_70298_a(x, toExtract.field_77994_a);
                }
            } else {
                ItemStack s = inventory.func_70301_a(slot);
                if (s != null && InventoryHelper.isStacksEqual(toExtract, s, true)) {
                    return inventory.func_70298_a(slot, toExtract.field_77994_a);
                }
            }
        }
        return null;
    }

    public static boolean canExtractFromInventory(IInventory inventory, ItemStack stack, EnumFacing side, int slot) {
        return InventoryHelper.canExtractFromSlot(inventory, stack, side, slot);
    }

    public static boolean canExtractFromSlot(IInventory inventory, ItemStack toExtract, EnumFacing side, int slot) {
        if (inventory instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length; ++k) {
                boolean res;
                if (aint[k] != slot && slot != -1) continue;
                ItemStack s = isidedinventory.func_70301_a(aint[k]);
                if (toExtract != null && (s == null || !InventoryHelper.isStacksEqual(toExtract, s, true)) || !(res = isidedinventory.func_180461_b(aint[k], s, side))) continue;
                return true;
            }
        } else {
            int i = inventory.func_70302_i_();
            if (slot > i) {
                return false;
            }
            if (slot == -1) {
                for (int x = 0; x < i; ++x) {
                    ItemStack s = inventory.func_70301_a(x);
                    if (toExtract != null && (s == null || !InventoryHelper.isStacksEqual(toExtract, s, true))) continue;
                    return true;
                }
            } else {
                ItemStack s = inventory.func_70301_a(slot);
                if (toExtract == null || s != null && InventoryHelper.isStacksEqual(toExtract, s, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canInsertStack(IDeepStorageUnit inventory, ItemStack stackIn) {
        ItemStack type = inventory.getStoredItemType().func_77946_l();
        if (type == null) {
            return true;
        }
        if (InventoryHelper.isStacksEqual(stackIn, type, true)) {
            return type.field_77994_a < inventory.getMaxStoredCount();
        }
        return false;
    }

    public static boolean canInsertStack(IInventory inventory, ItemStack stackIn, EnumFacing side, int slot) {
        if (inventory instanceof IDeepStorageUnit) {
            return InventoryHelper.canInsertStack((IDeepStorageUnit)inventory, stackIn);
        }
        if (inventory instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stackIn != null; ++k) {
                if (!InventoryHelper.canInsertItemInSlot((IInventory)isidedinventory, stackIn, aint[k], side) || aint[k] != slot && slot != -1) continue;
                return true;
            }
        } else {
            int i = inventory.func_70302_i_();
            for (int j = 0; j < i && stackIn != null; ++j) {
                if (!InventoryHelper.canInsertItemInSlot(inventory, stackIn, j, side) || j != slot && slot != -1) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack insertStack(IDeepStorageUnit inventory, ItemStack stackIn) {
        ItemStack target = inventory.getStoredItemType();
        if (!InventoryHelper.isStacksEqual(stackIn, target, true)) {
            return stackIn;
        }
        int max = inventory.getMaxStoredCount() - target.field_77994_a;
        if (max < 0) {
            max = 0;
        }
        max = Math.min(stackIn.field_77994_a, max);
        ItemStack ret = stackIn.func_77946_l();
        ret.field_77994_a -= max;
        if (ret.field_77994_a <= 0) {
            ret = null;
        }
        inventory.setStoredItemCount(target.field_77994_a + max);
        ((TileEntity)inventory).func_70296_d();
        return ret;
    }

    public static ItemStack insertStack(IInventory inventory, ItemStack stack, EnumFacing side, int slot) {
        if (inventory instanceof IDeepStorageUnit) {
            return InventoryHelper.insertStack((IDeepStorageUnit)inventory, stack);
        }
        if (inventory instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stack != null && stack.field_77994_a > 0; ++k) {
                if (aint[k] != slot && slot != -1) continue;
                stack = InventoryHelper.insertStack(inventory, stack, aint[k], side);
            }
        } else {
            int i = inventory.func_70302_i_();
            for (int j = 0; j < i && stack != null && stack.field_77994_a > 0; ++j) {
                if (j != slot && slot != -1) continue;
                stack = InventoryHelper.insertStack(inventory, stack, j, side);
            }
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (InventoryHelper.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            boolean flag = false;
            if (itemstack == null) {
                max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max >= stack.field_77994_a) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = null;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max));
                }
                flag = true;
            } else if (InventoryHelper.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.field_77994_a) {
                int i = max - itemstack.field_77994_a;
                int j = Math.min(stack.field_77994_a, i);
                stack.field_77994_a -= j;
                itemstack.field_77994_a += j;
                boolean bl = flag = j > 0;
            }
            if (flag) {
                if (inventoryIn instanceof TileEntityHopper) {
                    TileEntityHopper tileentityhopper = (TileEntityHopper)inventoryIn;
                    if (tileentityhopper.func_174914_o()) {
                        tileentityhopper.func_145896_c(8);
                    }
                    inventoryIn.func_70296_d();
                }
                inventoryIn.func_70296_d();
            }
        }
        return stack;
    }

    public static boolean canCombine(ItemStack target, ItemStack source) {
        return target.func_77973_b() == source.func_77973_b() && target.func_77960_j() == source.func_77960_j() && target.field_77994_a < target.func_77976_d() && ItemStack.func_77970_a((ItemStack)target, (ItemStack)source);
    }

    public static boolean canCombine(ItemStack target, ItemStack source, boolean t) {
        if (target == null || source == null) {
            return false;
        }
        return target.func_77973_b() == source.func_77973_b() && target.func_77960_j() == source.func_77960_j() && ItemStack.func_77970_a((ItemStack)target, (ItemStack)source);
    }

    public static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack target;
        boolean res;
        boolean bl = res = inventoryIn.func_94041_b(index, stack) && (!(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side));
        if (res && (target = inventoryIn.func_70301_a(index)) != null && target.field_77994_a < target.func_77976_d()) {
            return InventoryHelper.isStacksEqual(target, stack, true);
        }
        return false;
    }

    public static boolean isStacksEqual(ItemStack stackIn1, ItemStack stackIn2, boolean ignoreSize) {
        if (stackIn1 == null && stackIn2 == null) {
            return true;
        }
        if (stackIn1 == null || stackIn2 == null) {
            return false;
        }
        if (ignoreSize) {
            return ItemStack.func_77989_b((ItemStack)stackIn1.func_77946_l().func_77979_a(1), (ItemStack)stackIn2.func_77946_l().func_77979_a(1));
        }
        return ItemStack.func_77989_b((ItemStack)stackIn1.func_77946_l(), (ItemStack)stackIn2.func_77946_l());
    }
}

