/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.item;

import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBase
extends Item {
    public TMap<Integer, ItemEntry> itemMap = new THashMap();
    public ArrayList<Integer> itemList = new ArrayList();
    public boolean hasTextures = true;
    public String modName = "routerreborn";

    public ItemBase() {
        this.func_77627_a(true);
    }

    public ItemBase(String modName) {
        this.modName = modName;
        this.func_77627_a(true);
    }

    public ItemBase setHasTextures(boolean hasTextures) {
        this.hasTextures = hasTextures;
        return this;
    }

    public ItemStack addItem(int number, ItemEntry entry, boolean register) {
        if (this.itemMap.containsKey((Object)number)) {
            return null;
        }
        this.itemMap.put((Object)number, (Object)entry);
        this.itemList.add(number);
        ItemStack item = new ItemStack((Item)this, 1, number);
        return item;
    }

    public ItemStack addItem(int number, ItemEntry entry) {
        return this.addItem(number, entry, true);
    }

    public ItemStack addItem(int number, String name, int rarity, boolean register) {
        return this.addItem(number, new ItemEntry(name, rarity), register);
    }

    public ItemStack addItem(int number, String name, int rarity) {
        return this.addItem(number, name, rarity, true);
    }

    public ItemStack addItem(int number, String name) {
        return this.addItem(number, name, 0);
    }

    public ItemStack addOreDictItem(int number, String name, int rarity) {
        ItemStack stack = this.addItem(number, name, rarity);
        OreDictionary.registerOre((String)name, (ItemStack)stack);
        return stack;
    }

    public ItemStack addOreDictItem(int number, String name) {
        ItemStack stack = this.addItem(number, name);
        OreDictionary.registerOre((String)name, (ItemStack)stack);
        return stack;
    }

    public String getRawName(ItemStack stack) {
        int i = stack.func_77952_i();
        if (!this.itemMap.containsKey((Object)i)) {
            return "invalid";
        }
        return ((ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)i))).name;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int i = stack.func_77952_i();
        if (!this.itemMap.containsKey((Object)i)) {
            return EnumRarity.COMMON;
        }
        return EnumRarity.values()[((ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)stack.func_77952_i()))).rarity];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            list.add(new ItemStack(item, 1, this.itemList.get(i).intValue()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        int i = 0;
        if (stack != null) {
            i = stack.func_77952_i();
        }
        if (!this.itemMap.containsKey((Object)i)) {
            return "item.invalid";
        }
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)i);
        return this.func_77658_a();
    }

    public Item setUnlocalizedNameNoRegister(String name) {
        return super.func_77655_b(name);
    }

    public Item func_77655_b(String name) {
        GameRegistry.registerItem((Item)this, (String)name);
        name = "routerreborn:" + name;
        return super.func_77655_b(name);
    }

    public Item setUnlocalizedName(String textureName, String registrationName) {
        GameRegistry.registerItem((Item)this, (String)registrationName);
        textureName = "routerreborn:" + textureName;
        return super.func_77655_b(textureName);
    }

    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        if (!this.itemMap.containsKey((Object)stack.func_77952_i())) {
            return -1;
        }
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)stack.func_77952_i());
        return item.Color;
    }

    public void setColor(ItemStack stack, int color) {
        if (!this.itemMap.containsKey((Object)stack.func_77952_i())) {
            return;
        }
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)stack.func_77952_i());
        item.Color = color;
    }

    public void setDisplayName(ItemStack stack, String name) {
        if (!this.itemMap.containsKey((Object)stack.func_77952_i())) {
            return;
        }
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)stack.func_77952_i());
        item.displayName = name;
        item.altName = true;
    }

    public String func_77653_i(ItemStack stack) {
        if (!this.itemMap.containsKey((Object)stack.func_77952_i())) {
            return "Item Invalid!";
        }
        String s = "";
        ItemEntry item = (ItemEntry)this.itemMap.get((Object)stack.func_77952_i());
        if (item.altName) {
            return item.displayName;
        }
        return item.name;
    }

    @SideOnly(value=Side.CLIENT)
    public class ColorHandler
    implements IItemColor {
        public ItemBase base = null;

        public ColorHandler(ItemBase base) {
            this.base = base;
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (!this.base.itemMap.containsKey((Object)stack.func_77952_i())) {
                return -1;
            }
            ItemEntry item = (ItemEntry)this.base.itemMap.get((Object)stack.func_77952_i());
            return item.Color;
        }
    }

    public class ItemEntry {
        public String displayName;
        public String name;
        public Icon icon;
        public int Color = -1;
        public int rarity = 0;
        public int maxDamage = 0;
        public boolean altName = false;

        public ItemEntry(String name, int rarity, int maxDamage) {
            this.name = name;
            this.rarity = rarity;
            this.maxDamage = maxDamage;
        }

        public ItemEntry(String name, int rarity) {
            this.name = name;
            this.rarity = rarity;
        }

        public ItemEntry(String name) {
            this.name = name;
        }

        public ItemEntry setDisplayName(String name) {
            this.displayName = name;
            return this;
        }

        public ItemEntry useAltName(boolean altName) {
            this.altName = altName;
            return this;
        }
    }
}

