/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.API.recipe;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;

public class PulverizerRecipe {
    private static final PulverizerRecipe recipeBase = new PulverizerRecipe();
    private Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private Map<ItemStack, Float> experienceList = Maps.newHashMap();

    private PulverizerRecipe() {
    }

    public static PulverizerRecipe instance() {
        return recipeBase;
    }

    public void addRecipe(Block input, ItemStack stack, float experience) {
        this.addRecipe(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addRecipe(Item input, ItemStack stack, float experience) {
        this.addRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getResult(input) != null) {
            FMLLog.info((String)("Ignored pulverizer recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public boolean removeRecipe(ItemStack input) {
        if (this.getResult(input) != null) {
            ItemStack ret = this.smeltingList.remove(input);
            if (ret != null) {
                this.experienceList.remove(ret);
            }
            return ret != null;
        }
        return false;
    }

    public ItemStack getResult(ItemStack stack) {
        String name;
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        int[] id = OreDictionary.getOreIDs((ItemStack)stack);
        if (id != null && id.length > 0 && !(name = OreDictionary.getOreName((int)id[0])).equals("Unknown")) {
            List lst = OreDictionary.getOres((String)name);
            for (ItemStack itemStack : lst) {
                for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
                    if (!this.compareItemStacks(itemStack, entry.getKey())) continue;
                    return entry.getValue();
                }
            }
        }
        return null;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getPulverizerExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

