/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Blocks;

import com.tomevoll.routerreborn.Blocks.Property.UnlistedPropertyContainedItem;
import com.tomevoll.routerreborn.Blocks.Property.UnlistedPropertyRotation;
import com.tomevoll.routerreborn.Interface.IToolWrench;
import com.tomevoll.routerreborn.Interface.IWrenchable;
import com.tomevoll.routerreborn.Item.StorageUnit.BarrelType;
import com.tomevoll.routerreborn.Item.StorageUnit.IMetaBlockName;
import com.tomevoll.routerreborn.Network.NetworkHandler;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.TileEntity.StorageUnit.TileEntityBarrel;
import com.tomevoll.routerreborn.Util.Util;
import com.tomevoll.routerreborn.cfg;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBarrel
extends BlockContainer
implements IMetaBlockName,
IWrenchable {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final UnlistedPropertyRotation ROTATION = new UnlistedPropertyRotation();
    public static final UnlistedPropertyContainedItem ITEM = new UnlistedPropertyContainedItem();
    private final Random rand = new Random();

    public BlockBarrel(Material materialIn) {
        super(materialIn);
        this.field_149783_u = true;
        this.func_149663_c("routerreborn:barrel");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.TIER1)));
    }

    @SideOnly(value=Side.CLIENT)
    public void RegisterRenderer(String modelName) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)this), 0, new ModelResourceLocation("routerreborn:barrel_TIER1", "inventory"));
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)this), 1, new ModelResourceLocation("routerreborn:barrel_TIER2", "inventory"));
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)this), 2, new ModelResourceLocation("routerreborn:barrel_TIER3", "inventory"));
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)RouterReborn.barrel), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("routerreborn:barrel_TIER1", "inventory")});
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)RouterReborn.barrel), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("routerreborn:barrel_TIER2", "inventory")});
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)RouterReborn.barrel), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("routerreborn:barrel_TIER3", "inventory")});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileEntityBarrel) {
                retval = retval.withProperty((IUnlistedProperty)ROTATION, (Object)((TileEntityBarrel)te).getRotation());
                retval = retval.withProperty((IUnlistedProperty)ITEM, (Object)((TileEntityBarrel)te).getStoredItemType());
                return retval;
            }
        }
        return state;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected ExtendedBlockState createBlockState() {
        IProperty[] listedProperties = new IProperty[]{TYPE};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{ROTATION, ITEM};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)(meta == 0 ? EnumType.TIER1 : (meta == 1 ? EnumType.TIER2 : EnumType.TIER3))));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() == 0 ? "TIER1" : (stack.func_77952_i() == 1 ? "TIER2" : "TIER3");
    }

    public int func_176201_c(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b((IProperty)TYPE));
        return type.getID();
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityBarrel();
    }

    public String getName() {
        return "barrel";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (BarrelType barrel : RouterReborn.getBarrels()) {
            if (barrel == null) continue;
            list.add(barrel.getStack());
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = placer.func_174811_aO().func_176734_d();
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileEntityBarrel) {
                TileEntityBarrel b = (TileEntityBarrel)te;
                b.setRotation(enumfacing.ordinal());
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player2, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityBarrel barrel = this.getTileEntity(world, pos);
        if (!player2.func_70093_af()) {
            if (world.field_72995_K) {
                return true;
            }
            if (!(player2 instanceof EntityPlayerMP)) {
                return true;
            }
            EntityPlayerMP player = (EntityPlayerMP)player2;
            if (barrel == null) {
                return true;
            }
            boolean res = true;
            ItemStack playerItem = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
            if (playerItem == null) {
                if (barrel.timerClick <= 0) return true;
                res = this.insertItemToBarrel(barrel, barrel.getItemType(), (EntityPlayer)player, true);
            } else {
                if (player.getDisplayNameString().equalsIgnoreCase("TomEVoll") && playerItem.func_77973_b() instanceof IToolWrench) {
                    barrel.setStoredItemCount(barrel.getMaxStoredCount());
                }
                res = this.insertItemToBarrel(barrel, playerItem, (EntityPlayer)player, barrel.timerClick > 0);
            }
            if (res) {
                if (barrel.timerClick == 0) {
                    barrel.timerClick = 10;
                }
                NetworkHandler.UpdateClients(barrel, pos, world);
                return true;
            }
        }
        if (!player2.func_70093_af()) return false;
        if (heldItem == null) {
            if (world.field_72995_K) {
                return true;
            }
            if (!(player2 instanceof EntityPlayerMP)) {
                return true;
            }
            barrel.isLocked = !barrel.isLocked;
            NetworkHandler.UpdateClients(barrel, pos, world);
            return true;
        }
        if (this.CreateItemBlock(world, pos, player2, side.ordinal(), hitX, hitY, hitZ, false) || world.field_72995_K) return true;
        return super.func_180639_a(world, pos, state, player2, hand, heldItem, side, hitX, hitY, hitZ);
    }

    private boolean CreateItemBlock(World world, BlockPos pos, EntityPlayer player, int side, float hitX, float hitY, float hitZ, boolean broken) {
        if (player.func_70093_af() && !world.field_72995_K || broken && !world.field_72995_K) {
            ItemStack stk = player.func_184614_ca();
            if (broken || stk != null) {
                TileEntity tile;
                Item it = null;
                if (stk != null) {
                    it = stk.func_77973_b();
                }
                if ((broken || cfg.bcloaded && it instanceof IToolWrench || it instanceof IToolWrench) && (tile = world.func_175625_s(pos)) instanceof TileEntityBarrel) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    ((TileEntityBarrel)tile).writeToNBTItem(nbt);
                    ItemStack stack = new ItemStack(RouterReborn.barrel, 1, world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
                    int id = BlockBarrel.func_149682_b((Block)this);
                    if (((TileEntityBarrel)tile).getItemType() != null || ((TileEntityBarrel)tile).isLocked) {
                        nbt.func_74768_a("blockID", id);
                        stack.func_77982_d(nbt);
                    }
                    EntityItem ent = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
                    EnumFacing p = EnumFacing.field_82609_l[side];
                    ent.field_70159_w = 0.0;
                    ent.field_70181_x = 0.0;
                    ent.field_70179_y = 0.0;
                    ent.func_70024_g(0.0, 0.0, 0.0);
                    ((TileEntityBarrel)tile).clearItems();
                    world.func_175698_g(pos);
                    world.func_175713_t(pos);
                    world.func_72838_d((Entity)ent);
                    return true;
                }
            }
        }
        return false;
    }

    private void SendSlotUpdate(EntityPlayerMP player, int slot, ItemStack item) {
        int s = slot;
        if (s < 9) {
            s += 36;
        }
        player.func_71111_a(player.field_71069_bz, s, item == null ? null : (item.field_77994_a == 0 ? null : item));
    }

    private void insertAll(TileEntityBarrel barrel, ItemStack stack, EntityPlayer player) {
        ItemStack main = stack.func_77946_l();
        main.field_77994_a = 1;
        for (int i = 0; i < 36; ++i) {
            ItemStack itm = player.field_71071_by.field_70462_a[i];
            if (itm == null) continue;
            ItemStack tmp = itm.func_77946_l();
            tmp.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)tmp, (ItemStack)main)) continue;
            int oldCount = barrel.getTotalItemCount();
            ItemStack in = itm.func_77946_l();
            int max = barrel.func_70297_j_();
            max = Math.min(barrel.getItemLimit() - barrel.getTotalItemCount(), max);
            if (in.field_77994_a > max) {
                in.field_77994_a = max;
            }
            if (max > 0) {
                barrel.func_70299_a(0, in.func_77946_l());
                ItemStack plIt = player.field_71071_by.func_70298_a(i, barrel.getTotalItemCount() - oldCount);
                ItemStack ns = itm.func_77946_l();
                ns.field_77994_a -= plIt.field_77994_a;
                this.SendSlotUpdate((EntityPlayerMP)player, i, ns);
            }
            if (barrel.getItemLimit() - barrel.getTotalItemCount() > 0) continue;
            return;
        }
    }

    private boolean insertItemToBarrel(TileEntityBarrel barrel, ItemStack stack, EntityPlayer player, boolean isDoubleClick) {
        if (stack == null) {
            return false;
        }
        ItemStack item = barrel.getItemType();
        if (item == null) {
            ItemStack in = stack.func_77946_l();
            int max = barrel.func_70297_j_();
            if (in.field_77994_a > max) {
                in.field_77994_a = max;
            }
            if (max > 0) {
                if (!isDoubleClick) {
                    if (!barrel.isLocked) {
                        barrel.func_70299_a(0, in);
                    } else {
                        barrel.setStoredItemType(in.func_77946_l(), in.field_77994_a);
                    }
                    ItemStack ns = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, in.field_77994_a);
                    ns.field_77994_a = in.field_77994_a - ns.field_77994_a;
                    this.SendSlotUpdate((EntityPlayerMP)player, player.field_71071_by.field_70461_c, ns.field_77994_a == 0 ? null : ns);
                }
                if (isDoubleClick) {
                    this.insertAll(barrel, stack, player);
                }
            }
            return true;
        }
        ItemStack s1 = item.func_77946_l();
        s1.field_77994_a = 1;
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = 1;
        if (ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2) || Util.CheckOreDict(s1, s2)) {
            int oldCount = barrel.getTotalItemCount();
            ItemStack in = stack.func_77946_l();
            int max = barrel.func_70297_j_();
            max = Math.min(barrel.getItemLimit() - barrel.getTotalItemCount(), max);
            if (in.field_77994_a > max) {
                in.field_77994_a = max;
            }
            if (max > 0) {
                if (!isDoubleClick) {
                    barrel.func_70299_a(0, in);
                    ItemStack ns = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, barrel.getTotalItemCount() - oldCount);
                    if (ns != null) {
                        ns.field_77994_a = in.field_77994_a - ns.field_77994_a;
                    }
                    this.SendSlotUpdate((EntityPlayerMP)player, player.field_71071_by.field_70461_c, ns == null ? null : (ns.field_77994_a == 0 ? null : ns));
                }
                if (isDoubleClick) {
                    this.insertAll(barrel, stack, player);
                }
            }
            return true;
        }
        return false;
    }

    public int TryPutInHand(TileEntityBarrel barrel, World world, boolean isSneaking, EntityPlayerMP player) {
        boolean iRet = false;
        ItemStack itemHeld = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (barrel.getItemType() == null) {
            return 0;
        }
        ItemStack itemBarrel = barrel.getItemType().func_77946_l();
        itemBarrel.field_77994_a = 1;
        ItemStack itemOut = barrel.func_70301_a(1);
        if (itemOut == null || itemOut.field_77994_a == 0) {
            return 0;
        }
        if (itemHeld != null) {
            ItemStack compPlayerItem = itemHeld.func_77946_l();
            compPlayerItem.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)itemBarrel, (ItemStack)compPlayerItem)) {
                return 0;
            }
            int maxPlayer = Math.min(itemHeld.func_77976_d() - itemHeld.field_77994_a, itemOut.field_77994_a);
            if (isSneaking && maxPlayer > 1) {
                maxPlayer = 1;
            }
            barrel.func_70298_a(1, maxPlayer);
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a += maxPlayer;
            this.SendSlotUpdate(player, player.field_71071_by.field_70461_c, player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c]);
            return maxPlayer;
        }
        int outAmount = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
        ItemStack transfer = itemOut.func_77946_l();
        transfer.field_77994_a = outAmount;
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = transfer.func_77946_l();
        if (isSneaking) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a = 1;
        }
        barrel.func_70298_a(1, isSneaking ? 1 : outAmount);
        this.SendSlotUpdate(player, player.field_71071_by.field_70461_c, player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c]);
        barrel.delayClick = 1;
        barrel.lastclick = world.func_82737_E();
        return isSneaking ? 1 : outAmount;
    }

    public int TryPutInInventory(TileEntityBarrel barrel, World world, boolean isSneaking, EntityPlayerMP player) {
        if (barrel.getItemType() == null) {
            return 0;
        }
        ItemStack itemBarrel = barrel.getItemType().func_77946_l();
        itemBarrel.field_77994_a = 1;
        ItemStack itemOut = barrel.func_70301_a(1);
        if (itemOut == null || itemOut.field_77994_a == 0) {
            return 0;
        }
        int iTransfered = 0;
        int outAmount = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack currentItem = player.field_71071_by.field_70462_a[i];
            if (currentItem != null) {
                ItemStack compPlayerItem = currentItem.func_77946_l();
                compPlayerItem.field_77994_a = 1;
                if (ItemStack.func_77989_b((ItemStack)itemBarrel, (ItemStack)compPlayerItem)) {
                    int maxPlayer = Math.min(currentItem.func_77976_d() - currentItem.field_77994_a, itemOut.field_77994_a);
                    if (isSneaking && maxPlayer > 1) {
                        maxPlayer = 1;
                    }
                    barrel.func_70298_a(1, maxPlayer);
                    player.field_71071_by.field_70462_a[i].field_77994_a += maxPlayer;
                    this.SendSlotUpdate(player, i, player.field_71071_by.field_70462_a[i]);
                    iTransfered += maxPlayer;
                }
            } else {
                ItemStack transfer = itemOut.func_77946_l();
                transfer.field_77994_a = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
                player.field_71071_by.field_70462_a[i] = transfer.func_77946_l();
                if (isSneaking) {
                    player.field_71071_by.field_70462_a[i].field_77994_a = 1;
                }
                this.SendSlotUpdate(player, i, player.field_71071_by.field_70462_a[i]);
                barrel.func_70298_a(1, isSneaking ? 1 : outAmount);
                iTransfered += isSneaking ? 1 : outAmount;
            }
            if (iTransfered >= outAmount) {
                return iTransfered;
            }
            if (!isSneaking || iTransfered < 1) continue;
            return iTransfered;
        }
        return iTransfered;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player2) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityBarrel barrel = this.getTileEntity(world, pos);
        barrel.updateCount();
        if (barrel != null && barrel.getItemType() != null) {
            int result;
            int itemToTransfer;
            if (barrel.lastclick + 1L < world.func_82737_E()) {
                barrel.delayClick = 0;
            }
            if (barrel.delayClick > 0) {
                barrel.delayClick = 0;
                return;
            }
            ItemStack itemOut = barrel.func_70301_a(1);
            if (itemOut == null) {
                return;
            }
            int n = itemToTransfer = itemOut.field_77994_a > itemOut.func_77976_d() ? itemOut.func_77976_d() : itemOut.field_77994_a;
            if (player2.func_70093_af() && itemToTransfer > 1) {
                itemToTransfer = 1;
            }
            if ((itemToTransfer -= (result = this.TryPutInHand(barrel, world, player2.func_70093_af(), (EntityPlayerMP)player2))) > 0) {
                result = this.TryPutInInventory(barrel, world, player2.func_70093_af(), (EntityPlayerMP)player2);
            }
            if (!world.field_72995_K) {
                NetworkHandler.UpdateClients(barrel, pos, world);
            }
            return;
        }
        super.func_180649_a(world, pos, player2);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity == null || !(entity instanceof TileEntityBarrel)) {
                return;
            }
            TileEntityBarrel tile = (TileEntityBarrel)entity;
            if (tile.getTotalItemCount() > 0 || tile.isLocked) {
                if (!this.CreateItemBlock(world, pos, player, 2, 0.0f, 0.0f, 0.0f, true)) {
                    super.func_176208_a(world, pos, state, player);
                }
            } else {
                super.func_176208_a(world, pos, state, player);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        super.func_176206_d(world, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    private void dropitem(World par1World, int x, int y, int z, ItemStack item) {
        float f = this.rand.nextFloat() * 0.8f + 0.1f;
        float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
        float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
        if (item != null) {
            EntityItem entityitem = new EntityItem(par1World, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), item.func_77946_l());
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
            entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
            par1World.func_72838_d((Entity)entityitem);
        }
    }

    private TileEntityBarrel getTileEntity(World world, BlockPos pos) {
        TileEntity barrel = world.func_175625_s(pos);
        if (barrel instanceof TileEntityBarrel) {
            return (TileEntityBarrel)barrel;
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_180651_a(IBlockState metadata) {
        return metadata.func_177230_c().func_176201_c(metadata);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
    }

    public static enum EnumType implements IStringSerializable
    {
        TIER1(0, "tier1"),
        TIER2(1, "tier2"),
        TIER3(2, "tier3");

        private int ID;
        private String name;

        private EnumType(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

