/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Blocks;

import com.tomevoll.routerreborn.Blocks.BlockBase;
import com.tomevoll.routerreborn.Interface.IToolWrench;
import com.tomevoll.routerreborn.Interface.IWrenchable;
import com.tomevoll.routerreborn.Network.Client.C01_MachineFilter;
import com.tomevoll.routerreborn.Network.Client.RouterNetClientPackage;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.TileEntity.Router.TileEntityRouter;
import com.tomevoll.routerreborn.TileEntity.Router.TileEntityRouterBase;
import com.tomevoll.routerreborn.cfg;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockRouter
extends BlockBase
implements IWrenchable {
    public int power = 0;
    public boolean hasPower = false;

    public BlockRouter(Material materialIn) {
        super(materialIn);
        this.field_149783_u = true;
        this.func_149663_c("routerreborn:router");
    }

    public static void setRedstone(int strength, World worldObj, int xCoord, int yCoord, int zCoord) {
        Block blc = worldObj.func_180495_p(new BlockPos(xCoord, yCoord, zCoord)).func_177230_c();
        if (!(blc instanceof BlockRouter)) {
            return;
        }
        TileEntityRouter tile = (TileEntityRouter)worldObj.func_175625_s(new BlockPos(xCoord, yCoord, zCoord));
        int i = tile.power;
        if (i != strength) {
            BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
            ((BlockRouter)blc).power = strength;
            tile.power = strength;
            worldObj.func_175685_c(pos, blc);
        }
        ((BlockRouter)blc).hasPower = strength > 0;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public void RegisterRenderer(String modelName) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)this), 0, new ModelResourceLocation("routerreborn:" + modelName, "inventory"));
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int func_176211_b(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRouter) {
            int i = ((TileEntityRouter)tile).power;
            return i;
        }
        return 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.func_176211_b(state, worldIn, pos, side);
    }

    public boolean isPowered(IBlockState state) {
        return this.hasPower;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_149744_f(state) && side != null;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_149738_a(World par1World) {
        return 2;
    }

    @Override
    public void openGui(EntityPlayerMP player, RouterReborn upCore, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRouter) {
            int slot;
            TileEntityRouter tr = (TileEntityRouter)te;
            String s = "";
            if (this.CheckAchivement(player) || (slot = player.field_71071_by.func_70447_i()) > -1) {
                // empty if block
            }
            ArrayList<TileEntityRouterBase.Inventory> lst = tr.scanForInventory(true);
            if (!tr.upgRedstone) {
                tr.upgRedstone = true;
            }
            s = String.format("%d:%d:%d:%d:%d:%d:%d:%s:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1, tr.upgBandwidth ? 1 : 0, tr.upgNoDelay ? 1 : 0, tr.upgMachineFilter ? 1 : 0, tr.filterMachine, tr.useSide.ordinal(), tr.mode == TileEntityRouterBase.IOMODE.EXTRACT ? 1 : 0, tr.useSlot, tr.upgItemFilter ? 1 : 0, tr.upgThorow ? 1 : 0, tr.ejectSide.ordinal(), tr.upgEject ? 1 : 0, tr.upgRedstone ? 1 : 0, tr.redstoneType, tr.itemBlacklist ? 1 : 0, tr.machineBlackList ? 1 : 0, tr.visitNear ? 1 : 0, tr.ignoreMetadata ? 1 : 0, tr.sMode == TileEntityRouterBase.MODE.SIDED ? 1 : 0);
            RouterReborn.network.sendTo((IMessage)new RouterNetClientPackage(s), player);
            ArrayList<String> machines = new ArrayList<String>();
            if (lst != null) {
                for (int i1 = 0; i1 < lst.size(); ++i1) {
                    boolean found = false;
                    for (int j = 0; j < machines.size(); ++j) {
                        if (!((String)machines.get(j)).equalsIgnoreCase(lst.get((int)i1).invName)) continue;
                        found = true;
                    }
                    if (found) continue;
                    machines.add(lst.get((int)i1).invName);
                }
            }
            String s2 = String.format("%d:%d:%d:%d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 2);
            for (int i = 0; i < machines.size(); ++i) {
                s2 = s2 + ":" + (String)machines.get(i);
            }
            RouterReborn.network.sendTo((IMessage)new RouterNetClientPackage(s2), player);
            RouterReborn.network.sendTo((IMessage)new C01_MachineFilter(tr, tr.filterMachine), player);
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)RouterReborn.instance, (int)1, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
    }

    public boolean isNormalCube() {
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stk;
        if (!world.field_72995_K && heldItem != null && heldItem.func_77973_b().equals(RouterReborn.itmCF)) {
            return false;
        }
        if (player.func_70093_af() && !world.field_72995_K && (stk = heldItem) != null) {
            TileEntity tile;
            Item it = stk.func_77973_b();
            if ((cfg.bcloaded && it instanceof IToolWrench || it instanceof IToolWrench) && (tile = world.func_175625_s(pos)) instanceof TileEntityRouter) {
                NBTTagCompound nbt = new NBTTagCompound();
                tile.func_189515_b(nbt);
                ItemStack stack = new ItemStack(RouterReborn.itemRouterBlock);
                int id = BlockRouter.func_149682_b((Block)this);
                nbt.func_74768_a("blockID", id);
                stack.func_77982_d(nbt);
                EntityItem ent = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
                EnumFacing p = side;
                ent.field_70159_w = 0.0;
                ent.field_70181_x = 0.0;
                ent.field_70179_y = 0.0;
                ent.func_70024_g(0.0, 0.0, 0.0);
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                world.func_72838_d((Entity)ent);
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState meta) {
        return new TileEntityRouter();
    }

    @Override
    public Block onPicked() {
        return this;
    }

    @Override
    public Block blockDropped(World world, EntityPlayer player, int x, int y, int z) {
        return this;
    }
}

