/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Gui;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class LangTranslate {
    private final Pattern numericVariablePattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private final Splitter equalSignSplitter = Splitter.on((char)'=').limit(2);
    private Map languageList;
    private long lastUpdateTimeInMilliseconds;

    public LangTranslate(String modid) {
        String lang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        InputStream inputstream = LangTranslate.class.getResourceAsStream("/assets/" + modid + "/lang/" + lang + ".lang");
        this.languageList = Maps.newHashMap();
        this.inject(this, inputstream);
    }

    public void inject(InputStream inputstream) {
        this.inject(this, inputstream);
    }

    private void inject(LangTranslate inst, InputStream inputstream) {
        HashMap<String, String> map = this.parseLangFile(inputstream);
        if (inst != null) {
            inst.languageList.putAll(map);
            inst.lastUpdateTimeInMilliseconds = System.currentTimeMillis();
        }
    }

    private HashMap<String, String> parseLangFile(InputStream inputstream) {
        HashMap table = Maps.newHashMap();
        try {
            for (String s : IOUtils.readLines((InputStream)inputstream, (Charset)Charsets.UTF_8)) {
                String[] astring;
                if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)this.equalSignSplitter.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
                String s1 = astring[0];
                String s2 = this.numericVariablePattern.matcher(astring[1]).replaceAll("%$1s");
                table.put(s1, s2);
            }
        }
        catch (Exception ioexception) {
            return table;
        }
        return table;
    }

    public synchronized void replaceWith(Map p_135063_0_) {
        this.languageList.clear();
        this.languageList.putAll(p_135063_0_);
        this.lastUpdateTimeInMilliseconds = System.currentTimeMillis();
    }

    public synchronized String translateKey(String p_74805_1_) {
        return this.tryTranslateKey(p_74805_1_);
    }

    public synchronized String translateKeyFormat(String p_74803_1_, Object ... p_74803_2_) {
        String s1 = this.tryTranslateKey(p_74803_1_);
        try {
            return String.format(s1, p_74803_2_);
        }
        catch (IllegalFormatException illegalformatexception) {
            return "Format error: " + s1;
        }
    }

    private String tryTranslateKey(String p_135064_1_) {
        String s1 = (String)this.languageList.get(p_135064_1_);
        return s1 == null ? p_135064_1_ : s1;
    }

    public synchronized boolean containsTranslateKey(String p_94520_1_) {
        return this.languageList.containsKey(p_94520_1_);
    }

    public long getLastUpdateTimeInMilliseconds() {
        return this.lastUpdateTimeInMilliseconds;
    }
}

