/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Item;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBattery
extends Item
implements IEnergyContainerItem {
    private EnergyStorage storage = null;
    private int capacity = 0;

    public ItemBattery(int capacity) {
        this.capacity = capacity;
        this.field_77777_bU = 1;
        this.func_77656_e(100);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        this.storage = new EnergyStorage(this.capacity, 200);
        NBTTagCompound nbt = new NBTTagCompound();
        this.storage.setCapacity(this.capacity);
        this.storage.setEnergyStored(0);
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("MaxEnergy", this.capacity);
        item.func_77656_e(100);
        ItemStack toAdd = new ItemStack(item, 1, 0);
        toAdd.func_77964_b(100);
        toAdd.func_77982_d(nbt.func_74737_b());
        list.add(toAdd.func_77946_l());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        NBTTagCompound tag = container.func_77978_p();
        if (tag == null) {
            return 0;
        }
        if (!tag.func_74764_b("MaxEnergy")) {
            return 0;
        }
        int max = tag.func_74762_e("MaxEnergy");
        if (!tag.func_74764_b("Energy")) {
            return 0;
        }
        this.storage = new EnergyStorage(max);
        this.storage.readFromNBT(container.func_77978_p());
        int ret = this.storage.receiveEnergy(maxReceive, simulate);
        NBTTagCompound tag2 = new NBTTagCompound();
        tag2.func_74768_a("MaxEnergy", max);
        this.storage.writeToNBT(tag2);
        container.func_77982_d(tag2);
        int dmg = (int)((float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 100.0f);
        container.func_77964_b(101 - dmg);
        return ret;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        NBTTagCompound tag = container.func_77978_p();
        if (tag == null) {
            return 0;
        }
        if (!tag.func_74764_b("MaxEnergy")) {
            return 0;
        }
        int max = tag.func_74762_e("MaxEnergy");
        if (!tag.func_74764_b("Energy")) {
            return 0;
        }
        this.storage = new EnergyStorage(max);
        this.storage.readFromNBT(container.func_77978_p());
        int ret = this.storage.extractEnergy(maxExtract, simulate);
        NBTTagCompound tag2 = new NBTTagCompound();
        tag2.func_74768_a("MaxEnergy", max);
        this.storage.writeToNBT(tag2);
        container.func_77982_d(tag2);
        int dmg = (int)((float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 100.0f);
        container.func_77964_b(101 - dmg);
        return ret;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        NBTTagCompound tag = container.func_77978_p();
        if (tag == null) {
            return 0;
        }
        if (!tag.func_74764_b("MaxEnergy")) {
            return 0;
        }
        if (!tag.func_74764_b("Energy")) {
            return 0;
        }
        int stored = tag.func_74762_e("Energy");
        return stored;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        NBTTagCompound tag = container.func_77978_p();
        if (tag == null) {
            return 0;
        }
        if (!tag.func_74764_b("MaxEnergy")) {
            return 0;
        }
        int max = tag.func_74762_e("MaxEnergy");
        if (!tag.func_74764_b("Energy")) {
            return 0;
        }
        return max;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        int max = this.getMaxEnergyStored(stack);
        int stored = this.getEnergyStored(stack);
        tooltip.add("RF: " + stored + "/" + max);
    }
}

