/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.tomevoll.routerreborn.API.BlockUtil;
import com.tomevoll.routerreborn.Item.rfToolBase;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.Util.Raytrace;
import com.tomevoll.routerreborn.Util.Util;
import com.tomevoll.routerreborn.cfg;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class itemToolPickaxe
extends rfToolBase {
    private static final Set blocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc, Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh});
    public String toolClass = "pickaxe";
    public int currentMode = 0;
    private float damageVsEntity;
    private float efficiencyOnProperMaterial;
    private Item.ToolMaterial material;

    public itemToolPickaxe(Item.ToolMaterial material) {
        super(material, blocks);
        this.func_77655_b("pickaxe");
        this.func_77637_a(RouterReborn.ueTab);
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.efficiencyOnProperMaterial = material.func_77998_b();
        this.damageVsEntity = (float)material.func_77996_d() + material.func_78000_c();
        this.material = material;
        this.material.setRepairItem(new ItemStack(Items.field_151137_ax));
        this.field_77789_bW = true;
        if (cfg.enablepickaxerecipe) {
            GameRegistry.registerItem((Item)this, (String)"pickaxe");
        }
    }

    public static void checkBlocksAndHarvest(EntityPlayer player, BlockPos pos, EnumFacing side) {
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block != null && block.getHarvestLevel(player.field_70170_p.func_180495_p(pos)) <= RouterReborn.itemPickaxe.getHarvestLevel(new ItemStack(RouterReborn.itemPickaxe), ((itemToolPickaxe)RouterReborn.itemPickaxe).toolClass) && block.func_176195_g(player.field_70170_p.func_180495_p(pos), player.field_70170_p, pos) >= 0.0f) {
            ItemStack itemstack = player.func_184614_ca();
            itemToolPickaxe item = (itemToolPickaxe)itemstack.func_77973_b();
            if (itemstack.func_77952_i() < item.material.func_77997_a() && player.func_175151_a(pos, side, itemstack)) {
                block.func_180657_a(player.field_70170_p, player, pos, player.field_70170_p.func_180495_p(pos), player.field_70170_p.func_175625_s(pos), itemstack);
                block.func_180637_b(player.field_70170_p, pos, block.getExpDrop(player.field_70170_p.func_180495_p(pos), (IBlockAccess)player.field_70170_p, pos, 0));
                item.func_179218_a(itemstack, player.field_70170_p, player.field_70170_p.func_180495_p(pos), pos, (EntityLivingBase)player);
                player.field_70170_p.func_175698_g(pos);
                BlockUtil.markBlockForUpdate(player.field_70170_p, pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        Block block = blockIn.func_177230_c();
        int bhl = block.getHarvestLevel(block.func_176223_P());
        int phl = this.getHarvestLevel(new ItemStack((Item)this), this.toolClass);
        return block.getHarvestLevel(block.func_176223_P()) <= this.getHarvestLevel(new ItemStack((Item)this), this.toolClass);
    }

    public void RegisterRenderer(String modelName) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)this, 0, new ModelResourceLocation("routerreborn:" + modelName, "inventory"));
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return this.material.func_77996_d();
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"axe", (Object)"shovel");
    }

    public boolean func_150897_b(Block p_150897_1_) {
        int bhl = p_150897_1_.getHarvestLevel(p_150897_1_.func_176223_P());
        int phl = this.getHarvestLevel(new ItemStack((Item)this), this.toolClass);
        return p_150897_1_.getHarvestLevel(p_150897_1_.func_176223_P()) <= this.getHarvestLevel(new ItemStack((Item)this), this.toolClass);
    }

    public void saveNBT(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (tag.func_74764_b("pickaxemode")) {
            tag.func_82580_o("pickaxemode");
        }
        tag.func_74768_a("pickaxemode", this.currentMode);
        stack.func_77982_d(tag);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            ++this.currentMode;
            if (this.currentMode > 2) {
                this.currentMode = 0;
            }
            String message = "";
            switch (this.currentMode) {
                case 0: {
                    message = "\u00a77Mode: \u00a7asingle block";
                    break;
                }
                case 1: {
                    message = "\u00a77Mode: \u00a7a3x3";
                    break;
                }
                case 2: {
                    message = "\u00a77Mode: \u00a7a5x5";
                    break;
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
            this.saveNBT(item);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)item);
        }
        return super.func_77659_a(item, world, player, hand);
    }

    public boolean func_179218_a(ItemStack item, World world, IBlockState block, BlockPos pos, EntityLivingBase entity) {
        if (this.material.func_77997_a() - item.func_77952_i() == 1) {
            item.func_77964_b(this.material.func_77997_a());
            return false;
        }
        return super.func_179218_a(item, world, block, pos, entity);
    }

    public boolean hasInteraction(Block block, World world, BlockPos pos) {
        return block instanceof IInteractionObject;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && cfg.pickaxecanplacetorches && hand == EnumHand.MAIN_HAND) {
            Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (block != null && !this.hasInteraction(block, world, pos) && tile == null && !(block instanceof BlockWorkbench) && this.placeTorch(new ItemStack(Blocks.field_150478_aa, 1), player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing.ordinal(), hitX, hitY, hitZ)) {
                return world.field_72995_K ? super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ) : EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public int getCurrentMode(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b("pickaxemode")) {
                return tag.func_74762_e("pickaxemode");
            }
            return 0;
        }
        return 0;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        this.currentMode = tag != null ? (tag.func_74764_b("pickaxemode") ? tag.func_74762_e("pickaxemode") : 0) : 0;
        if (player.func_70093_af()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        Raytrace.RayTraceResult mop = Raytrace.collisionRayTrace(player.field_70170_p, pos, player, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), 0, null);
        if (mop == null) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        EnumFacing sideHit = mop.hit.field_178784_b;
        int breakRadius = this.currentMode;
        int breakDepth = 0;
        int xRange = breakRadius;
        int yRange = breakRadius;
        int zRange = breakDepth;
        switch (sideHit) {
            case DOWN: 
            case UP: {
                yRange = breakDepth;
                zRange = breakRadius;
                break;
            }
            case NORTH: 
            case SOUTH: {
                xRange = breakRadius;
                zRange = breakDepth;
                break;
            }
            case WEST: 
            case EAST: {
                xRange = breakDepth;
                zRange = breakRadius;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (xPos == x && yPos == y && zPos == z || super.onBlockStartBreak(stack, new BlockPos(xPos, yPos, zPos), player)) continue;
                    Util.breakExtraBlock(player.field_70170_p, new BlockPos(xPos, yPos, zPos), sideHit.func_176745_a(), player, x, y, z);
                }
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        try {
            par3List.set(0, "\u00a73" + I18n.func_74838_a((String)(this.func_77658_a() + ".name")) + "\u00a7r");
            NBTTagCompound tag = par1ItemStack.func_77978_p();
            if (tag != null && tag.func_74764_b("pickaxemode")) {
                this.currentMode = tag.func_74762_e("pickaxemode");
            }
            par3List.add("");
            switch (this.currentMode) {
                case 0: {
                    par3List.add("\u00a77Mode: \u00a7asingle block");
                    break;
                }
                case 1: {
                    par3List.add("\u00a77Mode: \u00a7a3x3");
                    break;
                }
                case 2: {
                    par3List.add("\u00a77Mode: \u00a7a5x5");
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int i, boolean p_77663_5_) {
        super.func_77663_a(item, world, entity, i, p_77663_5_);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.material.func_77997_a() - stack.func_77952_i() == 1) {
            return -1.0f;
        }
        if (this.material.func_77997_a() - stack.func_77952_i() < 1) {
            return -1.0f;
        }
        if (this.func_150897_b(state.func_177230_c())) {
            if (state.func_177230_c().getHarvestTool(state) == "shovel") {
                return 7.5f;
            }
            if (state.func_177230_c().getHarvestTool(state) == "pickaxe") {
                return 8.0f;
            }
            if (state.func_177230_c().getHarvestTool(state) == "axe") {
                return 8.0f;
            }
        }
        return this.efficiencyOnProperMaterial;
    }

    public float func_150893_a(ItemStack p_150893_1_, Block p_150893_2_) {
        return this.efficiencyOnProperMaterial;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        p_77644_1_.func_77972_a(2, p_77644_3_);
        return true;
    }

    public Item.ToolMaterial func_150913_i() {
        return this.material;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String func_77861_e() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        if (p_82789_1_ == null || p_82789_2_ == null || this.material.getRepairItemStack() == null) {
            return false;
        }
        return this.material.customCraftingMaterial == p_82789_2_.func_77973_b() || super.func_82789_a(p_82789_1_, p_82789_2_);
    }

    public boolean func_77645_m() {
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            Multimap multimap = super.func_111205_h(equipmentSlot);
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Tool modifier", (double)this.damageVsEntity, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Tool modifier", 0.04, 0));
            return multimap;
        }
        return super.func_111205_h(equipmentSlot);
    }

    public boolean placeTorch(ItemStack item, EntityPlayer player, World world, int posX, int posY, int posZ, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c();
        if (block == Blocks.field_150431_aC && (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c().func_176201_c(world.func_180495_p(new BlockPos(posX, posY, posZ))) & 7) < 1) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I) {
            if (side == 0) {
                --posY;
            }
            if (side == 1) {
                ++posY;
            }
            if (side == 2) {
                --posZ;
            }
            if (side == 3) {
                ++posZ;
            }
            if (side == 4) {
                --posX;
            }
            if (side == 5) {
                ++posX;
            }
        }
        if (item.field_77994_a == 0) {
            return false;
        }
        Block torch = Block.func_149634_a((Item)item.func_77973_b());
        if (world.func_175716_a(torch, new BlockPos(posX, posY, posZ), false, EnumFacing.field_82609_l[side], null, item)) {
            if (world.field_72995_K) {
                world.func_184134_a((double)posX, (double)posY, (double)posZ, SoundEvents.field_187891_gV, SoundCategory.PLAYERS, 1.0f, 1.0f, true);
                return true;
            }
            IBlockState state = torch.func_180642_a(world, new BlockPos(posX, posY, posZ), EnumFacing.field_82609_l[side], hitX, hitY, hitZ, 0, (EntityLivingBase)player);
            int i1 = state.func_177230_c().func_176201_c(state);
            if (world.func_180501_a(new BlockPos(posX, posY, posZ), state, 3) && world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() == torch) {
                torch.func_180633_a(world, new BlockPos(posX, posY, posZ), state, (EntityLivingBase)player, item);
            }
        }
        return true;
    }
}

