/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.TileEntity.Chest;

import com.tomevoll.routerreborn.Blocks.BlockChest;
import com.tomevoll.routerreborn.Interface.IUpgrades;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.TileEntity.Chest.InventoryChest;
import com.tomevoll.routerreborn.TileEntity.Router.TileEntityRouterBase;
import com.tomevoll.routerreborn.Util.ChestUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityChest
extends InventoryChest
implements ITickable {
    public String dataPath = "";
    public ItemStack[][] upgrades = new ItemStack[6][9];
    public float angle;
    public float oldAngle;
    public int open;
    public TileEntity[] invs = new TileEntity[6];
    boolean hadInit = false;
    private int tickTimer;
    private boolean hasCustomName = true;

    public TileEntityChest() {
        super.setInventoryName("Special Chest");
    }

    @Override
    public String func_70005_c_() {
        return this.inventoryTitle;
    }

    @Override
    public boolean func_145818_k_() {
        return this.hasCustomName;
    }

    @Override
    public void setInventoryName(String p_110133_1_) {
        this.setCustomName(p_110133_1_);
    }

    public void setCustomName(String inventoryTitleIn) {
        this.hasCustomName = true;
        this.inventoryTitle = inventoryTitleIn;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.func_70005_c_(), new Object[0]) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void TileNeighborChanged(int ofX, int ofY, int ofZ, TileEntity t) {
        if (!this.field_145850_b.field_72995_K) {
            this.invs = new TileEntity[6];
            for (int i = 0; i < TileEntityRouterBase.ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                TileEntityRouterBase.ForgeDirection dir = TileEntityRouterBase.ForgeDirection.VALID_DIRECTIONS[i];
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
                if (!(tile instanceof IInventory) && (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[dir.getOpposite().ordinal()]))) continue;
                this.invs[dir.ordinal()] = tile;
            }
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public void onLoad() {
        super.onLoad();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.hadInit) {
            for (int i = 0; i < TileEntityRouterBase.ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                TileEntityRouterBase.ForgeDirection dir = TileEntityRouterBase.ForgeDirection.VALID_DIRECTIONS[i];
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
                if (tile instanceof IInventory || tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[dir.getOpposite().ordinal()])) {
                    this.invs[dir.ordinal()] = tile;
                }
                this.hadInit = true;
            }
        }
        if (++this.tickTimer % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, RouterReborn.chest, 1, this.open);
        }
        this.oldAngle = this.angle;
        float f = 0.1f;
        if (this.open > 0 && this.angle == 0.0f) {
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
        }
        if (this.open == 0 && this.angle > 0.0f || this.open > 0 && this.angle < 1.0f) {
            float f1;
            float f2 = this.angle;
            this.angle = this.open > 0 ? (this.angle += f) : (this.angle -= f);
            if (this.angle > 1.0f) {
                this.angle = 1.0f;
            }
            if (this.angle < (f1 = 0.5f) && f2 >= f1) {
                double d1 = (double)this.field_174879_c.func_177958_n() + 0.5;
                double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
            }
            if (this.angle < 0.0f) {
                this.angle = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 2L == 0L) {
            for (int side = 0; side < this.upgrades.length; ++side) {
                for (int slot = 0; slot < this.upgrades[side].length; ++slot) {
                    ItemStack upg = this.upgrades[side][slot];
                    if (upg == null || !(upg.func_77973_b() instanceof IUpgrades)) continue;
                    ((IUpgrades)upg.func_77973_b()).doUpgradeUpdate(this.field_145850_b, side, this.upgrades[side], (IInventory)this, upg, this.invs);
                }
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.open = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.open < 0) {
                this.open = 0;
            }
            ++this.open;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.open);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q());
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockChest) {
            --this.open;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.open);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q());
        }
    }

    @Override
    public void closeInventory() {
    }

    @Override
    public void openInventory() {
    }

    public void openChest() {
        ++this.open;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175641_c(this.field_174879_c, RouterReborn.chest, 1, this.open);
        }
    }

    public void closeChest() {
        --this.open;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175641_c(this.field_174879_c, RouterReborn.chest, 1, this.open);
        }
    }

    public boolean playerCanInteract(EntityPlayer p_145971_1_) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && p_145971_1_.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound p_145841_1_) {
        p_145841_1_ = super.func_189515_b(p_145841_1_);
        p_145841_1_.func_74782_a("inventory", (NBTBase)super.saveInventoryToNBT());
        NBTTagList list = new NBTTagList();
        for (int side = 0; side < this.upgrades.length; ++side) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList slots = new NBTTagList();
            for (int slot = 0; slot < this.upgrades[side].length; ++slot) {
                NBTTagCompound itm = new NBTTagCompound();
                itm.func_74774_a("Slot", (byte)slot);
                if (this.upgrades[side][slot] != null) {
                    this.upgrades[side][slot].func_77955_b(itm);
                } else {
                    new ItemStack((Block)null).func_77955_b(itm);
                }
                slots.func_74742_a((NBTBase)itm);
            }
            tag.func_74782_a("slots", (NBTBase)slots);
            list.func_74742_a((NBTBase)tag);
        }
        p_145841_1_.func_74782_a("upgrades", (NBTBase)list);
        return p_145841_1_;
    }

    public void func_145839_a(NBTTagCompound p_145839_1_) {
        super.func_145839_a(p_145839_1_);
        super.loadInventoryFromNBT(p_145839_1_.func_150295_c("inventory", 10));
        NBTTagList lst = p_145839_1_.func_150295_c("upgrades", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tag = lst.func_150305_b(i);
            NBTTagList slotlst = tag.func_150295_c("slots", 10);
            for (int x = 0; x < slotlst.func_74745_c(); ++x) {
                NBTTagCompound slot = slotlst.func_150305_b(x);
                byte islot = slot.func_74771_c("Slot");
                this.upgrades[i][islot] = ItemStack.func_77949_a((NBTTagCompound)slot);
            }
        }
    }

    public TileEntityChest getInventoryChest() {
        return this;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        ItemStack stack = null;
        if (slot >= 0 && slot < this.inventoryContents.length) {
            stack = this.inventoryContents[slot];
            return stack;
        }
        int side = slot / 100;
        int s = slot % 100;
        return this.upgrades[--side][s];
    }

    @Override
    public ItemStack func_70298_a(int slot, int count) {
        if (slot >= 0 && slot < this.inventoryContents.length) {
            if (this.inventoryContents[slot] != null) {
                if (this.inventoryContents[slot].field_77994_a <= count) {
                    ItemStack itemstack = this.inventoryContents[slot].func_77946_l();
                    this.inventoryContents[slot] = null;
                    this.func_70296_d();
                    return itemstack;
                }
                ItemStack itemstack = this.inventoryContents[slot].func_77979_a(count);
                if (this.inventoryContents[slot].field_77994_a == 0) {
                    this.inventoryContents[slot] = null;
                }
                this.func_70296_d();
                return itemstack;
            }
            return null;
        }
        int side = slot / 100;
        int s = slot % 100;
        if (this.upgrades[--side][s] != null) {
            if (this.upgrades[side][s].field_77994_a <= count) {
                ItemStack itemstack = this.upgrades[side][s];
                this.upgrades[side][s] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.upgrades[side][s].func_77979_a(count);
            if (this.upgrades[side][s].field_77994_a == 0) {
                this.upgrades[side][s] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int slot) {
        if (slot >= 0 && slot < this.inventoryContents.length) {
            if (this.inventoryContents[slot] != null) {
                ItemStack itemstack = this.inventoryContents[slot];
                this.inventoryContents[slot] = null;
                return itemstack;
            }
            return null;
        }
        int side = slot / 100;
        int s = slot % 100;
        if (this.upgrades[--side][s] != null) {
            ItemStack itemstack = this.upgrades[side][s];
            this.upgrades[side][s] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack item) {
        if (slot >= 0 && slot < this.inventoryContents.length) {
            this.inventoryContents[slot] = item;
            if (item != null && item.field_77994_a > this.func_70297_j_()) {
                item.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
            return;
        }
        int side = slot / 100;
        int s = slot % 100;
        this.upgrades[--side][s] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    @Override
    public int func_70302_i_() {
        return this.slotsCount;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack item, EnumFacing direction) {
        return ChestUtil.checkFilter(item, this.upgrades[direction.ordinal()]);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack item, EnumFacing side) {
        if (this.upgrades[side.ordinal()] != null) {
            return ChestUtil.checkFilter(item, this.upgrades[side.ordinal()]);
        }
        return true;
    }
}

