/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.TileEntity.Router;

import com.tomevoll.routerreborn.API.BlockUtil;
import com.tomevoll.routerreborn.Blocks.BlockRouter;
import com.tomevoll.routerreborn.Interface.ICammo;
import com.tomevoll.routerreborn.Interface.IInventoryCable;
import com.tomevoll.routerreborn.Network.NetworkHandler;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.TileEntity.Router.TileEntityBase;
import com.tomevoll.routerreborn.TileEntity.Router.TileEntityRouter;
import com.tomevoll.routerreborn.Util.cableUtil;
import com.tomevoll.routerreborn.cfg;
import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class TileEntityRouterBase
extends TileEntityBase
implements ICammo {
    private static final ExecutorService pool = Executors.newFixedThreadPool(cfg.threadLimit);
    public int lastTab = 0;
    public boolean upgRedstone = true;
    public int redstoneType = 0;
    public boolean visitNear = false;
    public boolean machineBlackList = false;
    public boolean itemBlacklist = false;
    public boolean ignoreMetadata = false;
    public boolean upgEject = false;
    public ForgeDirection ejectSide = ForgeDirection.UNKNOWN;
    public boolean upgThorow = false;
    public boolean upgItemFilter = false;
    public boolean upgBandwidth = false;
    public boolean upgCamouflage = false;
    public int useSlot = 0;
    public ForgeDirection useSide = ForgeDirection.DOWN;
    public boolean upgMachineFilter = false;
    public boolean upgNoDelay = false;
    public boolean awaitScan = false;
    public TileEntity eject = null;
    public MODE sMode = MODE.SIDED;
    public ArrayList<String> filterMachine = new ArrayList();
    public IOMODE mode = IOMODE.OUTPUT;
    public int rotation = 0;
    public ArrayList<String> mcList = new ArrayList();
    public ArrayList<Inventory> activeTileList;
    public ArrayList<TileEntity> cableTileList;
    public Stack<TileEntity> scanList;
    public Stack<TileEntity> scanApproved;
    public ArrayList<Future<String>> scanbreakblock = new ArrayList();
    public Future<ArrayList<Inventory>> scanner;
    public boolean awaitResult = false;
    public ItemStack lastItem = null;
    public int delayUpdate = 0;
    public boolean hasInit = false;
    protected POS newpos;
    ArrayList<Future<POS>> scannewblock = new ArrayList();
    private int lastIndx = 0;
    private ItemStack cammo = null;
    private boolean lastRSstate = false;

    public TileEntityRouterBase() {
        this.slots = new ItemStack[11];
        slots_bottom = new int[]{0};
        slots_side = new int[]{0};
        slots_top = new int[]{0};
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RouterReborn.routers.add(this);
            this.hasInit = false;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RouterReborn.routers.remove(this);
        }
    }

    public void setMode(IOMODE tmp) {
        this.mode = tmp;
    }

    @Override
    public void setCammo(ItemStack stack, EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound upd = new NBTTagCompound();
            this.cammo = stack;
            this.writeSyncableDataToNBT(upd);
            BlockUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
    }

    private boolean validTile(TileEntity tile) {
        boolean res = tile instanceof IInventory || tile instanceof IInventoryCable || tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return res;
    }

    public boolean checkMachineFilter(String text) {
        if (!this.upgMachineFilter) {
            return true;
        }
        for (String filter : this.filterMachine) {
            if (!text.equalsIgnoreCase(filter)) continue;
            return !this.machineBlackList;
        }
        return this.machineBlackList;
    }

    public ArrayList<Inventory> scanForInventory(boolean IgnoreFilters) {
        BlockPos p;
        TileEntity ej;
        Stack<TileEntity> list = new Stack<TileEntity>();
        boolean hashit = false;
        TileEntity[] eject = new TileEntity[7];
        this.eject = null;
        if (this.upgEject && this.ejectSide != ForgeDirection.UNKNOWN && ((ej = this.field_145850_b.func_175625_s(p = new BlockPos(this.field_174879_c.func_177958_n() + this.ejectSide.offsetX, this.field_174879_c.func_177956_o() + this.ejectSide.offsetY, this.field_174879_c.func_177952_p() + this.ejectSide.offsetZ))) != null && ej instanceof IInventory || ej != null && ej.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[this.ejectSide.ordinal()]))) {
            eject[this.ejectSide.ordinal()] = ej;
            this.eject = ej;
        }
        if (this.scanList == null) {
            this.scanList = new Stack();
        }
        if (this.scanApproved == null) {
            this.scanApproved = new Stack();
        }
        this.scanList.clear();
        this.scanList.add(this);
        TileEntity tmp = null;
        TileEntity tile = null;
        Inventory tmpInv = null;
        block0: while (!this.scanList.empty()) {
            tile = this.scanList.pop();
            list.push(tile);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockPos p2 = new BlockPos(tile.func_174877_v().func_177958_n() + dir.offsetX, tile.func_174877_v().func_177956_o() + dir.offsetY, tile.func_174877_v().func_177952_p() + dir.offsetZ);
                tmp = this.field_145850_b.func_175625_s(p2);
                if (!this.validTile(tmp) && cableUtil.checkBlockInvCableAt(tmp) != IInventoryCable.invType.NORMAL) continue;
                tmpInv = new Inventory(tmp);
                if (tmp == this || this.scanApproved.contains(tmp) || this.scanList.contains(tmp) || list.contains(tmp) || this.isMachineBlacklistedinConfig(tmpInv) && (cableUtil.checkBlockInvCableAt(tmp) != IInventoryCable.invType.NORMAL && cableUtil.checkBlockInvCableAt(tile) != IInventoryCable.invType.NORMAL || !cableUtil.canConnectThrewCover(tile, dir.ordinal()) || !cableUtil.canConnectThrewCover(tmp, ForgeDirection.OPPOSITES[dir.ordinal()]))) continue;
                if ((IgnoreFilters || this.checkMachineFilter(tmpInv.invName) || tmpInv.tile instanceof IInventoryCable) && (eject[this.ejectSide.ordinal()] != tmp || IgnoreFilters)) {
                    this.scanApproved.add(tmp);
                    if (!(tmpInv.tile instanceof IInventoryCable)) {
                        hashit = true;
                    }
                }
                if (this.visitNear && !this.checkMachineFilter(tmpInv.invName) && !IgnoreFilters && hashit && !(tmpInv.tile instanceof IInventoryCable)) continue block0;
                this.scanList.add(tmp);
            }
        }
        if (this.cableTileList == null) {
            this.cableTileList = new ArrayList();
        }
        this.cableTileList.clear();
        ArrayList<Inventory> lst = new ArrayList<Inventory>();
        while (!this.scanApproved.empty()) {
            tile = (TileEntity)this.scanApproved.remove(0);
            if (!(tile instanceof IInventoryCable) && cableUtil.checkBlockInvCableAt(tile) != IInventoryCable.invType.NORMAL) {
                if (tile == null) continue;
                Inventory in = new Inventory(tile);
                in.posX = tile.func_174877_v().func_177958_n();
                in.posY = tile.func_174877_v().func_177956_o();
                in.posZ = tile.func_174877_v().func_177952_p();
                lst.add(in);
                continue;
            }
            this.cableTileList.add(tile);
        }
        return lst;
    }

    public Future<ArrayList<Inventory>> runScanner() {
        return pool.submit(new Callable<ArrayList<Inventory>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ArrayList<Inventory> call() throws Exception {
                1 var1_1 = this;
                synchronized (var1_1) {
                    World world = TileEntityRouterBase.this.field_145850_b;
                    synchronized (world) {
                        return TileEntityRouterBase.this.scanForInventory(false);
                    }
                }
            }
        });
    }

    public Future<String> runScanBlockBreak(final int x, final int y, final int z) {
        return pool.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                2 var1_1 = this;
                synchronized (var1_1) {
                    return TileEntityRouterBase.this.ScanBlockBreak(x, y, z);
                }
            }
        });
    }

    public String ScanBlockBreak(int x, int y, int z) {
        int indx = this.getIndexOfInv(x, y, z);
        if (indx == -1) {
            if (this.getIndexOfCable(x, y, z) > -1) {
                this.awaitScan = true;
                this.newpos = new POS(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                return "true";
            }
            return "false";
        }
        this.awaitScan = true;
        this.newpos = new POS(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return "true";
    }

    public Future<POS> runScanBlockPlaced(final int x, final int y, final int z) {
        return pool.submit(new Callable<POS>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public POS call() throws Exception {
                3 var1_1 = this;
                synchronized (var1_1) {
                    return TileEntityRouterBase.this.ScanBlockPlaced(x, y, z);
                }
            }
        });
    }

    public POS ScanBlockPlaced(int X, int Y, int Z) {
        int invidx = -1;
        int caidx = -1;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (X - x == this.field_174879_c.func_177958_n() && Y - y == this.field_174879_c.func_177956_o() && Z - z == this.field_174879_c.func_177952_p()) {
                        this.newpos = new POS(X, Y, Z);
                        return new POS(X, Y, Z);
                    }
                    invidx = this.getIndexOfInv(X + x, Y + y, Z + z);
                    caidx = this.getIndexOfCable(X + x, Y + y, Z + z);
                    if (invidx > -1) {
                        this.newpos = new POS(X, Y, Z);
                        return new POS(X, Y, Z);
                    }
                    if (caidx <= -1) continue;
                    this.newpos = new POS(X, Y, Z);
                    return new POS(X, Y, Z);
                }
            }
        }
        return null;
    }

    private int getIndexOfCable(int x, int y, int z) {
        if (this.cableTileList == null || this.cableTileList.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.cableTileList.size(); ++i) {
            TileEntity s = this.cableTileList.get(i);
            if (s.func_174877_v().func_177958_n() != x || s.func_174877_v().func_177956_o() != y || s.func_174877_v().func_177952_p() != z) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfInv(int x, int y, int z) {
        if (this.activeTileList == null || this.activeTileList.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.activeTileList.size(); ++i) {
            Inventory s = this.activeTileList.get(i);
            if (s.tile.func_174877_v().func_177958_n() != x || s.tile.func_174877_v().func_177956_o() != y || s.tile.func_174877_v().func_177952_p() != z) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ItemStack getCammo() {
        return this.cammo;
    }

    @Override
    public boolean canInsertItemToSlot(int slot, ItemStack item) {
        if (slot == 0) {
            return this.ItemFilterOK(item);
        }
        return false;
    }

    protected boolean oreDictMatch(int[] stack, int[] stack2) {
        if (stack == null) {
            return false;
        }
        if (stack2 == null) {
            return false;
        }
        for (int s = 0; s < stack.length; ++s) {
            for (int t = 0; t < stack2.length; ++t) {
                if (stack[s] != stack2[t]) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkRedstone() {
        if (this.upgRedstone) {
            if (this.redstoneType < 4) {
                BlockRouter.setRedstone(0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
            switch (this.redstoneType) {
                case 1: {
                    if (this.getRedstone(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()) != 0) break;
                    return false;
                }
                case 2: {
                    if (this.getRedstone(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()) <= 0) break;
                    return false;
                }
                case 3: {
                    boolean rst;
                    boolean bl = rst = this.getRedstone(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()) > 0;
                    if (this.lastRSstate != rst && rst) {
                        this.lastRSstate = rst;
                        return true;
                    }
                    this.lastRSstate = rst;
                    return false;
                }
            }
        }
        return true;
    }

    protected int calculateRedstoneFromInventory() {
        double ss = this.slots[0].field_77994_a;
        double ms = this.slots[0].func_77976_d();
        int pers = (int)(ss / ms * 15.0);
        return pers;
    }

    protected int getRedstone(World worldObj, int x, int y, int z) {
        int top = worldObj.func_175651_c(this.field_174879_c.func_177984_a(), EnumFacing.UP);
        int bottom = worldObj.func_175651_c(this.field_174879_c.func_177977_b(), EnumFacing.DOWN);
        int west = worldObj.func_175651_c(this.field_174879_c.func_177976_e(), EnumFacing.WEST);
        int east = worldObj.func_175651_c(this.field_174879_c.func_177974_f(), EnumFacing.EAST);
        int north = worldObj.func_175651_c(this.field_174879_c.func_177978_c(), EnumFacing.NORTH);
        int south = worldObj.func_175651_c(this.field_174879_c.func_177968_d(), EnumFacing.SOUTH);
        int ret = 0;
        ret = Math.max(ret, top);
        ret = Math.max(ret, bottom);
        ret = Math.max(ret, west);
        ret = Math.max(ret, east);
        ret = Math.max(ret, north);
        ret = Math.max(ret, south);
        return ret;
    }

    protected void setRedstone() {
        if (this.upgRedstone) {
            switch (this.redstoneType) {
                case 4: {
                    if (this.slots[0] == null) {
                        BlockRouter.setRedstone(15, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        break;
                    }
                    BlockRouter.setRedstone(0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    break;
                }
                case 5: {
                    if (this.slots[0] == null) {
                        BlockRouter.setRedstone(0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        break;
                    }
                    if (this.slots[0].field_77994_a >= this.slots[0].func_77976_d()) {
                        BlockRouter.setRedstone(15, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        break;
                    }
                    BlockRouter.setRedstone(0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    break;
                }
                case 6: {
                    if (this.slots[0] != null) {
                        BlockRouter.setRedstone(this.calculateRedstoneFromInventory(), this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        break;
                    }
                    BlockRouter.setRedstone(0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    break;
                }
            }
        } else {
            BlockRouter.setRedstone(0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    private boolean filterHasMatch(ItemStack item) {
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null) continue;
            int[] ore1 = OreDictionary.getOreIDs((ItemStack)this.slots[i]);
            int[] ore2 = OreDictionary.getOreIDs((ItemStack)item);
            if (ore1 != null && ore2 != null && ore1.length != 0 && ore2.length != 0 && this.ignoreMetadata) {
                if (!this.oreDictMatch(ore1, ore2)) continue;
                return true;
            }
            if (this.slots[i].func_77973_b() != item.func_77973_b()) continue;
            if (this.ignoreMetadata) {
                return true;
            }
            if (this.slots[i].func_77952_i() != item.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    protected boolean ItemFilterOK(ItemStack item) {
        if (!this.upgItemFilter) {
            return true;
        }
        if (item == null) {
            return true;
        }
        if (!this.itemBlacklist) {
            return this.filterHasMatch(item);
        }
        return !this.filterHasMatch(item);
    }

    protected boolean isMachineBlacklistedinConfig(Inventory tmpInv) {
        if (cfg.Blacklist == null) {
            return false;
        }
        for (String element : cfg.Blacklist) {
            if (element == null || element.length() <= 0) continue;
            try {
                Matcher matcher;
                Pattern pattern = Pattern.compile(element.toLowerCase().trim());
                if (pattern == null || (matcher = pattern.matcher(tmpInv.invName.toLowerCase().trim())) == null || !matcher.find()) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean allowedToExtractFromSlot(int slot, ItemStack item, EnumFacing count) {
        return slot == 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    public void readNBTSlots(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        NBTTagList tagList2 = tagCompound.func_150295_c("cammo", 10);
        for (int i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList2.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot != 0) continue;
            this.cammo = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void readNBTVars(NBTTagCompound tagCompound) {
        this.useSlot = tagCompound.func_74762_e("useSlot");
        this.useSide = ForgeDirection.values()[tagCompound.func_74762_e("useSide")];
        this.sMode = tagCompound.func_74762_e("sMode") == 1 ? MODE.SIDED : MODE.NUMBERED;
        this.mode = tagCompound.func_74762_e("mode") == 1 ? IOMODE.EXTRACT : IOMODE.OUTPUT;
        this.upgBandwidth = tagCompound.func_74767_n("upgBandwidth");
        this.upgMachineFilter = tagCompound.func_74767_n("upgMachineFilter");
        this.upgNoDelay = tagCompound.func_74767_n("upgNoDelay");
        NBTTagList tagList2 = tagCompound.func_150295_c("machinefilter", 10);
        for (int i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList2.func_150305_b(i);
            this.filterMachine.add(tag.func_74779_i("filter"));
        }
        this.upgItemFilter = tagCompound.func_74767_n("upgItemFilter");
        this.upgThorow = tagCompound.func_74767_n("upgThorow");
        this.upgEject = tagCompound.func_74767_n("upgEject");
        this.upgCamouflage = tagCompound.func_74767_n("upgCamouflage");
        this.ejectSide = ForgeDirection.getOrientation(tagCompound.func_74762_e("ejectSide"));
        this.upgRedstone = tagCompound.func_74767_n("upgRedstone");
        this.redstoneType = tagCompound.func_74762_e("redstoneType");
        this.itemBlacklist = tagCompound.func_74767_n("itemBlacklist");
        this.machineBlackList = tagCompound.func_74767_n("machineBlackList");
        this.visitNear = tagCompound.func_74767_n("visitNear");
        this.ignoreMetadata = tagCompound.func_74767_n("ignoreMetadata");
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readNBTSlots(tagCompound);
        this.readNBTVars(tagCompound);
    }

    public void readFromNBTitem(NBTTagCompound tagCompound) {
        this.readNBTSlots(tagCompound);
        this.readNBTVars(tagCompound);
        this.func_70296_d();
    }

    public void readSyncableDataFromNBT(NBTTagCompound tagCompound) {
        this.readNBTSlots(tagCompound);
        BlockUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
        this.func_70296_d();
    }

    public void writeNBTSlots(NBTTagCompound tagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i];
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            if (stack != null) {
                stack.func_77955_b(tag);
            } else {
                new ItemStack((Block)null).func_77955_b(tag);
            }
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        itemList = new NBTTagList();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Slot", (byte)0);
        if (this.cammo != null) {
            this.cammo.func_77955_b(tag);
        } else {
            new ItemStack((Block)null).func_77955_b(tag);
        }
        itemList.func_74742_a((NBTBase)tag);
        tagCompound.func_74782_a("cammo", (NBTBase)itemList);
    }

    public void writeNBTVars(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("useSlot", this.useSlot);
        tagCompound.func_74768_a("useSide", this.useSide.ordinal());
        tagCompound.func_74768_a("sMode", this.sMode == MODE.SIDED ? 1 : 0);
        tagCompound.func_74768_a("mode", this.mode == IOMODE.EXTRACT ? 1 : 0);
        tagCompound.func_74757_a("upgBandwidth", this.upgBandwidth);
        tagCompound.func_74757_a("upgMachineFilter", this.upgMachineFilter);
        tagCompound.func_74757_a("upgNoDelay", this.upgNoDelay);
        tagCompound.func_74757_a("upgItemFilter", this.upgItemFilter);
        tagCompound.func_74757_a("upgThorow", this.upgThorow);
        tagCompound.func_74757_a("upgEject", this.upgEject);
        tagCompound.func_74757_a("upgCamouflage", this.upgCamouflage);
        tagCompound.func_74768_a("ejectSide", this.ejectSide.ordinal());
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.filterMachine.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("filter", this.filterMachine.get(i));
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("machinefilter", (NBTBase)itemList);
        tagCompound.func_74757_a("upgRedstone", this.upgRedstone);
        tagCompound.func_74768_a("redstoneType", this.redstoneType);
        tagCompound.func_74757_a("itemBlacklist", this.itemBlacklist);
        tagCompound.func_74757_a("machineBlackList", this.machineBlackList);
        tagCompound.func_74757_a("visitNear", this.visitNear);
        tagCompound.func_74757_a("ignoreMetadata", this.ignoreMetadata);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        this.writeNBTSlots(tagCompound);
        this.writeNBTVars(tagCompound);
        return tagCompound;
    }

    public void writeSyncableDataToNBT(NBTTagCompound tagCompound) {
        this.writeNBTSlots(tagCompound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        if (!this.func_145837_r()) {
            this.readSyncableDataFromNBT(tag);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound syncData = super.func_189517_E_();
        if (syncData == null) {
            syncData = new NBTTagCompound();
        }
        this.writeSyncableDataToNBT(syncData);
        return syncData;
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            ++this.rotation;
            if (this.rotation > 359) {
                this.rotation = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.sendForcedUpdate();
            }
            if (!this.hasInit) {
                this.hasInit = true;
                this.activeTileList = (ArrayList)this.scanForInventory(false).clone();
                NetworkHandler.RouterUpdateClients((TileEntityRouter)this.field_145850_b.func_175625_s(this.field_174879_c), this.field_174879_c, this.field_145850_b);
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
                for (Future<POS> future : this.scannewblock) {
                    if (future == null || !future.isDone()) continue;
                    try {
                        BlockPos p;
                        POS res = future.get();
                        if (res != null && this.validTile(this.field_145850_b.func_175625_s(p = new BlockPos(res.x, res.y, res.z)))) {
                            this.newpos = res;
                            this.awaitScan = true;
                            this.scannewblock.remove(future);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.scannewblock.remove(future);
                    break;
                }
                for (Future<Object> future : this.scanbreakblock) {
                    if (future == null || !future.isDone()) continue;
                    try {
                        if (future.get() == "true") {
                            this.newpos = new POS(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                            this.awaitScan = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.scanbreakblock.remove(future);
                    break;
                }
                if (this.awaitScan && this.field_145850_b.func_82737_E() % (long)cfg.tickrate == 0L && this.newpos != null) {
                    TileEntity tile = this.field_145850_b.func_175625_s(new BlockPos(this.newpos.x, this.newpos.y, this.newpos.z));
                    if (tile != null && this.validTile(tile)) {
                        if (this.scanner == null || this.scanner != null && this.scanner.isDone()) {
                            this.scanner = this.runScanner();
                            this.awaitResult = true;
                        }
                        this.awaitScan = false;
                        this.newpos = null;
                    } else {
                        this.awaitScan = false;
                    }
                }
            }
        }
        if (this.awaitResult && this.scanner != null && this.scanner.isDone()) {
            try {
                this.awaitResult = false;
                this.activeTileList = (ArrayList)this.scanner.get().clone();
            }
            catch (InterruptedException | ExecutionException e) {
                this.activeTileList = null;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sendClientUpdateIfChanged();
        }
    }

    public void BlockBreak(BlockEvent.BreakEvent e, TileEntity tile) {
        if (this.awaitScan || !this.hasInit) {
            return;
        }
        this.scanbreakblock.add(this.runScanBlockBreak(e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p()));
    }

    public void sendForcedUpdate() {
        if (this.slots[0] != null) {
            this.lastItem = this.slots[0].func_77946_l();
            NetworkHandler.RouterUpdateClients((TileEntityRouter)this, this.field_174879_c, this.field_145850_b);
        } else {
            this.delayUpdate = 0;
            NetworkHandler.RouterUpdateClients((TileEntityRouter)this, this.field_174879_c, this.field_145850_b);
            this.lastItem = null;
        }
    }

    private void sendClientUpdateIfChanged() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null) {
                this.delayUpdate = 0;
                if (!ItemStack.func_77989_b((ItemStack)this.lastItem, (ItemStack)this.slots[0])) {
                    this.lastItem = this.slots[0].func_77946_l();
                    NetworkHandler.RouterUpdateClients((TileEntityRouter)this, this.field_174879_c, this.field_145850_b);
                }
            } else {
                ++this.delayUpdate;
                if (this.delayUpdate > 19) {
                    this.delayUpdate = 0;
                    NetworkHandler.RouterUpdateClients((TileEntityRouter)this, this.field_174879_c, this.field_145850_b);
                    this.lastItem = null;
                }
                if (this.lastItem == null) {
                    this.delayUpdate = 0;
                }
            }
        }
    }

    public void BlockPlace(BlockEvent.PlaceEvent e, TileEntity tile) {
        if (this.awaitScan || !this.hasInit) {
            return;
        }
        this.scannewblock.add(this.runScanBlockPlaced(e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p()));
    }

    private class POS {
        public int x;
        public int y;
        public int z;

        public POS(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public class Inventory {
        public String invName = "";
        public TileEntity tile;
        public int posX;
        public int posY;
        public int posZ;

        public Inventory(TileEntity tile) {
            this.tile = tile;
            this.invName = this.getTileName(tile);
        }

        public String getTileName(TileEntity tile) {
            if (tile == null) {
                return "NULL";
            }
            Block blc = tile.func_145838_q();
            try {
                int meta = blc.func_176201_c(TileEntityRouterBase.this.field_145850_b.func_180495_p(tile.func_174877_v()));
                Item it = blc.func_180660_a(TileEntityRouterBase.this.field_145850_b.func_180495_p(tile.func_174877_v()), null, 0);
                ItemStack stack = new ItemStack(it, 1, meta);
                if (stack != null && stack.func_77973_b() != null) {
                    String invname = stack.func_77977_a();
                    return invname.replace(':', '|');
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return blc.func_149739_a();
        }
    }

    public static enum MODE {
        NUMBERED,
        SIDED;

    }

    public static enum IOMODE {
        OUTPUT,
        EXTRACT;

    }

    public static enum ForgeDirection {
        DOWN(0, -1, 0),
        UP(0, 1, 0),
        NORTH(0, 0, -1),
        SOUTH(0, 0, 1),
        WEST(-1, 0, 0),
        EAST(1, 0, 0),
        UNKNOWN(0, 0, 0);

        public static final ForgeDirection[] VALID_DIRECTIONS;
        public static final int[] OPPOSITES;
        public static final int[][] ROTATION_MATRIX;
        public final int offsetX;
        public final int offsetY;
        public final int offsetZ;
        public final int flag;

        private ForgeDirection(int x, int y, int z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
            this.flag = 1 << this.ordinal();
        }

        public static ForgeDirection getOrientation(int id) {
            if (id >= 0 && id < VALID_DIRECTIONS.length) {
                return VALID_DIRECTIONS[id];
            }
            return UNKNOWN;
        }

        public ForgeDirection getOpposite() {
            return ForgeDirection.getOrientation(OPPOSITES[this.ordinal()]);
        }

        public ForgeDirection getRotation(ForgeDirection axis) {
            return ForgeDirection.getOrientation(ROTATION_MATRIX[axis.ordinal()][this.ordinal()]);
        }

        static {
            VALID_DIRECTIONS = new ForgeDirection[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
            OPPOSITES = new int[]{1, 0, 3, 2, 5, 4, 6};
            ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2, 6}, {0, 1, 5, 4, 2, 3, 6}, {5, 4, 2, 3, 0, 1, 6}, {4, 5, 2, 3, 1, 0, 6}, {2, 3, 1, 0, 4, 5, 6}, {3, 2, 0, 1, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
        }
    }
}

