/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.TileEntity.StorageUnit;

import com.tomevoll.routerreborn.Network.NetworkHandler;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.TileEntity.TileEntityTickableInventory;
import com.tomevoll.routerreborn.Util.Util;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntityBarrel
extends TileEntityTickableInventory
implements ISidedInventory,
IDeepStorageUnit,
IInventory {
    public long lastclick = 0L;
    public int delayClick = 0;
    public int timerClick = 0;
    public boolean isLocked = false;
    public String Overlay = "";
    private ItemStack itemType = null;
    private ItemStack inputSlot = null;
    private ItemStack outputSlot = null;
    private int itemCount = 0;
    private boolean hasChanged = true;
    private int oldCount = 0;
    private int rotation = 0;

    public ItemStack getItemType() {
        if (this.itemType != null) {
            return this.itemType.func_77946_l();
        }
        return null;
    }

    public String getOverlay() {
        return this.Overlay;
    }

    public void updateCount() {
        if (this.inputSlot != null) {
            if (this.itemType == null) {
                this.itemType = this.inputSlot.func_77946_l();
                this.itemType.field_77994_a = 1;
                this.itemCount = 0;
            }
            this.itemCount += this.inputSlot.field_77994_a;
            this.inputSlot = null;
        }
        if (this.itemType != null) {
            if (this.outputSlot == null) {
                int maxItems = Math.min(this.itemType.func_77976_d(), this.itemCount);
                if (maxItems > 0) {
                    this.outputSlot = this.itemType.func_77946_l();
                    this.outputSlot.field_77994_a = maxItems;
                    this.itemCount -= maxItems;
                }
            } else {
                int maxItems = Math.min(this.itemType.func_77976_d() - this.outputSlot.field_77994_a, this.itemCount);
                if (maxItems > 0) {
                    this.outputSlot.field_77994_a += maxItems;
                    this.itemCount -= maxItems;
                }
            }
        }
        if (this.inputSlot == null && this.outputSlot == null && this.itemCount == 0 && !this.isLocked) {
            this.itemType = null;
        }
        if (this.oldCount != (this.outputSlot != null ? this.outputSlot.field_77994_a : 0) + this.itemCount) {
            if (this.field_145850_b != null) {
                this.hasChanged = true;
            }
            this.oldCount = this.itemCount + (this.outputSlot != null ? this.outputSlot.field_77994_a : 0);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.timerClick > 0) {
            --this.timerClick;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.tickServer();
        } else {
            this.tickClient();
        }
    }

    @Override
    public void tickServer() {
        if (this.hasChanged && !this.func_145837_r()) {
            NetworkHandler.UpdateClients(this, this.field_174879_c, this.field_145850_b);
            this.hasChanged = false;
        }
        if ((this.field_145850_b.func_82737_E() + (long)this.field_174879_c.func_177958_n() + (long)this.field_174879_c.func_177956_o() + (long)this.field_174879_c.func_177952_p()) % 20L == 0L) {
            this.updateCount();
        }
    }

    @Override
    public void tickClient() {
        if (this.field_145850_b.func_82737_E() % 5L == 0L || this.hasChanged) {
            this.updateOverlay();
            this.hasChanged = false;
        }
    }

    public void updateOverlay() {
        if (this.itemType == null) {
            this.Overlay = "";
            return;
        }
        String text = "";
        int count = this.getTotalItemCount();
        int stacks = count / this.itemType.func_77976_d();
        int maxStack = this.itemType.func_77976_d();
        int items = count % this.itemType.func_77976_d();
        if (stacks < 1) {
            text = text + items;
        }
        if (stacks == 1) {
            text = text + (items > 0 ? maxStack + " + " + items : Integer.valueOf(maxStack));
        }
        if (stacks > 1) {
            text = text + (items > 0 ? stacks + "x" + maxStack + " + " + items : stacks + "x" + maxStack);
        }
        this.Overlay = text;
    }

    public int getTotalItemCount() {
        int count = this.itemCount;
        if (this.outputSlot != null) {
            count += this.outputSlot.field_77994_a;
        }
        if (this.inputSlot != null) {
            count += this.inputSlot.field_77994_a;
        }
        return count;
    }

    @Override
    public ItemStack getStoredItemType() {
        if (this.itemType != null) {
            ItemStack stack = this.itemType.func_77946_l();
            stack.field_77994_a = this.getTotalItemCount();
            return stack;
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int amount) {
        if (this.outputSlot != null) {
            this.outputSlot = null;
        }
        this.inputSlot = null;
        this.itemCount = amount;
        this.updateAndSendChanges();
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        this.outputSlot = null;
        this.inputSlot = null;
        this.itemType = type != null ? type.func_77946_l() : null;
        this.itemCount = amount;
        if (this.itemType != null) {
            this.itemType.field_77994_a = 1;
        }
        this.updateAndSendChanges();
    }

    public int getItemLimit() {
        return RouterReborn.getBarrels()[this.func_145832_p()].getStorageCompacity() * (this.itemType == null ? 64 : this.itemType.func_77976_d());
    }

    @Override
    public int getMaxStoredCount() {
        return this.getItemLimit();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (index != 0) {
            return false;
        }
        if (itemStackIn == null) {
            return false;
        }
        if (!this.isLocked && this.itemType == null) {
            return true;
        }
        if (this.isLocked && this.itemType == null) {
            return false;
        }
        if (this.itemType == null) {
            return true;
        }
        int avSpace = this.getMaxStoredCount() - this.getTotalItemCount();
        if (avSpace <= 0) {
            return false;
        }
        ItemStack stored = this.itemType.func_77946_l();
        ItemStack input = itemStackIn.func_77946_l();
        stored.field_77994_a = 1;
        input.field_77994_a = 1;
        return ItemStack.func_77989_b((ItemStack)stored, (ItemStack)input) || Util.CheckOreDict(stored, input);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1 && stack != null && stack.func_77969_a(this.outputSlot);
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (index == 0) {
            return this.inputSlot;
        }
        if (index == 1) {
            return this.outputSlot;
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (index != 1) {
            return null;
        }
        if (this.outputSlot == null) {
            return null;
        }
        int amount = Math.min(this.outputSlot.field_77994_a, count);
        ItemStack ret = this.outputSlot.func_77979_a(amount);
        if (this.outputSlot.field_77994_a == 0) {
            this.outputSlot = null;
        }
        this.updateAndSendChanges();
        return ret;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (index != 1) {
            return null;
        }
        ItemStack ret = this.outputSlot == null ? null : this.outputSlot.func_77946_l();
        this.outputSlot = null;
        this.updateAndSendChanges();
        return ret;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.inputSlot = stack;
        }
        if (index == 1) {
            this.outputSlot = stack;
        }
        this.updateAndSendChanges();
    }

    @Override
    public int func_70297_j_() {
        return this.itemType == null ? 64 : this.itemType.func_77976_d();
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return this.func_180462_a(index, stack, EnumFacing.DOWN);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (!this.func_145837_r()) {
            this.readSyncableDataFromNBT(pkt.func_148857_g());
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, syncData);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        if (!this.func_145837_r()) {
            this.readSyncableDataFromNBT(tag);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound syncData = super.func_189517_E_();
        if (syncData == null) {
            syncData = new NBTTagCompound();
        }
        this.writeSyncableDataToNBT(syncData);
        return syncData;
    }

    private void WriteNBTSlots(NBTTagCompound tagCompound) {
        NBTTagList itemList = new NBTTagList();
        ItemStack stack = null;
        if (this.inputSlot != null) {
            stack = this.inputSlot.func_77946_l();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Slot", (byte)0);
        if (stack != null) {
            stack.func_77955_b(tag);
        } else {
            new ItemStack((Block)null).func_77955_b(tag);
        }
        itemList.func_74742_a((NBTBase)tag);
        stack = null;
        if (this.outputSlot != null) {
            stack = this.outputSlot.func_77946_l();
        }
        tag = new NBTTagCompound();
        tag.func_74774_a("Slot", (byte)1);
        if (stack != null) {
            stack.func_77955_b(tag);
        } else {
            new ItemStack((Block)null).func_77955_b(tag);
        }
        itemList.func_74742_a((NBTBase)tag);
        stack = null;
        if (this.itemType != null) {
            stack = this.itemType.func_77946_l();
        }
        tag = new NBTTagCompound();
        tag.func_74774_a("Slot", (byte)2);
        if (stack != null) {
            stack.func_77955_b(tag);
        } else {
            new ItemStack((Block)null).func_77955_b(tag);
        }
        itemList.func_74742_a((NBTBase)tag);
        stack = null;
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
    }

    private void ReadNBTSlots(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot == 0) {
                this.inputSlot = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            if (slot == 1) {
                this.outputSlot = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            if (slot != 2) continue;
            this.itemType = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    private void WriteNBTVars(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("rotation", this.rotation);
        tagCompound.func_74768_a("itemcount", this.itemCount);
        tagCompound.func_74757_a("locked", this.isLocked);
    }

    private void ReadNBTVars(NBTTagCompound tagCompound) {
        int count;
        if (tagCompound.func_74764_b("rotation")) {
            this.rotation = tagCompound.func_74762_e("rotation");
        }
        this.itemCount = count = tagCompound.func_74762_e("itemcount");
        this.isLocked = tagCompound.func_74767_n("locked");
    }

    private void ReadNBTVarsItem(NBTTagCompound tagCompound) {
        int count;
        this.itemCount = count = tagCompound.func_74762_e("itemcount");
        this.isLocked = tagCompound.func_74767_n("locked");
    }

    public void writeSyncableDataToNBT(NBTTagCompound tagCompound) {
        this.WriteNBTSlots(tagCompound);
        this.WriteNBTVars(tagCompound);
    }

    public void readSyncableDataFromNBT(NBTTagCompound tagCompound) {
        this.ReadNBTSlots(tagCompound);
        this.ReadNBTVars(tagCompound);
        this.updateCount();
        this.updateOverlay();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagmain) {
        tagmain = super.func_189515_b(tagmain);
        this.WriteNBTSlots(tagmain);
        this.WriteNBTVars(tagmain);
        return tagmain;
    }

    public void func_145839_a(NBTTagCompound tagmain) {
        super.func_145839_a(tagmain);
        this.ReadNBTSlots(tagmain);
        this.ReadNBTVars(tagmain);
        this.updateCount();
    }

    public String getInventoryName() {
        return "tile.barrel";
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void readFromNBTitem(NBTTagCompound tagmain) {
        this.ReadNBTSlots(tagmain);
        this.ReadNBTVarsItem(tagmain);
        this.updateCount();
    }

    void updateAndSendChanges() {
        this.updateCount();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            this.hasChanged = true;
            if (this.field_145850_b.func_73046_m().func_71264_H()) {
                NetworkHandler.UpdateClients(this, this.field_174879_c, this.field_145850_b);
                this.hasChanged = false;
            }
        } else {
            this.hasChanged = true;
        }
    }

    public void writeToNBTItem(NBTTagCompound tagmain) {
        this.WriteNBTSlots(tagmain);
        this.WriteNBTVars(tagmain);
    }

    public EnumFacing getRotation() {
        return EnumFacing.field_82609_l[this.rotation];
    }

    public void setRotation(int value) {
        this.rotation = value;
        if (!this.func_145837_r()) {
            this.func_70296_d();
            this.updateAndSendChanges();
        }
    }

    public void clearItems() {
        this.outputSlot = null;
        this.inputSlot = null;
        this.itemType = null;
        this.itemCount = 0;
    }
}

