/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.TileEntity;

import java.util.Collections;
import java.util.Comparator;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeScanner {
    public boolean isScanning = false;
    public BlockPos myPos = null;
    public BlockPos harvesterPos = null;
    public int range = 0;
    public int scannerY = 0;
    Vec3i UP = new Vec3i(0, 1, 0);
    Vec3i DOWN = new Vec3i(0, -1, 0);
    Vec3i NORTH = new Vec3i(0, 0, -1);
    Vec3i SOUTH = new Vec3i(0, 0, 1);
    Vec3i WEST = new Vec3i(-1, 0, 0);
    Vec3i EAST = new Vec3i(1, 0, 0);
    Vec3i NE = new Vec3i(1, 0, -1);
    Vec3i NW = new Vec3i(-1, 0, -1);
    Vec3i SE = new Vec3i(1, 0, 1);
    Vec3i SW = new Vec3i(-1, 0, 1);
    Stack<BlockPos> scanList = new Stack();
    Stack<BlockPos> approvedList = new Stack();
    Stack<BlockPos> doneList = new Stack();
    Stack<BlockPos> treeWaitingList = new Stack();
    World world = null;
    private boolean treeDone = true;

    public TreeScanner(World w, BlockPos p, int r) {
        this.harvesterPos = p;
        this.range = r;
        this.world = w;
    }

    private void scanIt() {
        while (!this.scanList.isEmpty()) {
            BlockPos p = this.scanList.pop();
            this.scanBlock(p);
        }
    }

    private boolean pushChangeAndCheckIfDone() {
        if (!this.approvedList.isEmpty()) {
            Collections.sort(this.approvedList, new CustomComparatorY());
            this.doneList.addAll(this.approvedList);
            this.approvedList.clear();
            ++this.scannerY;
            this.scanList.push(this.myPos.func_177982_a(0, this.scannerY, 0));
            return false;
        }
        return true;
    }

    public void scan() {
        if (this.treeWaitingList != null && !this.treeWaitingList.isEmpty() && this.treeDone && this.scanList.isEmpty()) {
            this.myPos = this.treeWaitingList.pop();
            this.treeDone = false;
            this.scanList.push(this.myPos);
            this.scannerY = 0;
            this.isScanning = true;
        }
        if (this.treeWaitingList == null || this.treeWaitingList.isEmpty()) {
            this.findTrees();
        }
        if (this.myPos == null) {
            return;
        }
        this.scanIt();
        this.treeDone = this.pushChangeAndCheckIfDone();
        if (this.treeDone) {
            this.myPos = null;
        }
        if (this.treeDone && this.treeWaitingList.isEmpty()) {
            this.isScanning = false;
        }
    }

    private void findTrees() {
        Iterable blocks = BlockPos.func_177980_a((BlockPos)this.harvesterPos.func_177982_a(-this.range, 2, -this.range), (BlockPos)this.harvesterPos.func_177982_a(this.range, 2, this.range));
        for (BlockPos blockPos : blocks) {
            if (!this.isTree(blockPos) || this.treeWaitingList.contains(blockPos) || this.scanList.contains(blockPos) || this.approvedList.contains(blockPos) || this.doneList.contains(blockPos)) continue;
            this.treeWaitingList.push(blockPos);
        }
    }

    private boolean isInRange(BlockPos pos, boolean leaf) {
        if (!leaf) {
            return this.harvesterPos.func_177958_n() - this.range <= pos.func_177958_n() && this.harvesterPos.func_177958_n() + this.range >= pos.func_177958_n() && this.harvesterPos.func_177952_p() - this.range <= pos.func_177952_p() && this.harvesterPos.func_177952_p() + this.range >= pos.func_177952_p();
        }
        return this.harvesterPos.func_177958_n() - (this.range + 5) <= pos.func_177958_n() && this.harvesterPos.func_177958_n() + (this.range + 5) >= pos.func_177958_n() && this.harvesterPos.func_177952_p() - (this.range + 5) <= pos.func_177952_p() && this.harvesterPos.func_177952_p() + (this.range + 5) >= pos.func_177952_p();
    }

    private void scanBlock(BlockPos pos) {
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1));
        for (BlockPos blockPos : blocks) {
            if (!this.isTree(blockPos) || this.approvedList.contains(blockPos) || !this.isInRange(blockPos, true) || this.doneList.contains(blockPos) || this.treeWaitingList.contains(blockPos)) continue;
            this.scanList.push(blockPos);
            this.approvedList.push(blockPos);
        }
    }

    public boolean isTree(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        return b.isWood((IBlockAccess)this.world, pos) || b.isLeaves(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos);
    }

    public class CustomComparatorY
    implements Comparator<BlockPos> {
        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return o1.func_177956_o() - o2.func_177956_o();
        }
    }
}

