/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemHandlerUtil {
    public static ItemStack insertItem(IItemHandler dest, ItemStack stack, boolean simulate) {
        if (dest == null || stack == null) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if ((stack = dest.insertItem(i, stack, simulate)) != null && stack.field_77994_a > 0) continue;
            return null;
        }
        return stack;
    }

    public static boolean canItemStacksStack(ItemStack a, ItemStack b) {
        if (a == null || !a.func_77969_a(b)) {
            return false;
        }
        NBTTagCompound aTag = a.func_77978_p();
        NBTTagCompound bTag = b.func_77978_p();
        return !(aTag == null && bTag != null || aTag != null && !aTag.equals((Object)bTag));
    }

    public static boolean canItemStacksStackRelaxed(ItemStack a, ItemStack b) {
        if (a == null || b == null || a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (!a.func_77985_e()) {
            return false;
        }
        if (a.func_77981_g() && a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        NBTTagCompound aTag = a.func_77978_p();
        NBTTagCompound bTag = b.func_77978_p();
        return !(aTag == null && bTag != null || aTag != null && !aTag.equals((Object)bTag));
    }

    public static ItemStack copyStackWithSize(ItemStack itemStack, int size) {
        if (size == 0) {
            return null;
        }
        ItemStack copy = ItemStack.func_77944_b((ItemStack)itemStack);
        if (copy != null) {
            copy.field_77994_a = size;
        }
        return copy;
    }

    public static ItemStack insertItemStacked(IItemHandler inventory, ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || stack == null) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return ItemHandlerUtil.insertItem(inventory, stack, simulate);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; !(i >= sizeInventory || ItemHandlerUtil.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)) == null); ++i) {
        }
        if (stack != null) {
            for (i = 0; i < sizeInventory && (inventory.getStackInSlot(i) != null || (stack = inventory.insertItem(i, stack, simulate)) != null); ++i) {
            }
        }
        return stack;
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack) {
        ItemHandlerUtil.giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack, int preferredSlot) {
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        World world = player.field_70170_p;
        ItemStack remainder = stack;
        if (preferredSlot >= 0) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (remainder != null) {
            remainder = ItemHandlerUtil.insertItemStacked((IItemHandler)inventory, remainder, false);
        }
        if (remainder == null || remainder.field_77994_a != stack.field_77994_a) {
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (remainder != null && !world.field_72995_K) {
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, stack);
            entityitem.func_174867_a(40);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityitem);
        }
    }
}

