/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Util;

import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class Raytrace {
    private Raytrace() {
    }

    public static Vec3d getStart(EntityPlayer player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vec3d getEnd(EntityPlayer player) {
        double reachDistance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = Raytrace.getStart(player);
        return start.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
    }

    public static RayTraceResult collisionRayTrace(World world, BlockPos pos, EntityPlayer player, Collection<AxisAlignedBB> boxes) {
        return Raytrace.collisionRayTrace(world, pos, Raytrace.getStart(player), Raytrace.getEnd(player), boxes);
    }

    public static RayTraceResult collisionRayTrace(World world, BlockPos pos, EntityPlayer player, AxisAlignedBB aabb, int subHit, Object hitInfo) {
        return Raytrace.collisionRayTrace(pos, Raytrace.getStart(player), Raytrace.getEnd(player), aabb, subHit, hitInfo);
    }

    public static RayTraceResult collisionRayTrace(World world, BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        RayTraceResult hit = null;
        int i = -1;
        for (AxisAlignedBB aabb : boxes) {
            double d;
            RayTraceResult result;
            RayTraceResult rayTraceResult = result = aabb == null ? null : Raytrace.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static RayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo) {
        start = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        end = end.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vec3d vec3 = start.func_72429_b(end, bounds.field_72340_a);
        Vec3d vec31 = start.func_72429_b(end, bounds.field_72336_d);
        Vec3d vec32 = start.func_72435_c(end, bounds.field_72338_b);
        Vec3d vec33 = start.func_72435_c(end, bounds.field_72337_e);
        Vec3d vec34 = start.func_72434_d(end, bounds.field_72339_c);
        Vec3d vec35 = start.func_72434_d(end, bounds.field_72334_f);
        if (!Raytrace.isVecInsideYZBounds(bounds, vec3)) {
            vec3 = null;
        }
        if (!Raytrace.isVecInsideYZBounds(bounds, vec31)) {
            vec31 = null;
        }
        if (!Raytrace.isVecInsideXZBounds(bounds, vec32)) {
            vec32 = null;
        }
        if (!Raytrace.isVecInsideXZBounds(bounds, vec33)) {
            vec33 = null;
        }
        if (!Raytrace.isVecInsideXYBounds(bounds, vec34)) {
            vec34 = null;
        }
        if (!Raytrace.isVecInsideXYBounds(bounds, vec35)) {
            vec35 = null;
        }
        Vec3d vec36 = null;
        if (vec3 != null && (vec36 == null || start.func_72436_e(vec3) < start.func_72436_e(vec36))) {
            vec36 = vec3;
        }
        if (vec31 != null && (vec36 == null || start.func_72436_e(vec31) < start.func_72436_e(vec36))) {
            vec36 = vec31;
        }
        if (vec32 != null && (vec36 == null || start.func_72436_e(vec32) < start.func_72436_e(vec36))) {
            vec36 = vec32;
        }
        if (vec33 != null && (vec36 == null || start.func_72436_e(vec33) < start.func_72436_e(vec36))) {
            vec36 = vec33;
        }
        if (vec34 != null && (vec36 == null || start.func_72436_e(vec34) < start.func_72436_e(vec36))) {
            vec36 = vec34;
        }
        if (vec35 != null && (vec36 == null || start.func_72436_e(vec35) < start.func_72436_e(vec36))) {
            vec36 = vec35;
        }
        if (vec36 == null) {
            return null;
        }
        EnumFacing enumfacing = null;
        if (vec36 == vec3) {
            enumfacing = EnumFacing.WEST;
        }
        if (vec36 == vec31) {
            enumfacing = EnumFacing.EAST;
        }
        if (vec36 == vec32) {
            enumfacing = EnumFacing.DOWN;
        }
        if (vec36 == vec33) {
            enumfacing = EnumFacing.UP;
        }
        if (vec36 == vec34) {
            enumfacing = EnumFacing.NORTH;
        }
        if (vec36 == vec35) {
            enumfacing = EnumFacing.SOUTH;
        }
        net.minecraft.util.math.RayTraceResult mop = new net.minecraft.util.math.RayTraceResult(vec36.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), enumfacing, pos);
        mop.subHit = subHit;
        mop.hitInfo = hitInfo;
        return new RayTraceResult(mop, bounds);
    }

    private static boolean isVecInsideYZBounds(AxisAlignedBB bounds, Vec3d vec) {
        return vec != null && vec.field_72448_b >= bounds.field_72338_b && vec.field_72448_b <= bounds.field_72337_e && vec.field_72449_c >= bounds.field_72339_c && vec.field_72449_c <= bounds.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(AxisAlignedBB bounds, Vec3d vec) {
        return vec != null && vec.field_72450_a >= bounds.field_72340_a && vec.field_72450_a <= bounds.field_72336_d && vec.field_72449_c >= bounds.field_72339_c && vec.field_72449_c <= bounds.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(AxisAlignedBB bounds, Vec3d vec) {
        return vec != null && vec.field_72450_a >= bounds.field_72340_a && vec.field_72450_a <= bounds.field_72336_d && vec.field_72448_b >= bounds.field_72338_b && vec.field_72448_b <= bounds.field_72337_e;
    }

    public static class RayTraceResult
    extends RayTraceResultBase<RayTraceResult> {
        public RayTraceResult(net.minecraft.util.math.RayTraceResult mop, AxisAlignedBB bounds) {
            super(mop, bounds);
        }
    }

    private static class RayTraceResultBase<T extends RayTraceResult> {
        public final AxisAlignedBB bounds;
        public final net.minecraft.util.math.RayTraceResult hit;

        public RayTraceResultBase(net.minecraft.util.math.RayTraceResult mop, AxisAlignedBB bounds) {
            this.hit = mop;
            this.bounds = bounds;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) {
            return this.hit.field_72307_f.func_72436_e(vec);
        }
    }
}

