/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.Util;

import com.tomevoll.routerreborn.TileEntity.Router.TileEntityRouterBase;
import com.tomevoll.routerreborn.cfg;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static RayTraceResult raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = 4.0;
        }
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public static boolean CheckOreDict(ItemStack i, ItemStack o) {
        return Util.equals(i, o);
    }

    private static boolean oreWhitelist(String unlocalizedName) {
        boolean res = false;
        for (String label : cfg.OreDictWhitelist) {
            Matcher matcher;
            Pattern pattern = Pattern.compile(label.toLowerCase());
            if (pattern == null || (matcher = pattern.matcher(unlocalizedName.toLowerCase())) == null || !matcher.find()) continue;
            return true;
        }
        return false;
    }

    public static void breakExtraBlock(World world, BlockPos pos, int sidehit, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        if (world.func_175623_d(pos)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        IBlockState block = world.func_180495_p(pos);
        int meta = block.func_177230_c().func_176201_c(block);
        ItemStack itemstack = player.func_184614_ca();
        if (!itemstack.func_150998_b(block)) {
            return;
        }
        IBlockState refBlock = world.func_180495_p(new BlockPos(refX, refY, refZ));
        float refStrength = ForgeHooks.blockStrength((IBlockState)refBlock, (EntityPlayer)player, (World)world, (BlockPos)new BlockPos(refX, refY, refZ));
        float strength = ForgeHooks.blockStrength((IBlockState)block, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        int event = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_70170_p.func_73046_m().func_71265_f(), (EntityPlayerMP)player, (BlockPos)pos);
        if (event == -1) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_177230_c().func_176208_a(world, pos, block, (EntityPlayer)player);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, false)) {
                block.func_177230_c().func_176206_d(world, pos, block);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return;
        }
        if (!world.field_72995_K) {
            block.func_177230_c().func_176208_a(world, pos, block, (EntityPlayer)player);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, true)) {
                block.func_177230_c().func_176206_d(world, pos, block);
                block.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, block, world.func_175625_s(pos), player.func_184586_b(player.func_184600_cs()));
                int amount = block.func_177230_c().getExpDrop(block, (IBlockAccess)world, pos, 0);
                if (amount > 0) {
                    block.func_177230_c().func_180637_b(world, pos, amount);
                }
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            world.func_175718_b(2001, pos, Block.func_149682_b((Block)block.func_177230_c()) + 0);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, true)) {
                block.func_177230_c().func_176206_d(world, pos, block);
            }
            if (itemstack == null || itemstack.field_77994_a == 0) {
                // empty if block
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    public static boolean isTileInList(List<?> lst, TileEntity tile) {
        for (int i = 0; i < lst.size(); ++i) {
            TileEntity t = (TileEntity)lst.get(i);
            if (t.func_174877_v().func_177958_n() != tile.func_174877_v().func_177958_n() || t.func_174877_v().func_177956_o() != tile.func_174877_v().func_177956_o() || t.func_174877_v().func_177952_p() != tile.func_174877_v().func_177952_p()) continue;
            return true;
        }
        return false;
    }

    public static TileEntityRouterBase.ForgeDirection MetaToForgeDirection(int meta) {
        TileEntityRouterBase.ForgeDirection dir = TileEntityRouterBase.ForgeDirection.UNKNOWN;
        if (meta == 1) {
            dir = TileEntityRouterBase.ForgeDirection.DOWN;
        }
        if (meta == 0) {
            dir = TileEntityRouterBase.ForgeDirection.UP;
        }
        if (meta == 2) {
            dir = TileEntityRouterBase.ForgeDirection.SOUTH;
        }
        if (meta == 3) {
            dir = TileEntityRouterBase.ForgeDirection.NORTH;
        }
        if (meta == 4) {
            dir = TileEntityRouterBase.ForgeDirection.EAST;
        }
        if (meta == 5) {
            dir = TileEntityRouterBase.ForgeDirection.WEST;
        }
        return dir;
    }

    public static boolean equals(ItemStack item, ItemStack item2) {
        if (cfg.enableOredict) {
            List ores;
            int id = -1;
            int[] idd = OreDictionary.getOreIDs((ItemStack)item);
            if (idd != null && idd.length > 0) {
                id = idd[0];
            }
            String name = OreDictionary.getOreName((int)id);
            if (id != -1 && name != "Unknown" && Util.isInOreDictionaryWhitelist(OreDictionary.getOreName((int)id)) && (ores = OreDictionary.getOres((String)name)) != null) {
                Iterator iter = ores.iterator();
                while (iter.hasNext()) {
                    if (!Util.isSame((ItemStack)iter.next(), item2)) continue;
                    return true;
                }
            }
        }
        return Util.isSame(item, item2);
    }

    public static boolean isSame(ItemStack item, ItemStack item2) {
        boolean res = item == item2 || item != null && item2 != null && item.func_77969_a(item2) && (item.func_77978_p() == item2.func_77978_p() || item.func_77978_p() != null && item2.func_77978_p() != null && ItemStack.func_77970_a((ItemStack)item, (ItemStack)item2));
        return res;
    }

    public static boolean isInOreDictionaryWhitelist(String ore) {
        String[] whitelist;
        for (String s : whitelist = cfg.OreDictWhitelist) {
            if (!ore.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

