/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.WIP.TileEntity;

import com.tomevoll.routerreborn.API.BlockUtil;
import com.tomevoll.routerreborn.Util.Raytrace;
import com.tomevoll.routerreborn.WIP.Blocks.Grid;
import com.tomevoll.routerreborn.WIP.Blocks.GridHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class CableHandler
extends TileEntity
implements ITickable {
    public Connection[] sides = new Connection[6];
    public List<CablePart>[] parts = new ArrayList[7];
    public boolean waitforUpdate = false;
    protected NetworkType networkType;
    protected UUID networkID;
    int delayupdate = 0;
    boolean hasinit = false;

    public CableHandler() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.parts[facing.ordinal()] = this.getParts(facing);
        }
        this.parts[6] = this.getCorePart();
    }

    public abstract boolean canConnectTo(TileEntity var1, IBlockState var2, BlockPos var3, EnumFacing var4);

    public abstract Connection getConnectionTypeTo(TileEntity var1, IBlockState var2, Block var3, EnumFacing var4);

    public abstract List<CablePart> getParts(EnumFacing var1);

    public abstract List<CablePart> getCorePart();

    private EnumFacing getFacingFromPos(BlockPos source, BlockPos target) {
        return EnumFacing.func_176737_a((float)(source.func_177958_n() - target.func_177958_n()), (float)(source.func_177956_o() - target.func_177956_o()), (float)(source.func_177952_p() - target.func_177952_p())).func_176734_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void setNewUUID() {
        if (this.networkID == null) {
            this.networkID = UUID.randomUUID();
            GridHandler.getGrid(this.field_145850_b).put(this.networkID.toString(), new Grid());
            this.stateChanged(EnumFacing.UP);
        }
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public void onNeighborTileChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        this.setNewUUID();
        TileEntity tile = world.func_175625_s(neighbor);
        int side = this.getFacingFromPos(pos, neighbor).ordinal();
        if (tile == null) {
            this.sides[side] = null;
            this.stateChanged(EnumFacing.field_82609_l[side]);
            this.func_70296_d();
            BlockUtil.markBlockForUpdate((World)world, pos);
            this.field_145850_b.func_175704_b(pos, pos);
            this.field_145850_b.func_175704_b(neighbor, neighbor);
            return;
        }
        if (tile.func_145837_r()) {
            this.sides[side] = null;
            this.stateChanged(EnumFacing.field_82609_l[side]);
            this.func_70296_d();
            BlockUtil.markBlockForUpdate((World)world, pos);
            this.field_145850_b.func_175704_b(pos, pos);
            this.field_145850_b.func_175704_b(neighbor, neighbor);
            return;
        }
        IBlockState state = world.func_180495_p(neighbor);
        if (this.sides[side] == null || this.sides[side] != null && this.sides[side].type != ConnectionType.DISABLED) {
            if (tile instanceof CableHandler && ((CableHandler)tile).getNetworkType().equals((Object)this.networkType) && (((CableHandler)tile).sides[EnumFacing.field_82609_l[side].func_176734_d().ordinal()] == null || ((CableHandler)tile).sides[EnumFacing.field_82609_l[side].func_176734_d().ordinal()] == null || ((CableHandler)tile).sides[EnumFacing.field_82609_l[side].func_176734_d().ordinal()].type != ConnectionType.DISABLED)) {
                if (this.sides[side] == null || this.sides[side] != null && this.sides[side].type != ConnectionType.NORMAL) {
                    this.sides[side] = new Connection(ConnectionType.NORMAL, tile, state, neighbor);
                    UUID otherNet = ((CableHandler)tile).getNetworkID();
                    if (otherNet == null) {
                        ((CableHandler)tile).setNewUUID();
                        otherNet = ((CableHandler)tile).getNetworkID();
                    }
                    if (!otherNet.equals(this.networkID)) {
                        this.joinNetwork(this.networkID, otherNet);
                    }
                    this.stateChanged(EnumFacing.field_82609_l[side]);
                    this.func_70296_d();
                    BlockUtil.markBlockForUpdate((World)world, pos);
                    this.field_145850_b.func_175704_b(pos, pos);
                    this.field_145850_b.func_175704_b(neighbor, neighbor);
                }
                return;
            }
            if (this.canConnectTo(tile, state, neighbor, EnumFacing.field_82609_l[side].func_176734_d())) {
                ConnectionType t = ConnectionType.NONE;
                if (this.sides[side] != null) {
                    t = this.sides[side].type;
                }
                this.sides[side] = this.getConnectionTypeTo(tile, state, state.func_177230_c(), EnumFacing.field_82609_l[side].func_176734_d());
                if (this.sides[side] == null || t != this.sides[side].type) {
                    this.stateChanged(EnumFacing.field_82609_l[side]);
                }
            } else {
                ConnectionType t = ConnectionType.NONE;
                if (this.sides[side] != null && !this.sides[side].forced) {
                    t = this.sides[side].type;
                    this.sides[side] = null;
                }
                if (t != ConnectionType.NONE) {
                    this.stateChanged(EnumFacing.field_82609_l[side]);
                    this.func_70296_d();
                    BlockUtil.markBlockForUpdate((World)world, pos);
                    this.field_145850_b.func_175704_b(pos, pos);
                    this.field_145850_b.func_175704_b(neighbor, neighbor);
                }
            }
        }
    }

    private void joinNetwork(UUID netu1, UUID netu2) {
        Grid net1 = GridHandler.getGrid(this.field_145850_b).get(netu1.toString());
        Grid net2 = GridHandler.getGrid(this.field_145850_b).get(netu2.toString());
        if (net1 == null || net2 == null) {
            return;
        }
        int size1 = 0;
        int size2 = 0;
        size1 += net1.cable.size();
        size1 += net1.input.size();
        size2 += net2.cable.size();
        size2 += net2.input.size();
        if ((size1 += net1.output.size()) < (size2 += net2.output.size())) {
            for (CableHandler entry : net2.cable) {
                entry.setNetworkID(netu1);
            }
            for (CableHandler entry : net2.output) {
                entry.setNetworkID(netu1);
            }
            for (CableHandler entry : net2.input) {
                entry.setNetworkID(netu1);
            }
            net1.cable.addAll(net2.cable);
            net1.output.addAll(net2.output);
            net1.input.addAll(net2.input);
            net2.cable.clear();
            net2.input.clear();
            net2.output.clear();
            GridHandler.getGrid(this.field_145850_b).remove(netu2.toString());
        } else {
            for (CableHandler entry : net1.cable) {
                entry.setNetworkID(netu2);
            }
            for (CableHandler entry : net1.output) {
                entry.setNetworkID(netu2);
            }
            for (CableHandler entry : net1.input) {
                entry.setNetworkID(netu2);
            }
            net2.cable.addAll(net1.cable);
            net2.output.addAll(net1.output);
            net2.input.addAll(net1.input);
            net1.cable.clear();
            net1.input.clear();
            net1.output.clear();
            GridHandler.getGrid(this.field_145850_b).remove(netu1.toString());
        }
    }

    public UUID getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(UUID networkID) {
        this.networkID = networkID;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        if (!this.func_145837_r()) {
            this.readSyncableDataFromNBT(tag);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound syncData = super.func_189517_E_();
        if (syncData == null) {
            syncData = new NBTTagCompound();
        }
        this.writeSyncableDataToNBT(syncData);
        return syncData;
    }

    private void readSyncableDataFromNBT(NBTTagCompound nbt) {
        Connection[] tmp = (Connection[])this.sides.clone();
        boolean haschanged = false;
        this.sides[0] = nbt.func_74762_e("side0") > 1 ? new Connection(ConnectionType.values()[nbt.func_74762_e("side0")], null, null, null) : null;
        this.sides[1] = nbt.func_74762_e("side1") > 1 ? new Connection(ConnectionType.values()[nbt.func_74762_e("side1")], null, null, null) : null;
        this.sides[2] = nbt.func_74762_e("side2") > 1 ? new Connection(ConnectionType.values()[nbt.func_74762_e("side2")], null, null, null) : null;
        this.sides[3] = nbt.func_74762_e("side3") > 1 ? new Connection(ConnectionType.values()[nbt.func_74762_e("side3")], null, null, null) : null;
        this.sides[4] = nbt.func_74762_e("side4") > 1 ? new Connection(ConnectionType.values()[nbt.func_74762_e("side4")], null, null, null) : null;
        this.sides[5] = nbt.func_74762_e("side5") > 1 ? new Connection(ConnectionType.values()[nbt.func_74762_e("side5")], null, null, null) : null;
        for (int i = 0; i < tmp.length; ++i) {
            if (this.sides[i] != null && tmp[i] != null && this.sides[i].type != tmp[i].type) {
                haschanged = true;
                break;
            }
            if (this.sides[i] == null && tmp[i] != null) {
                haschanged = true;
                break;
            }
            if (this.sides[i] == null || tmp[i] != null) continue;
            haschanged = true;
            break;
        }
        if (haschanged) {
            this.field_145850_b.func_175704_b(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(1, 1, 1));
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, syncData);
    }

    private void writeSyncableDataToNBT(NBTTagCompound syncData) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < this.sides.length; ++i) {
            if (this.sides[i] != null) {
                syncData.func_74768_a("side" + i, this.sides[i].type.index);
                continue;
            }
            syncData.func_74768_a("side" + i, 0);
        }
    }

    public void onLoad() {
        this.hasinit = false;
        this.delayupdate = 2;
        super.onLoad();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.networkID == null) {
            this.waitforUpdate = true;
        }
        this.setNewUUID();
        if (!this.hasinit || this.waitforUpdate) {
            for (int i = 0; i < this.sides.length; ++i) {
                if (this.sides[i] == null || this.sides[i].type == ConnectionType.DISABLED || this.sides[i].forced) continue;
                this.sides[i] = null;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                this.onNeighborTileChange((IBlockAccess)this.field_145850_b, this.field_174879_c, this.field_174879_c.func_177972_a(facing));
            }
            this.hasinit = true;
            this.waitforUpdate = false;
        }
        if ((this.field_145850_b.func_82737_E() + (long)this.field_174879_c.func_177958_n() + (long)this.field_174879_c.func_177956_o() + (long)this.field_174879_c.func_177952_p()) % 20L == 0L) {
            for (int i = 0; i < this.sides.length; ++i) {
                Connection con;
                if (this.sides[i] == null) continue;
                if (this.sides[i].tile != null && this.sides[i].type == ConnectionType.NORMAL) {
                    if (((CableHandler)this.sides[i].tile).getNetworkID() == null) {
                        ((CableHandler)this.sides[i].tile).setNewUUID();
                    }
                    if (!((CableHandler)this.sides[i].tile).getNetworkID().equals(this.networkID) || !((CableHandler)this.sides[i].tile).getNetworkType().equals((Object)this.networkType)) {
                        this.sides[i] = null;
                        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.field_82609_l[i]));
                        this.onNeighborTileChange((IBlockAccess)this.field_145850_b, this.field_174879_c, this.field_174879_c.func_177972_a(EnumFacing.field_82609_l[i]));
                    }
                }
                if ((con = this.sides[i]) != null && con.tile != null && (con.tile == null || !con.tile.func_145837_r()) || this.sides[i] == null || this.sides[i].type == ConnectionType.DISABLED || this.sides[i].forced) continue;
                this.sides[i] = null;
                this.stateChanged(EnumFacing.field_82609_l[i]);
                this.func_70296_d();
                BlockUtil.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
                return;
            }
        }
    }

    abstract void stateChanged(EnumFacing var1);

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            Raytrace.RayTraceResult res;
            ArrayList<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
            CableHandler c = this;
            for (int i = 0; i < c.sides.length; ++i) {
                Connection con = c.sides[i];
                if (con == null) continue;
                for (CablePart cablePart : c.parts[i]) {
                    if (!(cablePart.partType != EnumPart.CONNECTOR && cablePart.partType != EnumPart.SLEVE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT)) {
                        bounds.addAll(cablePart.bounds);
                    }
                    if (cablePart.partType != EnumPart.CABLE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT && con.type != ConnectionType.NORMAL) continue;
                    bounds.addAll(cablePart.bounds);
                }
            }
            if (c.parts[6] != null) {
                for (CablePart part : c.parts[6]) {
                    bounds.addAll(part.bounds);
                }
            }
            if ((res = Raytrace.collisionRayTrace(this.field_145850_b, pos, player, bounds)) != null) {
                for (int i = 0; i < c.sides.length; ++i) {
                    Connection con = c.sides[i];
                    if (con == null) continue;
                    for (CablePart part : c.parts[i]) {
                        if (!(part.partType != EnumPart.CONNECTOR && part.partType != EnumPart.SLEVE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT || !part.bounds.contains(res.bounds))) {
                            boolean ret = this.cableWrenched(EnumFacing.field_82609_l[i], true);
                            return ret;
                        }
                        if (part.partType != EnumPart.CABLE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT && con.type != ConnectionType.NORMAL || !part.bounds.contains(res.bounds)) continue;
                        boolean ret = this.cableWrenched(EnumFacing.field_82609_l[i], false);
                        return ret;
                    }
                }
                if (c.parts[6] != null) {
                    for (CablePart part : c.parts[6]) {
                        if (!part.bounds.contains(res.bounds)) continue;
                        boolean bl = this.cableWrenched(res.hit.field_178784_b, false);
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    protected abstract boolean cableWrenched(EnumFacing var1, boolean var2);

    protected abstract boolean OpenGui(EnumFacing var1, boolean var2, EntityPlayer var3);

    private AxisAlignedBB getBoundFromHit(RayTraceResult movingObjectPositionIn) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            for (CablePart part : this.parts[i]) {
                for (AxisAlignedBB axisAlignedBB : part.bounds) {
                }
            }
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.sides.length; ++i) {
            int disabled = compound.func_74762_e("side" + i);
            if (disabled <= 0) continue;
            if (this.sides[i] == null) {
                this.sides[i] = new Connection(ConnectionType.values()[disabled], null, null, null);
            }
            this.sides[i].type = ConnectionType.values()[disabled];
            this.sides[i].forced = true;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (int i = 0; i < this.sides.length; ++i) {
            if (this.sides[i] == null || !this.sides[i].forced) continue;
            compound.func_74768_a("side" + i, this.sides[i].type.index);
        }
        return compound;
    }

    public void invalidateNetwork() {
        Grid net1 = GridHandler.getGrid(this.field_145850_b).get(this.getNetworkID().toString());
        for (CableHandler entry : net1.output) {
            if (((Object)((Object)entry)).equals((Object)this)) continue;
            entry.setNetworkID(null);
            entry.setNewUUID();
            entry.waitforUpdate = true;
        }
        for (CableHandler entry : net1.input) {
            if (((Object)((Object)entry)).equals((Object)this)) continue;
            entry.setNetworkID(null);
            entry.setNewUUID();
            entry.waitforUpdate = true;
        }
        for (CableHandler entry : net1.cable) {
            if (((Object)((Object)entry)).equals((Object)this)) continue;
            entry.setNetworkID(null);
            entry.setNewUUID();
            entry.waitforUpdate = true;
        }
        net1.cable.clear();
        net1.input.clear();
        net1.output.clear();
        Grid g = GridHandler.getGrid(this.field_145850_b).remove(this.getNetworkID().toString());
    }

    public boolean onOpenGui(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            Raytrace.RayTraceResult res;
            ArrayList<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
            CableHandler c = this;
            for (int i = 0; i < c.sides.length; ++i) {
                Connection con = c.sides[i];
                if (con == null) continue;
                for (CablePart cablePart : c.parts[i]) {
                    if (!(cablePart.partType != EnumPart.CONNECTOR && cablePart.partType != EnumPart.SLEVE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT)) {
                        bounds.addAll(cablePart.bounds);
                    }
                    if (cablePart.partType != EnumPart.CABLE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT && con.type != ConnectionType.NORMAL) continue;
                    bounds.addAll(cablePart.bounds);
                }
            }
            if (c.parts[6] != null) {
                for (CablePart part : c.parts[6]) {
                    bounds.addAll(part.bounds);
                }
            }
            if ((res = Raytrace.collisionRayTrace(this.field_145850_b, pos, player, bounds)) != null) {
                for (int i = 0; i < c.sides.length; ++i) {
                    Connection con = c.sides[i];
                    if (con == null) continue;
                    for (CablePart part : c.parts[i]) {
                        if (!(part.partType != EnumPart.CONNECTOR && part.partType != EnumPart.SLEVE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT || !part.bounds.contains(res.bounds))) {
                            boolean ret = this.OpenGui(EnumFacing.field_82609_l[i], true, player);
                            return ret;
                        }
                        if (part.partType != EnumPart.CABLE || con.type != ConnectionType.EXTRACT && con.type != ConnectionType.OUTPUT && con.type != ConnectionType.NORMAL || !part.bounds.contains(res.bounds)) continue;
                        boolean ret = this.OpenGui(EnumFacing.field_82609_l[i], false, player);
                        return ret;
                    }
                }
                if (c.parts[6] != null) {
                    for (CablePart part : c.parts[6]) {
                        if (!part.bounds.contains(res.bounds)) continue;
                        boolean bl = this.OpenGui(res.hit.field_178784_b, false, player);
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public class CablePart {
        public List<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
        public EnumPart partType;
        public EnumFacing side;

        public CablePart(List<AxisAlignedBB> bounds, EnumPart partType, EnumFacing side) {
            this.bounds = bounds;
            this.partType = partType;
            this.side = side;
        }
    }

    public class Connection {
        public ConnectionType type;
        public TileEntity tile;
        public IBlockState state;
        public BlockPos pos;
        public boolean forced = false;

        public Connection(ConnectionType type, TileEntity tile, IBlockState state, BlockPos pos) {
            this.type = type;
            this.tile = tile;
            this.state = state;
            this.pos = pos;
        }
    }

    public static enum NetworkType {
        ENERGY,
        ITEM,
        FLUID;

    }

    public static enum EnumPart {
        CABLE,
        CONNECTOR,
        SLEVE;

    }

    public static enum ConnectionType {
        NONE(0),
        DISABLED(1),
        NORMAL(2),
        EXTRACT(3),
        OUTPUT(4);

        int index;

        private ConnectionType(int type) {
            this.index = type;
        }

        int getIndex() {
            return this.index;
        }
    }
}

