/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.WIP.TileEntity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.tomevoll.routerreborn.WIP.Blocks.GridHandler;
import com.tomevoll.routerreborn.WIP.TileEntity.CableHandler;
import com.tomevoll.routerreborn.WIP.TileEntity.TileCable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEnergyConduit
extends TileCable {
    public TileEnergyConduit() {
        this.networkType = CableHandler.NetworkType.ENERGY;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public CableHandler.Connection getConnectionTypeTo(TileEntity tile, IBlockState state, Block block, EnumFacing enumFacing) {
        if (tile instanceof IEnergyReceiver) {
            if (this.sides[enumFacing.func_176734_d().ordinal()] != null) {
                CableHandler.ConnectionType t = this.sides[enumFacing.func_176734_d().ordinal()].type;
                boolean forced = this.sides[enumFacing.func_176734_d().ordinal()].forced;
                if (forced) {
                    CableHandler.Connection c = new CableHandler.Connection(t, tile, state, tile.func_174877_v());
                    c.forced = true;
                    return c;
                }
            }
            return new CableHandler.Connection(CableHandler.ConnectionType.OUTPUT, tile, state, tile.func_174877_v());
        }
        if (tile instanceof IEnergyProvider) {
            if (this.sides[enumFacing.func_176734_d().ordinal()] != null) {
                CableHandler.ConnectionType t = this.sides[enumFacing.func_176734_d().ordinal()].type;
                boolean forced = this.sides[enumFacing.func_176734_d().ordinal()].forced;
                if (forced) {
                    CableHandler.Connection c = new CableHandler.Connection(t, tile, state, tile.func_174877_v());
                    c.forced = true;
                    return c;
                }
            }
            return new CableHandler.Connection(CableHandler.ConnectionType.EXTRACT, tile, state, tile.func_174877_v());
        }
        return null;
    }

    @Override
    public boolean canConnectTo(TileEntity tile, IBlockState state, BlockPos pos, EnumFacing enumFacing) {
        if (tile instanceof IEnergyProvider && ((IEnergyProvider)tile).canConnectEnergy(enumFacing)) {
            return true;
        }
        return tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canConnectEnergy(enumFacing);
    }

    public int transferpower(int amount, boolean simulate) {
        int tmp;
        CableHandler.Connection con;
        int i;
        int maxEnergy = 0;
        int count = 0;
        int maxOut = 0;
        for (i = 0; i < this.sides.length; ++i) {
            con = this.sides[i];
            if (con == null || con.type != CableHandler.ConnectionType.OUTPUT || !(con.tile instanceof IEnergyReceiver) || (tmp = ((IEnergyReceiver)con.tile).receiveEnergy(EnumFacing.field_82609_l[i].func_176734_d(), amount, true)) <= 0) continue;
            ++count;
            maxEnergy += tmp;
        }
        if (simulate) {
            return Math.min(maxEnergy, amount);
        }
        if (maxEnergy == 0) {
            return 0;
        }
        maxOut = Math.min(maxEnergy, amount) / count;
        maxEnergy = 0;
        count = 0;
        for (i = 0; i < this.sides.length; ++i) {
            con = this.sides[i];
            if (con == null || con.type != CableHandler.ConnectionType.OUTPUT || !(con.tile instanceof IEnergyReceiver) || (tmp = ((IEnergyReceiver)con.tile).receiveEnergy(EnumFacing.field_82609_l[i].func_176734_d(), maxOut, false)) <= 0) continue;
            ++count;
            maxEnergy += tmp;
        }
        return maxEnergy;
    }

    @Override
    public void func_73660_a() {
        CableHandler.Connection con;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int maxEnergy = 0;
        int count = 0;
        int maxOut = 0;
        for (int i = 0; i < this.sides.length; ++i) {
            con = this.sides[i];
            if (con == null || con.type != CableHandler.ConnectionType.EXTRACT || con.tile == null || !(con.tile instanceof IEnergyProvider)) continue;
            maxEnergy += ((IEnergyProvider)con.tile).extractEnergy(EnumFacing.field_82609_l[i].func_176734_d(), 20000, true);
        }
        if (maxEnergy > 0) {
            int t;
            TileEnergyConduit tmp;
            if (this.networkID == null) {
                return;
            }
            if (GridHandler.getGrid(this.field_145850_b).get(this.networkID.toString()) == null || GridHandler.getGrid((World)this.field_145850_b).get((Object)this.networkID.toString()).output == null) {
                return;
            }
            for (CableHandler entry : GridHandler.getGrid((World)this.field_145850_b).get((Object)this.networkID.toString()).output) {
                tmp = (TileEnergyConduit)entry;
                t = tmp.transferpower(maxEnergy, true);
                if (t <= 0) continue;
                ++count;
                maxOut += t;
            }
            if (maxOut == 0 || maxEnergy == 0) {
                return;
            }
            maxOut = Math.min(maxEnergy, maxOut) / count;
            maxEnergy = 0;
            for (CableHandler entry : GridHandler.getGrid((World)this.field_145850_b).get((Object)this.networkID.toString()).output) {
                tmp = (TileEnergyConduit)entry;
                t = tmp.transferpower(maxOut, false);
                if (t <= 0) continue;
                ++count;
                maxEnergy += t;
            }
            maxOut = 0;
            for (int i = 0; i < this.sides.length; ++i) {
                con = this.sides[i];
                if (con == null || con.type != CableHandler.ConnectionType.EXTRACT) continue;
                if (con.tile instanceof IEnergyProvider) {
                    maxOut += ((IEnergyProvider)con.tile).extractEnergy(EnumFacing.field_82609_l[i].func_176734_d(), maxEnergy, false);
                }
                if (maxOut < maxEnergy) continue;
                return;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }
}

