/*
 * Decompiled with CFR 0.152.
 */
package com.tomevoll.routerreborn.WIP.TileEntity;

import com.tomevoll.routerreborn.API.item.InventoryHelper;
import com.tomevoll.routerreborn.Gui.Conduit.ContainerConduit;
import com.tomevoll.routerreborn.Interface.IFakeInventory;
import com.tomevoll.routerreborn.Interface.IGuiButtonHandler;
import com.tomevoll.routerreborn.Interface.IGuiRedstoneHandler;
import com.tomevoll.routerreborn.RouterReborn;
import com.tomevoll.routerreborn.WIP.Blocks.Grid;
import com.tomevoll.routerreborn.WIP.Blocks.GridHandler;
import com.tomevoll.routerreborn.WIP.TileEntity.CableHandler;
import com.tomevoll.routerreborn.WIP.TileEntity.FakeInventoryBasic;
import com.tomevoll.routerreborn.WIP.TileEntity.TileCable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemConduit
extends TileCable
implements IFakeInventory,
IGuiButtonHandler,
IGuiRedstoneHandler {
    public ItemFilter[] itemFilters = new ItemFilter[6];
    public int lastTab = 0;
    private int currentOutputIndex = -1;
    private int side = -1;

    public TileItemConduit() {
        this.networkType = CableHandler.NetworkType.ITEM;
        for (int i = 0; i < 6; ++i) {
            this.itemFilters[i] = new ItemFilter();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < 6; ++i) {
            this.itemFilters[i] = new ItemFilter();
            if (!compound.func_74764_b("invSide" + i)) continue;
            this.itemFilters[i].readFromNBT(compound.func_74775_l("invSide" + i));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (int i = 0; i < 6; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.itemFilters[i] != null) {
                this.itemFilters[i].writeToNBT(tag);
            }
            compound.func_74782_a("invSide" + i, (NBTBase)tag);
        }
        return compound;
    }

    @Override
    public boolean canConnectTo(TileEntity tile, IBlockState state, BlockPos pos, EnumFacing enumFacing) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumFacing)) {
            return true;
        }
        return tile instanceof IInventory || tile instanceof IItemHandler;
    }

    @Override
    public CableHandler.Connection getConnectionTypeTo(TileEntity tile, IBlockState state, Block block, EnumFacing enumFacing) {
        if (this.sides[enumFacing.func_176734_d().ordinal()] != null) {
            CableHandler.ConnectionType t = this.sides[enumFacing.func_176734_d().ordinal()].type;
            boolean forced = this.sides[enumFacing.func_176734_d().ordinal()].forced;
            if (forced) {
                CableHandler.Connection c = new CableHandler.Connection(t, tile, state, tile.func_174877_v());
                c.forced = true;
                return c;
            }
        }
        if (tile instanceof IInventory) {
            return new CableHandler.Connection(CableHandler.ConnectionType.OUTPUT, tile, state, this.field_174879_c);
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, enumFacing)) {
            return new CableHandler.Connection(CableHandler.ConnectionType.OUTPUT, tile, state, this.field_174879_c);
        }
        return null;
    }

    @Override
    public void func_73660_a() {
        block15: {
            CableHandler.Connection con;
            Grid grid;
            block14: {
                super.func_73660_a();
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if ((this.field_145850_b.func_82737_E() + (long)this.field_174879_c.func_177958_n() + (long)this.field_174879_c.func_177956_o() + (long)this.field_174879_c.func_177952_p()) % 5L != 0L) {
                    return;
                }
                if (this.networkID == null) {
                    return;
                }
                grid = GridHandler.getGrid(this.field_145850_b).get(this.networkID.toString());
                this.nextSide();
                if (this.side == -1) {
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    this.corrrectMode(i);
                }
                if (this.sides[this.side] != null && this.sides[this.side].type == CableHandler.ConnectionType.OUTPUT || this.sides[this.side] == null) {
                    return;
                }
                if (!this.checkRedstone(this.side)) {
                    return;
                }
                if (grid == null || grid.output == null || grid.output.size() == 0) {
                    return;
                }
                con = this.sides[this.side];
                if (con == null || !(con.tile instanceof IInventory)) break block14;
                IInventory inv2 = (IInventory)con.tile;
                if (inv2 == null || !InventoryHelper.canExtractFromInventory(inv2, null, EnumFacing.field_82609_l[this.side].func_176734_d(), -1)) break block15;
                for (ItemStack itm : InventoryHelper.getContentOfInventory(inv2, EnumFacing.field_82609_l[this.side].func_176734_d())) {
                    int ret;
                    ItemStack item = itm.func_77946_l();
                    if (!this.CheckFilter(con, item, this.itemFilters[this.side]) || !InventoryHelper.canExtractFromInventory(inv2, item, EnumFacing.field_82609_l[this.side].func_176734_d(), -1) || !(grid.output.get(this.currentOutputIndex) instanceof TileItemConduit)) continue;
                    TileItemConduit conduit = (TileItemConduit)grid.output.get(this.currentOutputIndex);
                    if (item.field_77994_a > 64) {
                        item.field_77994_a = 64;
                    }
                    if ((ret = conduit.insertToAny(item)) <= 0) continue;
                    while (ret > 0) {
                        item.field_77994_a = ret;
                        ItemStack r = InventoryHelper.extractFromInventory(inv2, item, EnumFacing.field_82609_l[this.side].func_176734_d(), -1);
                        if (r == null) continue;
                        ret -= r.field_77994_a;
                    }
                }
                break block15;
            }
            if (con != null && con.tile != null && con.tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[this.side])) {
                IItemHandler it = (IItemHandler)con.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[this.side]);
                for (int slot = 0; slot < it.getSlots(); ++slot) {
                    TileItemConduit conduit;
                    int ret;
                    ItemStack tempStack;
                    ItemStack tempStack2 = it.getStackInSlot(slot);
                    ItemStack itemStack = tempStack = tempStack2 == null ? null : tempStack2.func_77946_l();
                    if (tempStack == null || !this.CheckFilter(con, tempStack, this.itemFilters[this.side]) || it.extractItem(slot, 64, true) == null || !(grid.output.get(this.currentOutputIndex) instanceof TileItemConduit) || (ret = (conduit = (TileItemConduit)grid.output.get(this.currentOutputIndex)).insertToAny(tempStack.func_77946_l())) <= 0) continue;
                    while (ret > 0) {
                        tempStack.field_77994_a = ret;
                        ItemStack r = it.extractItem(slot, ret, false);
                        if (r == null) continue;
                        ret -= r.field_77994_a;
                    }
                }
            }
        }
    }

    private List<ItemStack> combineItems(List<ItemStack> items) {
        ArrayList<Integer> markedIndexes = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            if (markedIndexes.contains(i)) continue;
            ItemStack item = items.get(i);
            for (int j = i + 1; j < items.size(); ++j) {
                ItemStack other;
                if (markedIndexes.contains(j) || !InventoryHelper.canCombine(item, other = items.get(j), false)) continue;
                item.field_77994_a += other.field_77994_a;
                markedIndexes.add(j);
            }
        }
        ArrayList<ItemStack> markedItems = new ArrayList<ItemStack>();
        Iterator iterator = markedIndexes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            markedItems.add(items.get(i));
        }
        items.removeAll(markedItems);
        return items;
    }

    private int CheckKeepStock(CableHandler.Connection con, ItemStack item, ItemFilter filter, List<ItemStack> itemsOrg) {
        if (item == null) {
            return 0;
        }
        List<ItemStack> items = this.combineItems(itemsOrg);
        if (filter.useOreDict) {
            filter.ignoreMeta = true;
        }
        if (!filter.ignoreMeta) {
            filter.useOreDict = false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack it = filter.inventory.func_70301_a(i);
            if (!InventoryHelper.isStacksEqual(it, item, true)) continue;
            for (ItemStack stack : items) {
                if (!InventoryHelper.isStacksEqual(it, stack, true)) continue;
                if (it.field_77994_a > stack.field_77994_a) {
                    return it.field_77994_a - stack.field_77994_a;
                }
                return 0;
            }
            return it.field_77994_a;
        }
        return 0;
    }

    private void corrrectMode(int side) {
        ItemFilter i = this.itemFilters[side];
        if (this.sides[side] != null) {
            if (this.sides[side].type == CableHandler.ConnectionType.EXTRACT) {
                i.keepStock = false;
            }
            if (i.useOreDict) {
                i.ignoreMeta = true;
            }
            if (!i.ignoreMeta) {
                i.useOreDict = false;
            }
            if (i.keepStock) {
                i.useOreDict = false;
                i.ignoreMeta = false;
                i.isBlacklist = false;
            }
        }
    }

    private boolean CheckFilter(CableHandler.Connection con, ItemStack item, ItemFilter filter) {
        if (item == null) {
            return false;
        }
        if (con.type == CableHandler.ConnectionType.EXTRACT) {
            filter.keepStock = false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack it = filter.inventory.func_70301_a(i);
            if (it == null) continue;
            if (filter.useOreDict && InventoryHelper.oreDictMatch(it, item)) {
                return !filter.isBlacklist;
            }
            if (it.func_77973_b() != item.func_77973_b()) continue;
            if (filter.ignoreMeta) {
                return !filter.isBlacklist;
            }
            if (it.func_77952_i() != item.func_77952_i() || it.func_77978_p() != item.func_77978_p()) continue;
            return !filter.isBlacklist;
        }
        return filter.isBlacklist;
    }

    public int insertToAny(ItemStack item) {
        int itemsToInsert = item.field_77994_a;
        int itemsInserted = 0;
        for (int i = 0; i < this.sides.length; ++i) {
            if (this.sides[i] != null && this.sides[i].type == CableHandler.ConnectionType.OUTPUT && this.sides[i].tile != null && !this.sides[i].tile.func_145837_r() && this.sides[i].tile instanceof IInventory) {
                if (!this.checkRedstone(i)) continue;
                int r = item.field_77994_a;
                ItemStack ret = item.func_77946_l();
                if (this.itemFilters[i].keepStock) {
                    int max = this.CheckKeepStock(this.sides[i], item.func_77946_l(), this.itemFilters[i], InventoryHelper.getContentOfInventory((IInventory)this.sides[i].tile, null));
                    if (max > 0 && (ret = InventoryHelper.putStackInInventoryAllSlotsLimited((IInventory)this.sides[i].tile, item.func_77946_l(), EnumFacing.field_82609_l[i].func_176734_d(), max)) != null) {
                        ret.field_77994_a = item.field_77994_a - ret.field_77994_a;
                    }
                } else if (this.CheckFilter(this.sides[i], item, this.itemFilters[i])) {
                    ret = TileEntityHopper.func_174918_a((IInventory)((IInventory)this.sides[i].tile), (ItemStack)item.func_77946_l(), (EnumFacing)EnumFacing.field_82609_l[i].func_176734_d());
                }
                if (ret == null || ret != null && ret.field_77994_a == 0) {
                    itemsInserted += r;
                    return itemsToInsert;
                }
                item.field_77994_a = ret.field_77994_a;
                if (itemsToInsert > (itemsInserted += r - ret.field_77994_a)) continue;
                return itemsInserted;
            }
            if (this.sides[i] == null || this.sides[i].type != CableHandler.ConnectionType.OUTPUT || this.sides[i].tile == null || this.sides[i].tile.func_145837_r() || !this.sides[i].tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[this.side]) || !this.checkRedstone(i)) continue;
            IItemHandler it = (IItemHandler)this.sides[i].tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.values()[this.side].func_176734_d());
            int r = item.field_77994_a;
            ItemStack ret = item.func_77946_l();
            if (this.itemFilters[i].keepStock) {
                int max = this.CheckKeepStock(this.sides[i], ret, this.itemFilters[i], InventoryHelper.getContentOfInventory(it));
                if (max > 0) {
                    ItemStack ret2 = ret.func_77946_l();
                    ret2.field_77994_a = Math.min(max, ret.field_77994_a);
                    for (int s = 0; s < it.getSlots(); ++s) {
                        if ((ret2 = it.insertItem(s, ret2.func_77946_l(), false)) == null || ret2.field_77994_a <= 0) {
                            ret.field_77994_a -= max;
                            break;
                        }
                        ret.field_77994_a -= max - ret2.field_77994_a;
                    }
                }
            } else if (this.CheckFilter(this.sides[i], item, this.itemFilters[i])) {
                for (int s = 0; s < it.getSlots(); ++s) {
                    if ((ret = it.insertItem(s, ret.func_77946_l(), false)) != null && ret.field_77994_a > 0) continue;
                    ret = null;
                    break;
                }
            }
            if (ret == null || ret != null && ret.field_77994_a == 0) {
                itemsInserted += r;
                return itemsToInsert;
            }
            item.field_77994_a = ret.field_77994_a;
            if (itemsToInsert > (itemsInserted += r - ret.field_77994_a)) continue;
            return itemsInserted;
        }
        return itemsInserted;
    }

    private void nextSide() {
        for (int i = 0; i < 6; ++i) {
            this.nextSideCheck();
            if (this.sides[this.side] == null || this.sides[this.side].type != CableHandler.ConnectionType.EXTRACT) continue;
            return;
        }
    }

    private void nextSideCheck() {
        ++this.side;
        if (this.side >= 6) {
            this.side = 0;
            this.nextOutput();
        }
    }

    private void nextOutput() {
        ++this.currentOutputIndex;
        Grid g = GridHandler.getGrid(this.field_145850_b).get(this.networkID.toString());
        if (g == null || g.output == null) {
            this.currentOutputIndex = -1;
        } else if (this.currentOutputIndex >= g.output.size()) {
            this.currentOutputIndex = 0;
        }
    }

    @Override
    void stateChanged(EnumFacing facing) {
        super.stateChanged(facing);
        this.currentOutputIndex = 0;
    }

    @Override
    protected boolean OpenGui(EnumFacing side, boolean isConnection, EntityPlayer player) {
        if (isConnection) {
            if (!this.field_145850_b.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)RouterReborn.instance, (int)13, (World)this.field_145850_b, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
                ((ContainerConduit)player.field_71070_bA).setSide(side.ordinal(), false);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getSizeInventory(int side) {
        if (side == -1) {
            return 0;
        }
        return this.itemFilters[side].getInventoryBasic().func_70302_i_();
    }

    @Override
    public ItemStack getStackInSlot(int index, int side) {
        if (side == -1) {
            return null;
        }
        return this.itemFilters[side].getInventoryBasic().func_70301_a(index);
    }

    @Override
    public ItemStack decrStackSize(int index, int count, int side) {
        if (side == -1) {
            return null;
        }
        return this.itemFilters[side].getInventoryBasic().func_70298_a(index, count);
    }

    @Override
    public ItemStack removeStackFromSlot(int index, int side) {
        if (side == -1) {
            return null;
        }
        return this.itemFilters[side].getInventoryBasic().func_70304_b(index);
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack, int side) {
        if (side == -1) {
            return;
        }
        this.itemFilters[side].getInventoryBasic().func_70299_a(index, stack);
    }

    @Override
    public int getInventoryStackLimit(int side) {
        if (side == -1) {
            return 0;
        }
        return this.itemFilters[side].getInventoryBasic().func_70297_j_();
    }

    @Override
    public void markDirty(int side) {
        if (side == -1) {
            return;
        }
        this.func_70296_d();
        this.itemFilters[side].getInventoryBasic().func_70296_d();
    }

    boolean checkRedstone(int side) {
        if (this.itemFilters[side].redstoneMode == 0) {
            return true;
        }
        int rstone = this.isBlockIndirectlyGettingPowered(this.field_174879_c);
        if (rstone > 0) {
            return this.itemFilters[side].redstoneMode == 1;
        }
        return this.itemFilters[side].redstoneMode == 2;
    }

    public int getRedstonePower(BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(pos);
        return iblockstate.func_177230_c().shouldCheckWeakPower(iblockstate, (IBlockAccess)this.field_145850_b, pos, facing) ? this.field_145850_b.func_175676_y(pos) : iblockstate.func_185911_a((IBlockAccess)this.field_145850_b, pos, facing);
    }

    public boolean isBlockPowered(BlockPos pos) {
        return this.getRedstonePower(pos.func_177977_b(), EnumFacing.DOWN) > 0 ? true : (this.getRedstonePower(pos.func_177984_a(), EnumFacing.UP) > 0 ? true : (this.getRedstonePower(pos.func_177978_c(), EnumFacing.NORTH) > 0 ? true : (this.getRedstonePower(pos.func_177968_d(), EnumFacing.SOUTH) > 0 ? true : (this.getRedstonePower(pos.func_177976_e(), EnumFacing.WEST) > 0 ? true : this.getRedstonePower(pos.func_177974_f(), EnumFacing.EAST) > 0))));
    }

    public int isBlockIndirectlyGettingPowered(BlockPos pos) {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            int j = this.getRedstonePower(pos.func_177972_a(enumfacing), enumfacing);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    @Override
    public int getGuiValueOf(int par, int side) {
        if (side == -1) {
            return 0;
        }
        switch (par) {
            case 0: {
                return this.sides[side].type.ordinal();
            }
            case 1: {
                return this.itemFilters[side].ignoreMeta ? 1 : 0;
            }
            case 2: {
                return this.itemFilters[side].isBlacklist ? 1 : 0;
            }
            case 3: {
                return this.itemFilters[side].useOreDict ? 1 : 0;
            }
            case 4: {
                return this.itemFilters[side].keepStock ? 1 : 0;
            }
            case 5: {
                return this.itemFilters[side].getRedstoneMode();
            }
        }
        return 0;
    }

    @Override
    public void guiButtonClick(int button, int side) {
        switch (button) {
            case 0: {
                if (this.sides[side] == null) break;
                this.sides[side].forced = true;
                this.sides[side].type = this.sides[side].type == CableHandler.ConnectionType.EXTRACT ? CableHandler.ConnectionType.OUTPUT : CableHandler.ConnectionType.EXTRACT;
                this.func_70296_d();
                break;
            }
            case 1: {
                this.itemFilters[side].ignoreMeta = !this.itemFilters[side].ignoreMeta;
                this.func_70296_d();
                break;
            }
            case 2: {
                this.itemFilters[side].isBlacklist = !this.itemFilters[side].isBlacklist;
                this.func_70296_d();
                break;
            }
            case 3: {
                this.itemFilters[side].useOreDict = !this.itemFilters[side].useOreDict;
                this.func_70296_d();
                break;
            }
            case 4: {
                this.itemFilters[side].keepStock = !this.itemFilters[side].keepStock;
            }
        }
    }

    @Override
    public void setGuiRedstoneMode(int button, int side) {
        this.itemFilters[side].setRedstoneMode(button);
    }

    public class ItemFilter {
        private FakeInventoryBasic inventory = new FakeInventoryBasic("title", false, 9);
        private boolean useOreDict = false;
        private boolean isBlacklist = false;
        private boolean ignoreMeta = false;
        private boolean keepStock = false;
        private int redstoneMode = 0;

        public FakeInventoryBasic getInventoryBasic() {
            return this.inventory;
        }

        public boolean getUseOreDict() {
            return this.useOreDict;
        }

        public void setUseOreDict(boolean useOreDict) {
            this.useOreDict = useOreDict;
        }

        public boolean getBlacklist() {
            return this.isBlacklist;
        }

        public void setBlacklist(boolean blacklist) {
            this.isBlacklist = blacklist;
        }

        public boolean getIgnoreMeta() {
            return this.ignoreMeta;
        }

        public void setIgnoreMeta(boolean ignoreMeta) {
            this.ignoreMeta = ignoreMeta;
        }

        public int getRedstoneMode() {
            return this.redstoneMode;
        }

        public void setRedstoneMode(int redstoneMode) {
            this.redstoneMode = redstoneMode;
        }

        public void readFromNBT(NBTTagCompound compound) {
            if (compound.func_74764_b("useOreDict")) {
                this.useOreDict = compound.func_74767_n("useOreDict");
            }
            if (compound.func_74764_b("isBlacklist")) {
                this.isBlacklist = compound.func_74767_n("isBlacklist");
            }
            if (compound.func_74764_b("ignoreMeta")) {
                this.ignoreMeta = compound.func_74767_n("ignoreMeta");
            }
            if (compound.func_74764_b("keepStock")) {
                this.keepStock = compound.func_74767_n("keepStock");
            }
            if (compound.func_74764_b("redstoneMode")) {
                this.redstoneMode = compound.func_74762_e("redstoneMode");
            }
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
            }
        }

        public void writeToNBT(NBTTagCompound compound) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                if (this.inventory.func_70301_a(i) == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                this.inventory.func_70301_a(i).func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
            compound.func_74757_a("useOreDict", this.useOreDict);
            compound.func_74757_a("isBlacklist", this.isBlacklist);
            compound.func_74757_a("ignoreMeta", this.ignoreMeta);
            compound.func_74757_a("keepStock", this.keepStock);
            compound.func_74768_a("redstoneMode", this.redstoneMode);
        }

        public boolean getKeepStock() {
            return this.keepStock;
        }

        public void setKeepStock(boolean keepStock) {
            this.keepStock = keepStock;
        }
    }
}

