/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.block;

import aroma1997.core.block.AromicBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AromicBlockMulti<T extends Enum<T>>
extends AromicBlock {
    private static PropertyEnum propertyTmp;
    protected final T[] types;
    public final PropertyEnum<T> property = propertyTmp;

    public AromicBlockMulti(Material material, Class<T> clazz) {
        super(AromicBlockMulti.prefab(material, clazz));
        propertyTmp = null;
        this.types = (Enum[])clazz.getEnumConstants();
        assert (this.types.length > 0);
        if (this.types.length >= 16) {
            throw new IllegalArgumentException("Maximum types of block is 16. Got " + this.types.length + " types instead: " + clazz);
        }
        this.func_180632_j(this.func_176223_P().func_177226_a(this.property, this.types[0]));
    }

    private static Material prefab(Material material, Class clazz) {
        propertyTmp = PropertyEnum.func_177709_a((String)"type", (Class)clazz);
        return material;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (T type : this.types) {
            list.add(new ItemStack((Block)this, 1, ((Enum)type).ordinal()));
        }
    }

    protected PropertyEnum<T> getProperty() {
        if (this.property == null) {
            return propertyTmp;
        }
        return this.property;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getProperty()});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= this.types.length) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(this.getProperty(), this.types[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.getProperty()))).ordinal();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }
}

