/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.log.LogHelperPre;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.RecipePart;
import aroma1997.core.util.ItemUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedAromicRecipe
implements IAromicRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    ItemStack output = null;
    Object[] input = null;
    int width = 0;
    int height = 0;
    private boolean hidden = false;
    private boolean enableMirror = true;

    ShapedAromicRecipe() {
    }

    public ShapedAromicRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped aromic recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
                if (OreDictionary.getOreIDs((ItemStack)((ItemStack)in)).length > 0) {
                    LogHelperPre.debugLog("Using " + in.toString() + " as a recipe ingredient. You could also have used a OreDict name " + " (in recipe: " + result.toString() + ")");
                }
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else if (in instanceof Class) {
                itemMap.put(chr, ItemUtil.getItemsFromClass((Class)in));
            } else if (in instanceof RecipePart) {
                itemMap.put(chr, in);
            } else if (in instanceof Item) {
                ItemStack item = new ItemStack((Item)in, 1, Short.MAX_VALUE);
                itemMap.put(chr, item);
                if (OreDictionary.getOreIDs((ItemStack)item).length > 0) {
                    LogHelperPre.debugLog("Using " + in.toString() + " as a recipe ingredient. You could also have used a OreDict name " + " (in recipe: " + result.toString() + ")");
                }
            } else if (in instanceof Block) {
                ItemStack item = new ItemStack((Block)in, 1, Short.MAX_VALUE);
                itemMap.put(chr, item);
                if (OreDictionary.getOreIDs((ItemStack)item).length > 0) {
                    LogHelperPre.debugLog("Using " + in.toString() + " as a recipe ingredient. You could also have used a OreDict name " + " (in recipe: " + result.toString() + ")");
                }
            } else {
                String ret = "Invalid shaped aromic recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (!this.checkMatch(inv, x, y, false) && (!this.checkMatch(inv, x, y, true) || !this.enableMirror)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (this.checkItemEquals((ItemStack)target, slot)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    for (ItemStack item : (List)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (!(target instanceof RecipePart ? !((RecipePart)target).doesItemMatch(slot) : target == null && slot != null)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return ItemUtil.areItemsSameMatching(target, input, ItemUtil.ItemMatchCriteria.WILDCARD);
    }

    @Override
    public Object[] getInput() {
        return this.input;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    @Override
    public boolean isMirrorOK() {
        return this.enableMirror;
    }

    @Override
    public void setMirrorOK(boolean mirrorok) {
        this.enableMirror = mirrorok;
    }
}

