/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.Aroma1997Core;
import aroma1997.core.items.IAromicItem;
import aroma1997.core.log.LogHelper;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.util.Util;
import aroma1997.core.util.registry.AutoRegister;
import aroma1997.core.util.registry.HasItemBlock;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class AromaRegistry {
    public static void register(Object o) {
        AromaRegistry.register(o.getClass(), o);
    }

    public static void register(Class<?> clazz) {
        AromaRegistry.register(clazz, null);
    }

    public static void register(Class<?> clazz, Object o) {
        block18: {
            String currentMod = Util.getCurrentModName();
            for (Field field : clazz.getFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    AutoRegister register = field.getAnnotation(AutoRegister.class);
                    if (register == null) continue;
                    String name = register.name().isEmpty() ? field.getName() : register.name();
                    Object obj = field.get(o);
                    ResourceLocation loc = new ResourceLocation(currentMod, name);
                    IAromicItem aitem = null;
                    if (obj == null) {
                        LogHelper.log(Level.WARN, "Tried initializing null field: " + o);
                    } else if (obj instanceof Block) {
                        Block block = (Block)GameRegistry.register((IForgeRegistryEntry)((Block)obj), (ResourceLocation)loc);
                        HasItemBlock item = field.getAnnotation(HasItemBlock.class);
                        if (item != null) {
                            ItemBlock itemBlock = item.itemBlock().getConstructor(Block.class).newInstance(block);
                            GameRegistry.register((IForgeRegistryEntry)itemBlock, (ResourceLocation)loc);
                            if (itemBlock instanceof IAromicItem) {
                                aitem = (IAromicItem)itemBlock;
                            }
                        }
                    } else if (obj instanceof Item) {
                        Item item = (Item)GameRegistry.register((IForgeRegistryEntry)((Item)obj), (ResourceLocation)loc);
                        if (item instanceof IAromicItem) {
                            aitem = (IAromicItem)item;
                        }
                    } else if (obj instanceof IRecipe) {
                        GameRegistry.addRecipe((IRecipe)((IRecipe)obj));
                    } else {
                        LogHelper.log(Level.WARN, "Tried initializing suspicious type: " + obj);
                    }
                    if (aitem == null) continue;
                    aitem.registerModels();
                }
                catch (Exception e) {
                    LogHelperPre.logException("Failed to register: " + field.getName(), e);
                }
            }
            try {
                Method method = clazz.getDeclaredMethod("init", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof NoSuchMethodException) break block18;
                LogHelperPre.logException("Failed to invoke the Initialization of: " + clazz.getCanonicalName(), e);
            }
        }
    }

    public static IAromicRecipe getShapedRecipe(ItemStack output, boolean hidden, Object ... input) {
        ShapedAromicRecipe recipe = new ShapedAromicRecipe(output, input);
        recipe.setHidden(hidden);
        return recipe;
    }

    public static IAromicRecipe getShapelessRecipe(ItemStack output, boolean hidden, Object ... input) {
        ShapelessAromicRecipe recipe = new ShapelessAromicRecipe(output, input);
        recipe.setHidden(hidden);
        return recipe;
    }

    public static void registerShapedAromicRecipe(ItemStack item, boolean hidden, Object ... params) {
        GameRegistry.addRecipe((IRecipe)AromaRegistry.getShapedRecipe(item, hidden, params));
    }

    public static void registerShapelessAromicRecipe(ItemStack item, boolean hidden, Object ... params) {
        GameRegistry.addRecipe((IRecipe)AromaRegistry.getShapelessRecipe(item, hidden, params));
    }

    public static void registerForMeshing(ModelEntry entry) {
        Aroma1997Core.proxy.registerForMeshing(entry);
    }

    public static class ModelEntry {
        public Item item;
        public int metadata;
        public String name;

        public ModelEntry(Block block, int metadata, String name) {
            this(Item.func_150898_a((Block)block), metadata, name);
        }

        public ModelEntry(Item item, int metadata, String name) {
            this.item = item;
            this.metadata = metadata;
            this.name = name;
        }
    }
}

