/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import net.malisis.core.MalisisCore;
import net.malisis.core.MalisisRegistry;
import net.malisis.core.item.MalisisItem;
import net.malisis.core.util.replacement.ReplacementTool;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.block.BigDoor;
import net.malisis.doors.block.CustomDoor;
import net.malisis.doors.block.Door;
import net.malisis.doors.block.DoorFactory;
import net.malisis.doors.block.FenceGate;
import net.malisis.doors.block.Forcefield;
import net.malisis.doors.block.GarageDoor;
import net.malisis.doors.block.RustyHatch;
import net.malisis.doors.block.RustyLadder;
import net.malisis.doors.block.SaloonDoorBlock;
import net.malisis.doors.block.TrapDoor;
import net.malisis.doors.block.VerticalHatchDoor;
import net.malisis.doors.descriptor.Curtain;
import net.malisis.doors.descriptor.FactoryDoor;
import net.malisis.doors.descriptor.GlassDoor;
import net.malisis.doors.descriptor.JailDoor;
import net.malisis.doors.descriptor.LaboratoryDoor;
import net.malisis.doors.descriptor.SaloonDoor;
import net.malisis.doors.descriptor.ShojiDoor;
import net.malisis.doors.descriptor.SlidingTrapDoor;
import net.malisis.doors.descriptor.VanillaDoor;
import net.malisis.doors.descriptor.VanillaTrapDoor;
import net.malisis.doors.descriptor.VerticalHatch;
import net.malisis.doors.descriptor.WoodTrapDoor;
import net.malisis.doors.item.CustomDoorItem;
import net.malisis.doors.item.DoorItem;
import net.malisis.doors.item.ForcefieldItem;
import net.malisis.doors.item.SaloonDoorItem;
import net.malisis.doors.item.VerticalHatchItem;
import net.malisis.doors.recipe.BigDoorRecipe;
import net.malisis.doors.tileentity.BigDoorTileEntity;
import net.malisis.doors.tileentity.CustomDoorTileEntity;
import net.malisis.doors.tileentity.DoorFactoryTileEntity;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.FenceGateTileEntity;
import net.malisis.doors.tileentity.ForcefieldTileEntity;
import net.malisis.doors.tileentity.GarageDoorTileEntity;
import net.malisis.doors.tileentity.RustyHatchTileEntity;
import net.malisis.doors.tileentity.SaloonDoorTileEntity;
import net.malisis.doors.tileentity.TrapDoorTileEntity;
import net.malisis.doors.tileentity.VerticalHatchTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public class Registers {
    public static void init() {
        if (((Boolean)MalisisDoorsSettings.modifyVanillaDoors.get()).booleanValue()) {
            Registers.registerVanillaDoors();
            Registers.registerVanillaTrapDoor();
            Registers.registerVanillaFenceGate();
        }
        Registers.registerDoors();
        Registers.registerCustomDoor();
        Registers.registerSaloonDoor();
        Registers.registerVerticalHatch();
        Registers.registerBigDoors();
        Registers.registerTrapDoors();
        Registers.registerCamoFenceGate();
        Registers.registerGarageDoor();
        Registers.registerDoorFactory();
        Registers.registerRustyHatch();
        Registers.registerForcefield();
        GameRegistry.registerTileEntity(DoorTileEntity.class, (String)"doorTileEntity");
        GameRegistry.registerTileEntity(TrapDoorTileEntity.class, (String)"trapDoorTileEntity");
        GameRegistry.registerTileEntity(FenceGateTileEntity.class, (String)"fenceGateTileEntity");
    }

    private static void registerVanillaDoors() {
        VanillaDoor oakDoor = new VanillaDoor(VanillaDoor.Type.OAK);
        oakDoor.create();
        MalisisDoors.Blocks.doorOak = (Door)oakDoor.getBlock();
        MalisisDoors.Items.doorOakItem = (DoorItem)oakDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)324, (String)"wooden_door", (String)"OAK_DOOR", (String)"field_179570_aq", (Item)oakDoor.getItem(), (Item)Items.field_179570_aq);
        ReplacementTool.replaceVanillaBlock((int)64, (String)"wooden_door", (String)"OAK_DOOR", (String)"field_180413_ao", (Block)oakDoor.getBlock(), (Block)Block.func_149684_b((String)"wooden_door"));
        VanillaDoor acaciaDoor = new VanillaDoor(VanillaDoor.Type.ACACIA);
        acaciaDoor.create();
        MalisisDoors.Blocks.doorAcacia = (Door)acaciaDoor.getBlock();
        MalisisDoors.Items.doorAcaciaItem = (DoorItem)acaciaDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)430, (String)"acacia_door", (String)"ACACIA_DOOR", (String)"field_179572_au", (Item)acaciaDoor.getItem(), (Item)Items.field_179572_au);
        ReplacementTool.replaceVanillaBlock((int)196, (String)"acacia_door", (String)"ACACIA_DOOR", (String)"field_180410_as", (Block)acaciaDoor.getBlock(), (Block)Block.func_149684_b((String)"acacia_door"));
        VanillaDoor birchDoor = new VanillaDoor(VanillaDoor.Type.BIRCH);
        birchDoor.create();
        MalisisDoors.Blocks.doorBirch = (Door)birchDoor.getBlock();
        MalisisDoors.Items.doorBirchItem = (DoorItem)birchDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)428, (String)"birch_door", (String)"BIRCH_DOOR", (String)"field_179568_as", (Item)birchDoor.getItem(), (Item)Items.field_179568_as);
        ReplacementTool.replaceVanillaBlock((int)194, (String)"birch_door", (String)"BIRCH_DOOR", (String)"field_180412_aq", (Block)birchDoor.getBlock(), (Block)Block.func_149684_b((String)"birch_door"));
        VanillaDoor darkOakDoor = new VanillaDoor(VanillaDoor.Type.DARK_OAK);
        darkOakDoor.create();
        MalisisDoors.Blocks.doorDarkOak = (Door)darkOakDoor.getBlock();
        MalisisDoors.Items.doorDarkOakItem = (DoorItem)darkOakDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)431, (String)"dark_oak_door", (String)"DARK_OAK_DOOR", (String)"field_179571_av", (Item)darkOakDoor.getItem(), (Item)Items.field_179571_av);
        ReplacementTool.replaceVanillaBlock((int)197, (String)"dark_oak_door", (String)"DARK_OAK_DOOR", (String)"field_180409_at", (Block)darkOakDoor.getBlock(), (Block)Block.func_149684_b((String)"dark_oak_door"));
        VanillaDoor jungleDoor = new VanillaDoor(VanillaDoor.Type.JUNGLE);
        jungleDoor.create();
        MalisisDoors.Blocks.doorJungle = (Door)jungleDoor.getBlock();
        MalisisDoors.Items.doorJungleItem = (DoorItem)jungleDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)429, (String)"jungle_door", (String)"JUNGLE_DOOR", (String)"field_179567_at", (Item)jungleDoor.getItem(), (Item)Items.field_179567_at);
        ReplacementTool.replaceVanillaBlock((int)195, (String)"jungle_door", (String)"JUNGLE_DOOR", (String)"field_180411_ar", (Block)jungleDoor.getBlock(), (Block)Block.func_149684_b((String)"jungle_door"));
        VanillaDoor spruceDoor = new VanillaDoor(VanillaDoor.Type.SPRUCE);
        spruceDoor.create();
        MalisisDoors.Blocks.doorSpruce = (Door)spruceDoor.getBlock();
        MalisisDoors.Items.doorSpruceItem = (DoorItem)spruceDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)427, (String)"spruce_door", (String)"SPRUCE_DOOR", (String)"field_179569_ar", (Item)spruceDoor.getItem(), (Item)Items.field_179569_ar);
        ReplacementTool.replaceVanillaBlock((int)193, (String)"spruce_door", (String)"SPRUCE_DOOR", (String)"field_180414_ap", (Block)spruceDoor.getBlock(), (Block)Block.func_149684_b((String)"spruce_door"));
        VanillaDoor ironDoor = new VanillaDoor(VanillaDoor.Type.IRON);
        ironDoor.create();
        MalisisDoors.Blocks.doorIron = (Door)ironDoor.getBlock();
        MalisisDoors.Items.doorIronItem = (DoorItem)ironDoor.getItem();
        ReplacementTool.replaceVanillaItem((int)330, (String)"iron_door", (String)"IRON_DOOR", (String)"field_151139_aw", (Item)ironDoor.getItem(), (Item)Items.field_151139_aw);
        ReplacementTool.replaceVanillaBlock((int)71, (String)"iron_door", (String)"IRON_DOOR", (String)"field_150454_av", (Block)ironDoor.getBlock(), (Block)Block.func_149684_b((String)"iron_door"));
        if (MalisisCore.isClient()) {
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorOakItem, (String)"minecraft:oak_door");
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorAcaciaItem, (String)"minecraft:acacia_door");
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorBirchItem, (String)"minecraft:birch_door");
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorDarkOakItem, (String)"minecraft:dark_oak_door");
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorJungleItem, (String)"minecraft:jungle_door");
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorSpruceItem, (String)"minecraft:spruce_door");
            MalisisRegistry.registerItemModel((Item)MalisisDoors.Items.doorIronItem, (String)"minecraft:iron_door");
        }
    }

    private static void registerVanillaTrapDoor() {
        VanillaTrapDoor trapDoorOak = new VanillaTrapDoor(VanillaTrapDoor.Type.WOOD);
        trapDoorOak.create();
        MalisisDoors.Blocks.oakTrapDoor = (TrapDoor)trapDoorOak.getBlock();
        ReplacementTool.replaceVanillaBlock((int)96, (String)"trapdoor", (String)"TRAPDOOR", (String)"field_150415_aT", (Block)trapDoorOak.getBlock(), (Block)Blocks.field_150415_aT);
        VanillaTrapDoor trapDoorIron = new VanillaTrapDoor(VanillaTrapDoor.Type.IRON);
        trapDoorIron.create();
        MalisisDoors.Blocks.ironTrapDoor = (TrapDoor)trapDoorIron.getBlock();
        ReplacementTool.replaceVanillaBlock((int)167, (String)"iron_trapdoor", (String)"IRON_TRAPDOOR", (String)"field_180400_cw", (Block)trapDoorIron.getBlock(), (Block)Blocks.field_180400_cw);
    }

    private static void registerVanillaFenceGate() {
        MalisisDoors.Blocks.oakFenceGate = new FenceGate(FenceGate.Type.OAK);
        ReplacementTool.replaceVanillaBlock((int)107, (String)"fence_gate", (String)"OAK_FENCE_GATE", (String)"field_180390_bo", (Block)MalisisDoors.Blocks.oakFenceGate, (Block)Blocks.field_180390_bo);
        MalisisDoors.Blocks.acaciaFenceGate = new FenceGate(FenceGate.Type.ACACIA);
        ReplacementTool.replaceVanillaBlock((int)187, (String)"acacia_fence_gate", (String)"ACACIA_FENCE_GATE", (String)"field_180387_bt", (Block)MalisisDoors.Blocks.acaciaFenceGate, (Block)Blocks.field_180387_bt);
        MalisisDoors.Blocks.birchFenceGate = new FenceGate(FenceGate.Type.BIRCH);
        ReplacementTool.replaceVanillaBlock((int)184, (String)"birch_fence_gate", (String)"BIRCH_FENCE_GATE", (String)"field_180392_bq", (Block)MalisisDoors.Blocks.birchFenceGate, (Block)Blocks.field_180392_bq);
        MalisisDoors.Blocks.darkOakFenceGate = new FenceGate(FenceGate.Type.DARK_OAK);
        ReplacementTool.replaceVanillaBlock((int)186, (String)"dark_oak_fence_gate", (String)"DARK_OAK_FENCE_GATE", (String)"field_180385_bs", (Block)MalisisDoors.Blocks.darkOakFenceGate, (Block)Blocks.field_180385_bs);
        MalisisDoors.Blocks.jungleFenceGate = new FenceGate(FenceGate.Type.JUNGLE);
        ReplacementTool.replaceVanillaBlock((int)185, (String)"jungle_fence_gate", (String)"JUNGLE_FENCE_GATE", (String)"field_180386_br", (Block)MalisisDoors.Blocks.jungleFenceGate, (Block)Blocks.field_180386_br);
        MalisisDoors.Blocks.spruceFenceGate = new FenceGate(FenceGate.Type.SPRUCE);
        ReplacementTool.replaceVanillaBlock((int)183, (String)"spruce_fence_gate", (String)"SPRUCE_FENCE_GATE", (String)"field_180391_bp", (Block)MalisisDoors.Blocks.spruceFenceGate, (Block)Blocks.field_180391_bp);
    }

    private static void registerDoors() {
        DoorDescriptor desc = new GlassDoor(Material.field_151575_d).register();
        MalisisDoors.Blocks.woodSlidingDoor = (Door)desc.getBlock();
        MalisisDoors.Items.woodSlidingDoorItem = (DoorItem)desc.getItem();
        desc = new GlassDoor(Material.field_151573_f).register();
        MalisisDoors.Blocks.ironSlidingDoor = (Door)desc.getBlock();
        MalisisDoors.Items.ironSlidingDoorItem = (DoorItem)desc.getItem();
        desc = new JailDoor().register();
        MalisisDoors.Blocks.jailDoor = (Door)desc.getBlock();
        MalisisDoors.Items.jailDoorItem = (DoorItem)desc.getItem();
        desc = new LaboratoryDoor().register();
        MalisisDoors.Blocks.laboratoryDoor = (Door)desc.getBlock();
        MalisisDoors.Items.laboratoryDoorItem = (DoorItem)desc.getItem();
        desc = new FactoryDoor().register();
        MalisisDoors.Blocks.factoryDoor = (Door)desc.getBlock();
        MalisisDoors.Items.factoryDoorItem = (DoorItem)desc.getItem();
        desc = new ShojiDoor().register();
        MalisisDoors.Blocks.shojiDoor = (Door)desc.getBlock();
        MalisisDoors.Items.shojiDoorItem = (DoorItem)desc.getItem();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            new Curtain(color).register();
        }
    }

    private static void registerSaloonDoor() {
        SaloonDoor desc = new SaloonDoor();
        MalisisDoors.Blocks.saloonDoor = new SaloonDoorBlock(desc);
        MalisisDoors.Items.saloonDoorItem = new SaloonDoorItem(desc);
        desc.set((Block)MalisisDoors.Blocks.saloonDoor, (Item)MalisisDoors.Items.saloonDoorItem);
        desc.register();
        GameRegistry.registerTileEntity(SaloonDoorTileEntity.class, (String)"saloonDoorTileEntity");
    }

    private static void registerVerticalHatch() {
        VerticalHatch desc = new VerticalHatch();
        MalisisDoors.Blocks.verticalHatch = new VerticalHatchDoor(desc);
        MalisisDoors.Items.verticalHatchItem = new VerticalHatchItem(desc);
        desc.set((Block)MalisisDoors.Blocks.verticalHatch, (Item)MalisisDoors.Items.verticalHatchItem);
        desc.register();
        GameRegistry.registerTileEntity(VerticalHatchTileEntity.class, (String)"verticalHatchTileEntity");
    }

    private static void registerTrapDoors() {
        DoorDescriptor desc = new SlidingTrapDoor().register();
        MalisisDoors.Blocks.slidingTrapDoor = (TrapDoor)desc.getBlock();
        MalisisDoors.Items.slidingTrapDoorItem = desc.getItem();
        for (WoodTrapDoor.Type type : WoodTrapDoor.Type.values()) {
            desc = new WoodTrapDoor(type).register();
        }
    }

    private static void registerCamoFenceGate() {
        MalisisDoors.Blocks.camoFenceGate = new FenceGate(FenceGate.Type.CAMO);
        MalisisDoors.Blocks.camoFenceGate.register();
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.camoFenceGate), (Object[])new Object[]{"ABC", Character.valueOf('A'), Blocks.field_180387_bt, Character.valueOf('B'), Blocks.field_180386_br, Character.valueOf('C'), Blocks.field_180392_bq});
    }

    private static void registerGarageDoor() {
        MalisisDoors.Blocks.garageDoor = new GarageDoor();
        MalisisDoors.Blocks.garageDoor.register();
        GameRegistry.registerTileEntity(GarageDoorTileEntity.class, (String)"garageDoorTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.garageDoor), (Object[])new Object[]{"ABA", "AAA", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), Blocks.field_150359_w});
    }

    private static void registerDoorFactory() {
        MalisisDoors.Blocks.doorFactory = new DoorFactory();
        MalisisDoors.Blocks.doorFactory.register();
        GameRegistry.registerTileEntity(DoorFactoryTileEntity.class, (String)"doorFactoryTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.doorFactory), (Object[])new Object[]{"ABA", "C C", "ADA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151139_aw, Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('D'), Blocks.field_150331_J});
    }

    private static void registerCustomDoor() {
        MalisisDoors.Blocks.customDoor = new CustomDoor();
        MalisisDoors.Blocks.customDoor.register();
        MalisisDoors.Items.customDoorItem = new CustomDoorItem();
        MalisisDoors.Items.customDoorItem.register();
        GameRegistry.registerTileEntity(CustomDoorTileEntity.class, (String)"customDoorTileEntity");
    }

    private static void registerRustyHatch() {
        MalisisDoors.Blocks.rustyHatch = new RustyHatch();
        MalisisDoors.Blocks.rustyHatch.register();
        MalisisDoors.Items.rustyHandle = new MalisisItem().setName("rustyHandle");
        MalisisDoors.Items.rustyHandle.func_77637_a(MalisisDoors.tab);
        MalisisDoors.Items.rustyHandle.register();
        GameRegistry.registerTileEntity(RustyHatchTileEntity.class, (String)"rustyHatchTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)MalisisDoors.Items.rustyHandle), (Object[])new Object[]{"AAA", " A ", Character.valueOf('A'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.rustyHatch), (Object[])new Object[]{"A ", "AB", "A ", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), MalisisDoors.Items.rustyHandle});
        MalisisDoors.Blocks.rustyLadder = new RustyLadder();
        MalisisDoors.Blocks.rustyLadder.register();
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.rustyLadder), (Object[])new Object[]{"AAA", Character.valueOf('A'), Items.field_151042_j});
    }

    private static void registerBigDoors() {
        MalisisDoors.Blocks.carriageDoor = new BigDoor(BigDoor.Type.CARRIAGE);
        MalisisDoors.Blocks.carriageDoor.register();
        MalisisDoors.Blocks.medievalDoor = new BigDoor(BigDoor.Type.MEDIEVAL);
        MalisisDoors.Blocks.medievalDoor.register();
        GameRegistry.registerTileEntityWithAlternatives(BigDoorTileEntity.class, (String)"bigDoorTileEntity", (String[])new String[]{"carriageDoorTileEntity"});
        GameRegistry.addRecipe((IRecipe)new BigDoorRecipe(BigDoor.Type.CARRIAGE));
        GameRegistry.addRecipe((IRecipe)new BigDoorRecipe(BigDoor.Type.MEDIEVAL));
        RecipeSorter.register((String)"malisisdoors:bigdoorsrecipe", BigDoorRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    private static void registerForcefield() {
        MalisisDoors.Blocks.forcefieldDoor = new Forcefield();
        MalisisDoors.Blocks.forcefieldDoor.register();
        MalisisDoors.Items.forcefieldItem = new ForcefieldItem();
        MalisisDoors.Items.forcefieldItem.register();
        GameRegistry.registerTileEntity(ForcefieldTileEntity.class, (String)"forcefieldTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)MalisisDoors.Items.forcefieldItem), (Object[])new Object[]{"ABA", "CDC", "AEA", Character.valueOf('A'), Items.field_151045_i, Character.valueOf('B'), Blocks.field_150343_Z, Character.valueOf('C'), Items.field_151107_aW, Character.valueOf('D'), Items.field_151061_bv, Character.valueOf('E'), Items.field_151132_bS});
    }
}

