/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.TrapDoorDescriptor;
import net.malisis.doors.block.Door;
import net.malisis.doors.renderer.TrapDoorRenderer;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.TrapDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

@MalisisRendered(value=TrapDoorRenderer.class)
public class TrapDoor
extends BlockTrapDoor
implements ITileEntityProvider,
IBoundingBox,
IComponentProvider,
IRegisterable {
    private TrapDoorDescriptor descriptor;
    protected final List<IComponent> components = Lists.newArrayList();

    public TrapDoor(TrapDoorDescriptor desc) {
        super(desc.getMaterial());
        this.descriptor = desc;
        this.func_149711_c(desc.getHardness());
        this.func_149672_a(desc.getSoundType());
        this.func_149663_c(desc.getName());
        this.func_149647_a(desc.getTab());
        this.func_149649_H();
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)IIconProvider.create((String)(this.descriptor.getModId() + ":" + this.descriptor.getTextureName())).build());
        }
    }

    public DoorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    public List<IComponent> getComponents() {
        return this.components;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        if (te.getDescriptor() == null) {
            return true;
        }
        if (te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        DoorTileEntity te;
        if (world.field_72995_K) {
            return;
        }
        boolean powered = world.func_175640_z(pos);
        if ((powered || neighborBlock.func_176223_P().func_185897_m()) && (te = Door.getDoor((IBlockAccess)world, pos)) != null) {
            te.setPowered(powered);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        DoorTileEntity te = Door.getDoor(world, pos);
        if (te == null || te.isMoving() || te.getMovement() == null) {
            return null;
        }
        AxisAlignedBB aabb = te.getMovement().getOpenBoundingBox(te, te.isTopBlock(pos), type);
        aabb = AABBUtils.rotate((AxisAlignedBB)aabb, (EnumFacing)te.getDirection());
        return aabb;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.COLLISION);
        for (AxisAlignedBB aabb : AABBUtils.offset((BlockPos)pos, (AxisAlignedBB[])aabbs)) {
            if (aabb == null || !mask.func_72326_a(aabb)) continue;
            list.add(aabb);
        }
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        Object[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs) || aabbs[0] == null) {
            return AABBUtils.empty((BlockPos)pos);
        }
        return AABBUtils.offset((BlockPos)pos, (AxisAlignedBB[])aabbs)[0];
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return new RaytraceBlock(world, start, end, pos).trace();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        TrapDoorTileEntity te = new TrapDoorTileEntity();
        te.setDescriptor(this.descriptor);
        return te;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

