/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.item;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.item.DoorItem;
import net.malisis.doors.renderer.CustomDoorRenderer;
import net.malisis.doors.tileentity.DoorFactoryTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

@MalisisRendered(value=CustomDoorRenderer.class)
public class CustomDoorItem
extends DoorItem {
    private static HashMap<Item, IBlockState> itemsAllowed = new HashMap();

    public CustomDoorItem() {
        this.func_77655_b("customDoorItem");
        this.field_77777_bU = 16;
        this.func_77637_a(null);
    }

    @Override
    public DoorDescriptor getDescriptor(ItemStack itemStack) {
        return new DoorDescriptor(itemStack.func_77978_p());
    }

    @Override
    public String getName() {
        return "customDoorItem";
    }

    public static ItemStack fromDoorFactory(DoorFactoryTileEntity te) {
        if (te.getDoorMovement() == null || te.getDoorSound() == null) {
            return null;
        }
        ItemStack isFrame = te.frameSlot.getItemStack();
        ItemStack isTop = te.topMaterialSlot.getItemStack();
        ItemStack isBottom = te.bottomMaterialSlot.getItemStack();
        if (!(CustomDoorItem.canBeUsedForDoor(isFrame, true) && CustomDoorItem.canBeUsedForDoor(isTop, false) && CustomDoorItem.canBeUsedForDoor(isBottom, false))) {
            return null;
        }
        IBlockState frame = ItemUtils.getStateFromItemStack((ItemStack)isFrame);
        IBlockState top = (IBlockState)Objects.firstNonNull((Object)itemsAllowed.get(isTop.func_77973_b()), (Object)ItemUtils.getStateFromItemStack((ItemStack)isTop));
        IBlockState bottom = (IBlockState)Objects.firstNonNull((Object)itemsAllowed.get(isBottom.func_77973_b()), (Object)ItemUtils.getStateFromItemStack((ItemStack)isBottom));
        NBTTagCompound nbt = new NBTTagCompound();
        te.buildDescriptor((Block)MalisisDoors.Blocks.customDoor, (Item)MalisisDoors.Items.customDoorItem).writeNBT(nbt);
        CustomDoorItem.writeNBT(nbt, frame, top, bottom);
        ItemStack is = new ItemStack((Item)MalisisDoors.Items.customDoorItem, 1);
        is.func_77982_d(nbt);
        return is;
    }

    public static boolean canBeUsedForDoor(ItemStack itemStack, boolean frame) {
        if (!frame && itemsAllowed.get(itemStack.func_77973_b()) != null) {
            return true;
        }
        IBlockState state = ItemUtils.getStateFromItemStack((ItemStack)itemStack);
        return state != null && !state.func_177230_c().func_149739_a().equals("tile.mixed_block") && state.func_185901_i() == EnumBlockRenderType.MODEL;
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> tooltip, boolean advancedTooltip) {
        super.func_77624_a(itemStack, player, tooltip, advancedTooltip);
        if (itemStack.func_77978_p() == null) {
            return;
        }
        Triple<IBlockState, IBlockState, IBlockState> triple = CustomDoorItem.readNBT(itemStack.func_77978_p());
        ItemStack frame = ItemUtils.getItemStackFromState((IBlockState)((IBlockState)triple.getLeft()));
        ItemStack top = ItemUtils.getItemStackFromState((IBlockState)((IBlockState)triple.getMiddle()));
        ItemStack bottom = ItemUtils.getItemStackFromState((IBlockState)((IBlockState)triple.getRight()));
        if (frame != null) {
            tooltip.addAll(frame.func_82840_a(player, advancedTooltip));
        }
        if (top != null) {
            tooltip.addAll(top.func_82840_a(player, advancedTooltip));
        }
        if (bottom != null) {
            tooltip.addAll(bottom.func_82840_a(player, advancedTooltip));
        }
    }

    public static Triple<IBlockState, IBlockState, IBlockState> readNBT(NBTTagCompound nbt) {
        IBlockState frame = MBlockState.fromNBT((NBTTagCompound)nbt, (String)"frame", (String)"frameMetadata");
        IBlockState top = MBlockState.fromNBT((NBTTagCompound)nbt, (String)"topMaterial", (String)"topMaterialMetadata");
        IBlockState bottom = MBlockState.fromNBT((NBTTagCompound)nbt, (String)"bottomMaterial", (String)"bottomMaterialMetadata");
        if (frame == null) {
            frame = Blocks.field_150344_f.func_176223_P();
        }
        if (top == null) {
            top = Blocks.field_150359_w.func_176223_P();
        }
        if (bottom == null) {
            bottom = Blocks.field_150359_w.func_176223_P();
        }
        return new ImmutableTriple((Object)frame, (Object)top, (Object)bottom);
    }

    public static NBTTagCompound writeNBT(NBTTagCompound nbt, IBlockState frame, IBlockState top, IBlockState bottom) {
        if (frame == null) {
            frame = Blocks.field_150344_f.func_176223_P();
        }
        if (top == null) {
            top = Blocks.field_150359_w.func_176223_P();
        }
        if (top == null) {
            top = Blocks.field_150359_w.func_176223_P();
        }
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)frame, (String)"frame", (String)"frameMetadata");
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)top, (String)"topMaterial", (String)"topMaterialMetadata");
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)bottom, (String)"bottomMaterial", (String)"bottomMaterialMetadata");
        return nbt;
    }

    static {
        itemsAllowed.put(Items.field_151033_d, Blocks.field_150480_ab.func_176223_P());
        itemsAllowed.put(Items.field_151079_bi, Blocks.field_150427_aO.func_176223_P());
        itemsAllowed.put(Items.field_151131_as, Blocks.field_150355_j.func_176223_P());
        itemsAllowed.put(Items.field_151129_at, Blocks.field_150353_l.func_176223_P());
    }
}

