/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class VerticalHatchMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getClosedBoundingBox(DoorTileEntity te, boolean topBlock, BoundingBoxType type) {
        return IDoorMovement.super.getClosedBoundingBox(te, topBlock, type);
    }

    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, topBlock && type == BoundingBoxType.SELECTION ? -1.0 : 0.0, 0.0, 1.0, !topBlock && type == BoundingBoxType.SELECTION ? 2.0 : 1.0, 0.1875);
        return AABBUtils.rotate((AxisAlignedBB)aabb.func_72317_d(tileEntity.isHingeLeft() ? 0.1875 : -0.1875, 0.0, 0.0), (int)(tileEntity.isHingeLeft() ? -1 : 1));
    }

    private Rotation getDoorTransformation(DoorTileEntity tileEntity) {
        float angle = -90.0f;
        float hingeX = -0.5f;
        int t = tileEntity.getDescriptor().getOpeningTime() / 2;
        if (tileEntity.isHingeLeft()) {
            hingeX = -hingeX;
            angle = -angle;
        }
        Rotation rotation = new Rotation(angle);
        rotation.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, -0.3125f);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            rotation.reversed(true);
        } else {
            rotation.delay(t);
        }
        rotation.forTicks(t);
        return rotation;
    }

    private Rotation getHandleTransformation(DoorTileEntity tileEntity) {
        int t = tileEntity.getDescriptor().getOpeningTime() / 2;
        Rotation rotation = (Rotation)new Rotation(45.0f, 600.0f).aroundAxis(0.0f, 0.0f, 1.0f).offset(0.0f, 0.53125f, 0.0f).movement(1);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            ((Rotation)rotation.delay(t)).reversed(true);
        }
        rotation.forTicks(t);
        return rotation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        ParallelTransformation transform = new ParallelTransformation(new Transformation[]{this.getDoorTransformation(tileEntity), this.getHandleTransformation(tileEntity)});
        return new Animation[]{new Animation((ITransformable)model.getShape("Door"), (Transformation)this.getDoorTransformation(tileEntity)), new Animation((ITransformable)model.getShape((Boolean)MalisisDoorsSettings.use3branchgHandle.get() != false ? "Handle3" : "Handle4"), (Transformation)transform)};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

