/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import javax.vecmath.Matrix4f;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.TransformBuilder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RustyLadderRenderer
extends MalisisRenderer<TileEntity> {
    private Shape ladder;
    private RenderParameters rp;
    private Matrix4f gui = new TransformBuilder().translate(-0.35f, -0.2f, 0.0f).rotate(30.0f, 45.0f, 0.0f).scale(1.0f).get();
    private Matrix4f thirdPerson = new TransformBuilder().translate(0.0f, 0.0f, -0.2f).rotate(0.0f, 110.0f, 0.0f).scale(-0.5f, 0.5f, 0.5f).get();
    private Matrix4f thirdPersonLeft = new TransformBuilder().translate(-0.25f, 0.0f, 0.0f).rotate(90.0f, 180.0f, 0.0f).scale(0.6f).get();
    private Matrix4f firstPerson = new TransformBuilder().translate(-0.1f, 0.1f, 0.0f).rotate(0.0f, 0.0f, 0.0f).scale(0.5f).get();
    private Matrix4f firstPersonLeft = new TransformBuilder().translate(-0.1f, 0.1f, 0.0f).rotate(0.0f, 180.0f, 0.0f).scale(0.5f).get();

    protected void initialize() {
        ResourceLocation rl = new ResourceLocation("malisisdoors", "models/rustyhatch.obj");
        MalisisModel model = new MalisisModel(rl);
        this.ladder = model.getShape("ladder");
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        switch (tranformType) {
            case GUI: {
                return this.gui;
            }
            case FIRST_PERSON_LEFT_HAND: {
                return this.firstPersonLeft;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                return this.firstPerson;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                return this.thirdPerson;
            }
            case THIRD_PERSON_LEFT_HAND: {
                return this.thirdPersonLeft;
            }
        }
        return null;
    }

    public void render() {
        this.ladder.resetState();
        if (this.renderType == RenderType.BLOCK) {
            EnumFacing dir = DirectionalComponent.getDirection((IBlockState)this.blockState);
            if (dir == EnumFacing.NORTH) {
                this.ladder.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
            } else if (dir == EnumFacing.SOUTH) {
                this.ladder.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            } else if (dir == EnumFacing.EAST) {
                this.ladder.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            }
        }
        this.ladder.translate(-1.0f, 0.0f, 0.0f);
        this.drawShape(this.ladder, this.rp);
    }
}

