/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import javax.vecmath.Matrix4f;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.TransformBuilder;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.TrapDoorTileEntity;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;

public class TrapDoorRenderer
extends MalisisRenderer<TrapDoorTileEntity> {
    public static TrapDoorRenderer instance = new TrapDoorRenderer();
    private MalisisModel trapDoorModel;
    private MalisisModel slidingTrapDoorModel;
    private RenderParameters rp;
    private AnimationRenderer ar = new AnimationRenderer();
    private Matrix4f firstPersonRightHand = new TransformBuilder().translate(0.0f, 0.25f, 0.0f).rotate(0.0f, 45.0f, 0.0f).scale(0.4f).get();
    private Matrix4f firstPersonLeftHand = new TransformBuilder().translate(0.0f, 0.25f, 0.0f).rotate(0.0f, 225.0f, 0.0f).scale(0.4f).get();
    private Matrix4f thirdPerson = new TransformBuilder().translate(0.0f, 0.17f, 0.12f).rotateAfter(75.0f, 45.0f, 0.0f).scale(0.375f).get();
    private Matrix4f ground = new TransformBuilder().scale(0.25f).get();
    private Matrix4f gui = new TransformBuilder().rotate(30.0f, 225.0f, 0.0f).scale(0.625f).get();

    public TrapDoorRenderer() {
        this.registerFor(TrapDoorTileEntity.class);
    }

    protected void initialize() {
        Cube s = new Cube();
        s.setBounds(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
        s.translate(0.0f, -0.8125f, 0.0f);
        s.interpolateUV();
        this.trapDoorModel = new MalisisModel();
        this.trapDoorModel.addShape("shape", (Shape)s);
        this.trapDoorModel.storeState();
        s.getFace((String)Face.nameFromDirection((EnumFacing)EnumFacing.UP)).getParameters().calculateAOColor.set((Object)true);
        s = new Cube();
        s.setSize(1.0f, 0.09375f, 1.0f);
        s.interpolateUV();
        this.slidingTrapDoorModel = new MalisisModel();
        this.slidingTrapDoorModel.addShape("shape", (Shape)s);
        this.slidingTrapDoorModel.storeState();
        this.initParams();
    }

    protected void initParams() {
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useEnvironmentBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public boolean isGui3d() {
        return true;
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        switch (tranformType) {
            case FIRST_PERSON_LEFT_HAND: {
                return this.firstPersonLeftHand;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                return this.firstPersonRightHand;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return this.thirdPerson;
            }
            case GROUND: {
                return this.ground;
            }
            case GUI: {
                return this.gui;
            }
        }
        return null;
    }

    public void render() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        MalisisModel model = this.block == MalisisDoors.Blocks.slidingTrapDoor ? this.slidingTrapDoorModel : this.trapDoorModel;
        model.resetState();
        if (this.renderType == RenderType.TILE_ENTITY) {
            this.setup(model);
            this.renderTileEntity(model);
            return;
        }
        if (this.renderType == RenderType.ITEM) {
            model.render((MalisisRenderer)this, this.rp);
            return;
        }
    }

    protected void setup(MalisisModel model) {
        EnumFacing direction = ((TrapDoorTileEntity)this.tileEntity).getDirection();
        float angle = 0.0f;
        if (direction == EnumFacing.SOUTH) {
            angle = 180.0f;
        } else if (direction == EnumFacing.WEST) {
            angle = 90.0f;
        } else if (direction == EnumFacing.EAST) {
            angle = 270.0f;
        }
        model.rotate(angle, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (((TrapDoorTileEntity)this.tileEntity).isTop()) {
            model.translate(0.0f, 0.8125f, 0.0f);
        }
    }

    protected void renderTileEntity(MalisisModel model) {
        this.ar.setStartTime(((TrapDoorTileEntity)this.tileEntity).getTimer().getStart());
        if (((TrapDoorTileEntity)this.tileEntity).getMovement() != null) {
            Animation<?>[] anims = ((TrapDoorTileEntity)this.tileEntity).getMovement().getAnimations((DoorTileEntity)this.tileEntity, model, this.rp);
            this.ar.animate(anims);
        }
        model.render((MalisisRenderer)this, this.rp);
    }
}

