/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.TransformBuilder;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.block.Door;
import net.malisis.doors.block.VerticalHatchDoor;
import net.malisis.doors.renderer.DoorRenderer;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.VerticalHatchTileEntity;
import net.minecraft.util.ResourceLocation;

public class VerticalHatchRenderer
extends DoorRenderer {
    public VerticalHatchRenderer() {
        super(false);
        this.registerFor(VerticalHatchTileEntity.class);
    }

    @Override
    protected void initialize() {
        ResourceLocation rl = new ResourceLocation("malisisdoors:models/verticalHatch.obj");
        this.model = new MalisisModel(rl);
        this.initParams();
        this.gui = new TransformBuilder().translate(0.0f, -0.28f, 0.0f).rotate(0.0f, 0.0f, 0.0f).scale(0.7f, 0.45f, 1.0f).get();
        this.firstPerson = new TransformBuilder().translate(0.0f, -0.28f, 0.0f).rotate(0.0f, -45.0f, 0.0f).scale(0.5f).get();
        this.ensureBlock(new Class[]{VerticalHatchDoor.class});
    }

    @Override
    public void render() {
        if (this.renderType == RenderType.BLOCK) {
            if (!Door.isTop(this.blockState)) {
                this.setTileEntity();
                this.setup();
                this.drawShape(this.model.getShape("Frame"), this.rp);
            }
            return;
        }
        super.render();
    }

    @Override
    protected void renderTileEntity() {
        this.enableBlending();
        this.ar.setStartTime(((DoorTileEntity)this.tileEntity).getTimer().getStart());
        if (((DoorTileEntity)this.tileEntity).getMovement() != null) {
            Animation<?>[] anims = ((DoorTileEntity)this.tileEntity).getMovement().getAnimations((DoorTileEntity)this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.next(9);
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
        this.drawShape(this.model.getShape("Door"), this.rp);
        this.drawShape(this.model.getShape((Boolean)MalisisDoorsSettings.use3branchgHandle.get() != false ? "Handle3" : "Handle4"), this.rp);
    }

    @Override
    public boolean isGui3d() {
        return true;
    }

    @Override
    protected void renderItem() {
        this.next(9);
        this.drawShape(this.model.getShape("Door"), this.rp);
        this.drawShape(this.model.getShape((Boolean)MalisisDoorsSettings.use3branchgHandle.get() != false ? "Handle3" : "Handle4"), this.rp);
    }

    @Override
    protected Icon getIcon(Face face, RenderParameters params) {
        return MalisisDoors.Blocks.verticalHatch.getIconProvider().getIcon();
    }
}

