/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import net.malisis.core.util.syncer.Syncable;
import net.malisis.doors.block.Door;
import net.malisis.doors.item.CustomDoorItem;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Triple;

@Syncable(value="TileEntity")
public class CustomDoorTileEntity
extends DoorTileEntity {
    private IBlockState frame = Blocks.field_150344_f.func_176223_P();
    private IBlockState top = Blocks.field_150359_w.func_176223_P();
    private IBlockState bottom = Blocks.field_150359_w.func_176223_P();

    public IBlockState getFrame() {
        return this.frame;
    }

    public IBlockState getTop() {
        return this.top;
    }

    public IBlockState getBottom() {
        return this.bottom;
    }

    public int getLightValue() {
        if (this.frame == null) {
            return 0;
        }
        return Math.max(Math.max(this.frame.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c), this.top.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c)), this.bottom.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c));
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack itemStack = super.getItemStack();
        CustomDoorItem.writeNBT(itemStack.func_77978_p(), this.frame, this.top, this.bottom);
        return itemStack;
    }

    @Override
    public void onBlockPlaced(Door door, ItemStack itemStack) {
        super.onBlockPlaced(door, itemStack);
        Triple<IBlockState, IBlockState, IBlockState> triple = CustomDoorItem.readNBT(itemStack.func_77978_p());
        this.frame = (IBlockState)triple.getLeft();
        this.top = (IBlockState)triple.getMiddle();
        this.bottom = (IBlockState)triple.getRight();
        this.setCentered(this.shouldCenter());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        Triple<IBlockState, IBlockState, IBlockState> triple = CustomDoorItem.readNBT(nbt);
        this.frame = (IBlockState)triple.getLeft();
        this.top = (IBlockState)triple.getMiddle();
        this.bottom = (IBlockState)triple.getRight();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        CustomDoorItem.writeNBT(nbt, this.frame, this.top, this.bottom);
        return nbt;
    }
}

