/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.Timer;
import net.malisis.core.util.syncer.Sync;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.core.util.syncer.Syncer;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorState;
import net.malisis.doors.block.Door;
import net.malisis.doors.movement.IDoorMovement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

@Syncable(value="TileEntity")
public class DoorTileEntity
extends TileEntity
implements ITickable {
    protected DoorDescriptor descriptor;
    protected int lastMetadata = -1;
    protected Timer timer = new Timer(0L);
    protected DoorState state = DoorState.CLOSED;
    protected boolean moving;
    protected boolean centered = false;
    protected PropertyBool openProperty = BlockDoor.field_176519_b;

    public DoorDescriptor getDescriptor() {
        if (this.descriptor == null || this.descriptor.getMovement() == null) {
            if (this.func_145838_q() == null) {
                return new DoorDescriptor();
            }
            if (this.func_145838_q() instanceof Door) {
                this.descriptor = ((Door)this.func_145838_q()).getDescriptor();
            }
        }
        return this.descriptor;
    }

    public void setDescriptor(DoorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Timer getTimer() {
        return this.timer;
    }

    @Sync(value="state")
    public DoorState getState() {
        return this.state;
    }

    public void setState(DoorState state) {
        this.state = state;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public IDoorMovement getMovement() {
        return this.getDescriptor() != null ? this.getDescriptor().getMovement() : null;
    }

    public int getOpeningTime() {
        return this.getDescriptor() != null ? this.getDescriptor().getOpeningTime() : 6;
    }

    public IBlockState getBlockState() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != this.func_145838_q() || this.func_145838_q() == null) {
            return null;
        }
        return state.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
    }

    public EnumFacing getDirection() {
        return BlockDoor.func_176517_h((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public boolean isTopBlock(BlockPos pos) {
        return this.field_174879_c.func_177984_a().equals((Object)pos);
    }

    public boolean isOpened() {
        IBlockState state = this.getBlockState();
        return state != null && (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) != false;
    }

    public boolean isHingeLeft() {
        return this.func_145838_q() instanceof Door && this.getBlockState().func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.LEFT;
    }

    public boolean isPowered() {
        return this.func_145831_w().func_175687_A(this.field_174879_c) + this.func_145831_w().func_175687_A(this.field_174879_c.func_177984_a()) != 0;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public boolean shouldCenter() {
        if (this.getMovement() == null) {
            return false;
        }
        EnumFacing offset = this.getDirection().func_176746_e();
        Block b1 = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(offset, 1)).func_177230_c();
        Block b2 = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(offset, -1)).func_177230_c();
        return ArrayUtils.contains((Object[])Door.centerBlocks, (Object)b1) || ArrayUtils.contains((Object[])Door.centerBlocks, (Object)b2);
    }

    public boolean setCentered(boolean centered) {
        this.centered = centered;
        TileEntityUtils.notifyUpdate((TileEntity)this);
        return centered;
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack(this.getDescriptor().getItem());
        NBTTagCompound nbt = new NBTTagCompound();
        this.descriptor.writeNBT(nbt);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public void onBlockPlaced(Door door, ItemStack itemStack) {
        DoorDescriptor desc = itemStack.func_77978_p() != null ? new DoorDescriptor(itemStack.func_77978_p()) : door.getDescriptor();
        this.setDescriptor(desc);
    }

    public void openOrCloseDoor() {
        DoorState newState = this.state == DoorState.OPENED ? DoorState.CLOSING : DoorState.OPENING;
        this.setDoorState(newState);
        DoorTileEntity te = this.getDoubleDoor();
        if (te != null) {
            te.setDoorState(newState);
        }
    }

    @Sync(value="state")
    public void setDoorState(DoorState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.state == DoorState.CLOSING || this.state == DoorState.OPENING) {
            if (this.moving) {
                long s = this.timer.elapsedTime() - Timer.tickToTime((long)this.getOpeningTime());
                this.timer.setRelativeStart(s);
            } else {
                this.timer.start();
                this.moving = true;
            }
            if (!this.field_145850_b.field_72995_K) {
                Syncer.sync((Object)((Object)this), (String[])new String[]{"state"});
            }
        } else {
            IBlockState state = this.getBlockState();
            if (state != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)this.openProperty, (Comparable)Boolean.valueOf(newState == DoorState.OPENED)));
            }
            this.moving = false;
        }
        this.playSound();
    }

    public void playSound() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        SoundEvent sound = null;
        if (this.descriptor.getSound() != null) {
            sound = this.descriptor.getSound().getSound(this.state);
        }
        if (sound != null) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public DoorTileEntity getDoubleDoor() {
        DoorTileEntity te;
        if (!this.descriptor.isDoubleDoor()) {
            return null;
        }
        EnumFacing offset = this.getDirection().func_176735_f();
        if (this.isHingeLeft()) {
            offset = offset.func_176734_d();
        }
        if (this.isMatchingDoubleDoor(te = Door.getDoor((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(offset)))) {
            return te;
        }
        return null;
    }

    public boolean isMatchingDoubleDoor(DoorTileEntity te) {
        if (te == null) {
            return false;
        }
        if (this.func_145838_q() != te.func_145838_q()) {
            return false;
        }
        if (this.getDirection() != te.getDirection()) {
            return false;
        }
        if (this.getMovement() != te.getMovement()) {
            return false;
        }
        if (this.isOpened() != te.isOpened()) {
            return false;
        }
        return this.isHingeLeft() != te.isHingeLeft();
    }

    public void setPowered(boolean powered) {
        if (this.isOpened() == powered && !this.isMoving()) {
            return;
        }
        DoorTileEntity te = this.getDoubleDoor();
        if (!powered && te != null && te.isPowered()) {
            return;
        }
        DoorState newState = powered ? DoorState.OPENING : DoorState.CLOSING;
        this.setDoorState(newState);
        if (te != null) {
            te.setDoorState(newState);
        }
    }

    public void func_73660_a() {
        if (!this.moving) {
            return;
        }
        if (this.timer.elapsedTick() > (long)this.getOpeningTime()) {
            this.setDoorState(this.state == DoorState.CLOSING ? DoorState.CLOSED : DoorState.OPENED);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.descriptor = new DoorDescriptor(nbt);
        this.setDoorState(DoorState.values()[nbt.func_74762_e("state")]);
        this.setCentered(nbt.func_74767_n("centered"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.descriptor != null) {
            this.descriptor.writeNBT(nbt);
        }
        nbt.func_74768_a("state", this.state.ordinal());
        nbt.func_74757_a("centered", this.centered);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

