/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;

public class GuiNumericField
extends GuiButton {
    private static final int DEFAULT_VALUE = 0;
    private static final int BUTTON_WIDTH = 12;
    private final GuiTextField guiTextField;
    private final GuiButton guiButtonDec;
    private final GuiButton guiButtonInc;
    private String previous = String.valueOf(0);
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;
    private boolean wasFocused = false;

    public GuiNumericField(FontRenderer fontRenderer, int id, int x, int y) {
        this(fontRenderer, id, x, y, 100, 20);
    }

    public GuiNumericField(FontRenderer fontRenderer, int id, int x, int y, int width) {
        this(fontRenderer, id, x, y, width, 20);
    }

    public GuiNumericField(FontRenderer fontRenderer, int id, int x, int y, int width, int height) {
        super(id, 0, 0, width, height, "");
        this.guiTextField = new GuiTextField(0, fontRenderer, x + 1, y + 1, width - 24 - 2, height - 2);
        this.guiButtonDec = new GuiButton(1, x + width - 24, y, 12, height, "-");
        this.guiButtonInc = new GuiButton(2, x + width - 12, y, 12, height, "+");
        this.setValue(0);
    }

    public boolean func_146116_c(Minecraft minecraft, int x, int y) {
        if (this.wasFocused && !this.guiTextField.func_146206_l()) {
            this.wasFocused = false;
            return true;
        }
        this.wasFocused = this.guiTextField.func_146206_l();
        return this.guiButtonDec.func_146116_c(minecraft, x, y) || this.guiButtonInc.func_146116_c(minecraft, x, y);
    }

    public void func_146112_a(Minecraft minecraft, int x, int y) {
        if (this.field_146125_m) {
            this.guiTextField.func_146194_f();
            this.guiButtonInc.func_146112_a(minecraft, x, y);
            this.guiButtonDec.func_146112_a(minecraft, x, y);
        }
    }

    public void mouseClicked(int x, int y, int action) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.guiTextField.func_146192_a(x, y, action);
        if (this.guiButtonInc.func_146116_c(minecraft, x, y)) {
            this.setValue(this.getValue() + 1);
        }
        if (this.guiButtonDec.func_146116_c(minecraft, x, y)) {
            this.setValue(this.getValue() - 1);
        }
    }

    public boolean keyTyped(char character, int code) {
        if (!this.guiTextField.func_146206_l()) {
            return false;
        }
        int cursorPositionOld = this.guiTextField.func_146198_h();
        this.guiTextField.func_146201_a(character, code);
        String text = this.guiTextField.func_146179_b();
        int cursorPositionNew = this.guiTextField.func_146198_h();
        if (text.length() == 0 || text.equals("-")) {
            return true;
        }
        try {
            long value = Long.parseLong(text);
            boolean outOfRange = false;
            if (value > (long)this.maximum) {
                value = this.maximum;
                outOfRange = true;
            } else if (value < (long)this.minimum) {
                value = this.minimum;
                outOfRange = true;
            }
            text = String.valueOf(value);
            if (!text.equals(this.previous) || outOfRange) {
                this.guiTextField.func_146180_a(String.valueOf(value));
                this.guiTextField.func_146190_e(cursorPositionNew);
            }
            this.previous = text;
            return true;
        }
        catch (NumberFormatException nfe) {
            this.guiTextField.func_146180_a(this.previous);
            this.guiTextField.func_146190_e(cursorPositionOld);
            return false;
        }
    }

    public void updateCursorCounter() {
        this.guiTextField.func_146178_a();
    }

    public boolean isFocused() {
        return this.guiTextField.func_146206_l();
    }

    public void setPosition(int x, int y) {
        this.guiTextField.field_146209_f = x + 1;
        this.guiTextField.field_146210_g = y + 1;
        this.guiButtonInc.field_146128_h = x + this.field_146120_f - 24;
        this.guiButtonInc.field_146129_i = y;
        this.guiButtonDec.field_146128_h = x + this.field_146120_f - 12;
        this.guiButtonDec.field_146129_i = y;
    }

    public void setEnabled(boolean enabled) {
        this.field_146124_l = enabled;
        this.guiTextField.func_146184_c(enabled);
        this.guiButtonInc.field_146124_l = enabled;
        this.guiButtonDec.field_146124_l = enabled;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setValue(int value) {
        if (value > this.maximum) {
            value = this.maximum;
        } else if (value < this.minimum) {
            value = this.minimum;
        }
        this.guiTextField.func_146180_a(String.valueOf(value));
    }

    public int getValue() {
        String text = this.guiTextField.func_146179_b();
        if (text.length() == 0 || text.equals("-")) {
            return 0;
        }
        return Integer.parseInt(text);
    }
}

