/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.handler;

import com.github.lunatrius.core.reference.Names;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static final boolean CHECK_FOR_UPDATES_DEFAULT = true;
    public static boolean checkForUpdates;
    private static Property propCheckForUpdates;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        propCheckForUpdates = configuration.get("versioncheck", "checkForUpdates", true, "Should the mod check for updates?");
        propCheckForUpdates.setLanguageKey(Names.Config.LANG_PREFIX + "." + "checkForUpdates");
        propCheckForUpdates.setRequiresMcRestart(true);
        checkForUpdates = propCheckForUpdates.getBoolean(true);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("LunatriusCore")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    static {
        checkForUpdates = true;
        propCheckForUpdates = null;
    }
}

