/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.version;

import com.github.lunatrius.core.reference.Reference;
import com.github.lunatrius.core.version.ForgeVersionCheck;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ComparableVersion;

public class VersionChecker {
    public static final String VER_CHECK_API_URL = "http://mc.lunatri.us/json?v=%d&mc=%s&limit=5";
    public static final int VER_CHECK_API_VER = 2;
    public static final String UPDATE_URL = "https://mods.io/mods?author=Lunatrius";
    private static final List<ModContainer> REGISTERED_MODS = new ArrayList<ModContainer>();
    private static final Joiner NEWLINE_JOINER = Joiner.on((char)'\n');

    public static void registerMod(ModContainer container, String forgeVersion) {
        REGISTERED_MODS.add(container);
        ModMetadata metadata = container.getMetadata();
        if (metadata.description != null) {
            metadata.description = metadata.description + "\n---\nCompiled against Forge " + forgeVersion;
        }
    }

    public static void startVersionCheck() {
        new Thread("LunatriusCore Version Check"){

            @Override
            public void run() {
                try {
                    if ("null".equals("1.10.2")) {
                        Reference.logger.error("Minecraft version is null! This is a bug!");
                        return;
                    }
                    URL url = new URL(String.format(VersionChecker.VER_CHECK_API_URL, 2, "1.10.2"));
                    URLConnection connection = url.openConnection();
                    connection.addRequestProperty("User-Agent", "LunatriusCore/1.1.2.36");
                    InputStream inputStream = connection.getInputStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)inputStream));
                    inputStream.close();
                    this.process((VersionData)new Gson().fromJson(data, VersionData.class));
                }
                catch (Throwable t) {
                    Reference.logger.error("Something went wrong!", t);
                }
            }

            private void process(VersionData versionData) {
                if (versionData.version != 2) {
                    return;
                }
                if (versionData.mods == null) {
                    return;
                }
                for (ModContainer container : REGISTERED_MODS) {
                    String modid = container.getModId();
                    if (!VersionChecker.isAllowedToCheck(modid)) {
                        Reference.logger.info("Skipped version check for {}", new Object[]{modid});
                        continue;
                    }
                    ModData modData = versionData.mods.get(modid);
                    if (modData == null || modData.latest == null) continue;
                    this.processMod(container, modData);
                }
            }

            private void processMod(ModContainer container, ModData modData) {
                BuildData latestBuild = modData.latest;
                ComparableVersion versionRemote = latestBuild.getVersion();
                String version = container.getVersion();
                ComparableVersion versionLocal = new ComparableVersion(version);
                ForgeVersion.Status status = ForgeVersionCheck.getStatus(versionRemote, versionLocal);
                ComparableVersion target = latestBuild.getVersion();
                Map<ComparableVersion, String> changes = modData.getAllChanges();
                String url = VersionChecker.UPDATE_URL;
                ForgeVersionCheck.notify(container, status, target, changes, VersionChecker.UPDATE_URL);
            }
        }.start();
    }

    public static boolean isAllowedToCheck(String scope) {
        return ForgeModContainer.getConfig().get("version_checking", scope, true).getBoolean();
    }

    public static class BuildData {
        public String mc;
        public String version;
        public int build;
        public List<String> changes;

        public ComparableVersion getVersion() {
            return new ComparableVersion(this.version);
        }

        public String getChanges() {
            if (this.changes == null) {
                return "";
            }
            return NEWLINE_JOINER.join(this.changes);
        }
    }

    public static class ModData {
        public BuildData latest;
        public List<BuildData> builds;

        public Map<ComparableVersion, String> getAllChanges() {
            LinkedHashMap<ComparableVersion, String> changes = new LinkedHashMap<ComparableVersion, String>();
            if (this.builds != null) {
                Collections.sort(this.builds, new Comparator<BuildData>(){

                    @Override
                    public int compare(BuildData a, BuildData b) {
                        return b.getVersion().compareTo(a.getVersion());
                    }
                });
                for (BuildData build : this.builds) {
                    changes.put(build.getVersion(), build.getChanges());
                }
                return changes;
            }
            if (this.latest != null) {
                changes.put(this.latest.getVersion(), this.latest.getChanges());
                return changes;
            }
            return changes;
        }
    }

    public static class VersionData {
        public int version;
        public Map<String, ModData> mods;
    }
}

