/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.core;

import java.io.File;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class SGConfig {
    private static Configuration config;
    private static File file;
    public static boolean enable_tier2;
    public static int tier2_multiplier;
    public static EnumT2CraftingComp tier2_crafting_comp;
    public static int furnace_rft;
    public static int furnace_buffer;
    public static int culinary_rft;
    public static int culinary_buffer;
    public static int lava_rft;
    public static int lava_buffer;
    public static int lava_mb_per_operation;
    public static int ender_rft;
    public static int ender_buffer;

    public static void preInit() {
        file = new File("config/simplegenerators.cfg");
        config = new Configuration(file);
        if (file.exists()) {
            config.load();
        }
        enable_tier2 = config.getBoolean("Allow_MKII_Crafting", "General", enable_tier2, "Enables/disables MK.II generators crafting recipes.");
        tier2_crafting_comp = EnumT2CraftingComp.getFromInt(config.getInt("MKII_Crafting_Component", "General", 0, 0, EnumT2CraftingComp.values().length - 1, "0 = Dragons Breath, 1 = Nether Star, 2 = Block of Diamond, 3 = Block of Gold"));
        furnace_rft = config.getInt("rft", "FurnaceGen", furnace_rft, 16, 400, "rf/t for furnace generator");
        furnace_buffer = config.getInt("energybuffer", "FurnaceGen", furnace_buffer, 100000, 10000000, "Energy buffer size for furnace generator");
        culinary_rft = config.getInt("rft", "CulinaryGen", culinary_rft, 16, 400, "rf/t for Culinary generator");
        culinary_buffer = config.getInt("energybuffer", "CulinaryGen", culinary_buffer, 100000, 10000000, "Energy buffer size for Culinary generator");
        lava_rft = config.getInt("rft", "LavaGen", lava_rft, 16, 400, "rf/t for lava generator");
        lava_buffer = config.getInt("energybuffer", "LavaGen", lava_buffer, 100000, 10000000, "Energy buffer size for lava generator");
        lava_mb_per_operation = config.getInt("mbuse", "LavaGen", lava_mb_per_operation, 10, 1000, "Amount of mb the lava gen uses per operation");
        ender_rft = config.getInt("rft", "EnderGen", ender_rft, 16, 400, "rf/t for Ender generator");
        ender_buffer = config.getInt("energybuffer", "EnderGen", ender_buffer, 100000, 10000000, "Energy buffer size for Ender generator");
        if (!file.exists() || config.hasChanged()) {
            config.save();
        }
    }

    static {
        enable_tier2 = true;
        tier2_multiplier = 8;
        furnace_rft = 64;
        furnace_buffer = 1000000;
        culinary_rft = 32;
        culinary_buffer = 1000000;
        lava_rft = 64;
        lava_buffer = 1000000;
        lava_mb_per_operation = 100;
        ender_rft = 128;
        ender_buffer = 1000000;
    }

    public static enum EnumT2CraftingComp {
        DRAGONS_BREATH(new ItemStack(Items.field_185157_bK)),
        NETHER_STAR(new ItemStack(Items.field_151156_bN)),
        BLOCK_DIAMOND(new ItemStack(Blocks.field_150484_ah)),
        BLOCK_GOLD(new ItemStack(Blocks.field_150340_R));

        public final ItemStack stack;

        private EnumT2CraftingComp(ItemStack stack) {
            this.stack = stack;
        }

        public static EnumT2CraftingComp getFromInt(int opt) {
            if (opt >= 0 && opt < EnumT2CraftingComp.values().length) {
                return EnumT2CraftingComp.values()[opt];
            }
            return DRAGONS_BREATH;
        }
    }
}

