/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.network.packet;

import com.valkyrieofnight.simplegenerators.tile.TileGeneratorFluid;
import com.valkyrieofnight.valkyrielib.network.VLPacket;
import com.valkyrieofnight.valkyrielib.util.helpers.NetworkUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGeneratorFluidUpdate
extends VLPacket<PacketGeneratorFluidUpdate> {
    protected int x;
    protected int y;
    protected int z;
    protected int dur;
    protected int pro;
    protected int rft;
    protected int eng;
    protected NBTTagCompound fluid;

    public PacketGeneratorFluidUpdate() {
    }

    public PacketGeneratorFluidUpdate(TileGeneratorFluid tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
        this.dur = tile.getCurrentDuration();
        this.pro = tile.getProgress();
        this.rft = tile.getCurrentRFT();
        this.eng = tile.getEnergyStored(EnumFacing.UP);
        if (tile.tank.getFluidAmount() > 0) {
            this.fluid = new NBTTagCompound();
            tile.tank.writeToNBT(this.fluid);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.dur = buf.readInt();
        this.pro = buf.readInt();
        this.rft = buf.readInt();
        this.eng = buf.readInt();
        this.fluid = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dur);
        buf.writeInt(this.pro);
        buf.writeInt(this.rft);
        buf.writeInt(this.eng);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)this.fluid, (ByteBuf)buf);
    }

    public IMessage onMessage(PacketGeneratorFluidUpdate message, MessageContext ctx) {
        TileEntity te;
        if (ctx.getClientHandler() != null && (te = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z))) instanceof TileGeneratorFluid) {
            TileGeneratorFluid tgb = (TileGeneratorFluid)te;
            tgb.clientUpdate(message.dur, message.pro, message.rft, message.eng);
            if (message.fluid != null) {
                tgb.tank.readFromNBT(message.fluid);
            }
        }
        return null;
    }
}

