/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile;

import com.valkyrieofnight.simplegenerators.gui.client.GuiGeneratorFluid;
import com.valkyrieofnight.simplegenerators.gui.container.ContainerGeneratorFluid;
import com.valkyrieofnight.simplegenerators.network.packet.PacketGeneratorFluidUpdate;
import com.valkyrieofnight.simplegenerators.tile.TileGeneratorBase;
import com.valkyrieofnight.valkyrielib.fluid.IFluidHandlerCustom;
import com.valkyrieofnight.valkyrielib.network.VLPacket;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class TileGeneratorFluid
extends TileGeneratorBase
implements IFluidHandler,
IFluidHandlerCustom {
    public FluidTank tank = new FluidTank(4000);

    public TileGeneratorFluid(int eBufferSize) {
        super(eBufferSize);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeClientDataToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readClientDataFromNBT(packet.func_148857_g());
    }

    public void writeClientDataToNBT(NBTTagCompound nbt) {
        this.func_189515_b(nbt);
    }

    public void readClientDataFromNBT(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.writeClientDataToNBT(updateTag);
        return updateTag;
    }

    @Override
    public VLPacket getPacket() {
        return new PacketGeneratorFluidUpdate(this);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
    }

    @Override
    public int getDuration() {
        return this.getDurationFromFluid(this.tank.getFluid());
    }

    @Override
    public boolean onStartProcess() {
        if (this.tank.getFluidAmount() >= this.getConsumptionPerDuration(this.tank.getFluid()) && this.isValidFuel(this.tank.getFluid())) {
            this.tank.drain(this.getConsumptionPerDuration(this.tank.getFluid()), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean canProcess() {
        return this.eBuffer.getMaxEnergyStored() > this.eBuffer.getEnergyStored() + this.currentRFT;
    }

    @Override
    public void onProcessTick() {
        this.eBuffer.receiveEnergyInternal(this.currentRFT, false);
    }

    @Override
    public int getRFPT() {
        return this.getRFTFromFluid(this.tank.getFluid());
    }

    @Override
    public void onProcessComplete() {
    }

    public abstract int getConsumptionPerDuration(FluidStack var1);

    public abstract int getRFTFromFluid(FluidStack var1);

    public abstract int getDurationFromFluid(FluidStack var1);

    public abstract boolean isValidFuel(FluidStack var1);

    public abstract boolean shouldConsumeAndGen(FluidStack var1);

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public int getFluidCapacity() {
        return this.tank.getCapacity();
    }

    public int getFluidStored() {
        return this.tank.getFluidAmount();
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerGeneratorFluid(player.field_71071_by, this);
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGeneratorFluid(player, new ContainerGeneratorFluid(player.field_71071_by, this), this);
    }

    public float getFluidLevelScale() {
        if (this.tank.getFluid() == null) {
            return 0.0f;
        }
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() == null) {
            return null;
        }
        return this.tank.getFluid().getFluid();
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFuel(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public IFluidHandler getFluidHandler() {
        return this;
    }
}

