/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile;

import com.valkyrieofnight.simplegenerators.gui.client.GuiGeneratorSingleItem;
import com.valkyrieofnight.simplegenerators.gui.container.ContainerGeneratorSingleItem;
import com.valkyrieofnight.simplegenerators.tile.TileGeneratorBase;
import com.valkyrieofnight.valkyrielib.inventory.CustomItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileGeneratorSingleItem
extends TileGeneratorBase
implements IItemHandlerModifiable {
    private ItemStack inputs;
    private CustomItemHandler input = new CustomItemHandler(1);

    public TileGeneratorSingleItem(int eBufferSize) {
        super(eBufferSize);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("inputi", (NBTBase)this.input.serializeNBT());
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.input.deserializeNBT(nbt.func_74775_l("inputi"));
    }

    @Override
    public int getDuration() {
        return this.getDurationFromItem(this.input.getStackInSlot(0));
    }

    @Override
    public boolean onStartProcess() {
        if (this.input.getStackInSlot(0) != null && this.input.getStackInSlot((int)0).field_77994_a > 0 && this.isValidFuel(this.input.getStackInSlot(0))) {
            this.input.extractItem(0, 1, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean canProcess() {
        return this.eBuffer.getMaxEnergyStored() > this.eBuffer.getEnergyStored() + this.currentRFT;
    }

    @Override
    public void onProcessTick() {
        this.eBuffer.receiveEnergyInternal(this.currentRFT, false);
    }

    @Override
    public void onProcessComplete() {
    }

    @Override
    public int getRFPT() {
        return this.getRFTFromItem(this.input.getStackInSlot(0));
    }

    public abstract int getRFTFromItem(ItemStack var1);

    public abstract int getDurationFromItem(ItemStack var1);

    public abstract boolean isValidFuel(ItemStack var1);

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this;
    }

    public int getSlots() {
        return this.input.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.input.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isValidFuel(stack)) {
            return this.input.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.input == null) {
            return null;
        }
        return this.input.extractItem(slot, amount, simulate);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.input.setStackInSlot(slot, stack);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        this.updateClients = true;
        return new ContainerGeneratorSingleItem(player.field_71071_by, this);
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGeneratorSingleItem(player, new ContainerGeneratorSingleItem(player.field_71071_by, this), this);
    }
}

