/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.openradio.block;

import at.chaosfield.openradio.OpenRadio;
import at.chaosfield.openradio.entity.LaserEntity;
import at.chaosfield.openradio.gui.CreativeTab;
import at.chaosfield.openradio.interfaces.ILaserModifier;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MirrorBlock
extends Block
implements ILaserModifier {
    public static final PropertyDirection FACING_HORIZONTAL = PropertyDirection.func_177712_a((String)"facingh", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger FACING_VERTICAL = PropertyInteger.func_177719_a((String)"facingv", (int)0, (int)3);

    public MirrorBlock() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FACING_VERTICAL, (Comparable)Integer.valueOf(0)));
        this.func_149663_c("openradio.blockmirror");
        this.func_149711_c(3.0f);
        this.func_149647_a(CreativeTab.instance);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZONTAL, FACING_VERTICAL});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stackPlayer, EnumFacing f6, float f7, float f8, float f9) {
        if (player.func_70093_af()) {
            int rot = (Integer)state.func_177229_b((IProperty)FACING_VERTICAL) + 1;
            if (rot >= 4) {
                rot = 0;
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)FACING_VERTICAL, (Comparable)Integer.valueOf(rot)));
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        int facingv = (meta & 0xC) >>> 2;
        return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)FACING_VERTICAL, (Comparable)Integer.valueOf(facingv));
    }

    public int func_176201_c(IBlockState state) {
        int facingv = (Integer)state.func_177229_b((IProperty)FACING_VERTICAL) << 2 & 0xC;
        int metah = ((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL)).func_176736_b() & 3;
        return metah + facingv;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)FACING_VERTICAL, (Comparable)Integer.valueOf(0));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)FACING_VERTICAL, (Comparable)Integer.valueOf(0)), 2);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumFacing facingvFromMetav(int metav, EnumFacing facingh) {
        if (facingh == EnumFacing.NORTH) {
            switch (metav) {
                case 0: {
                    return EnumFacing.UP;
                }
                case 1: {
                    return EnumFacing.WEST;
                }
                case 2: {
                    return EnumFacing.DOWN;
                }
                case 3: {
                    return EnumFacing.EAST;
                }
            }
            OpenRadio.logger.warn("I think someone is tempering with the universe... o.O");
        } else if (facingh == EnumFacing.EAST) {
            switch (metav) {
                case 0: {
                    return EnumFacing.UP;
                }
                case 1: {
                    return EnumFacing.NORTH;
                }
                case 2: {
                    return EnumFacing.DOWN;
                }
                case 3: {
                    return EnumFacing.SOUTH;
                }
            }
            OpenRadio.logger.warn("I think someone is tempering with the universe... o.O");
        } else if (facingh == EnumFacing.SOUTH) {
            switch (metav) {
                case 0: {
                    return EnumFacing.UP;
                }
                case 1: {
                    return EnumFacing.EAST;
                }
                case 2: {
                    return EnumFacing.DOWN;
                }
                case 3: {
                    return EnumFacing.WEST;
                }
            }
            OpenRadio.logger.warn("I think someone is tempering with the universe... o.O");
        } else if (facingh == EnumFacing.WEST) {
            switch (metav) {
                case 0: {
                    return EnumFacing.UP;
                }
                case 1: {
                    return EnumFacing.SOUTH;
                }
                case 2: {
                    return EnumFacing.DOWN;
                }
                case 3: {
                    return EnumFacing.NORTH;
                }
            }
            OpenRadio.logger.warn("I think someone is tempering with the universe... o.O");
        } else {
            OpenRadio.logger.warn("I think someone is tempering with the universe... o.O");
        }
        return EnumFacing.UP;
    }

    @Override
    public void hitByLaser(LaserEntity laserEntity, BlockPos pos, World world, EnumFacing direction) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facingv = this.facingvFromMetav((Integer)state.func_177229_b((IProperty)FACING_VERTICAL), (EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL));
        if (direction.equals((Object)facingv)) {
            laserEntity.field_70165_t = (double)pos.func_177958_n() + 0.5;
            laserEntity.field_70163_u = (double)pos.func_177956_o() + 0.5;
            laserEntity.field_70161_v = (double)pos.func_177952_p() + 0.5;
            laserEntity.func_70016_h((double)((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL)).func_176730_m().func_177958_n() * OpenRadio.instance.settings.EntitySpeed, (double)((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL)).func_176730_m().func_177956_o() * OpenRadio.instance.settings.EntitySpeed, (double)((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZONTAL)).func_176730_m().func_177952_p() * OpenRadio.instance.settings.EntitySpeed);
            laserEntity.addDistance(OpenRadio.instance.settings.MirrorDistancePenalty);
        } else if (direction.equals((Object)state.func_177229_b((IProperty)FACING_HORIZONTAL))) {
            laserEntity.field_70165_t = (double)pos.func_177958_n() + 0.5;
            laserEntity.field_70163_u = (double)pos.func_177956_o() + 0.5;
            laserEntity.field_70161_v = (double)pos.func_177952_p() + 0.5;
            laserEntity.func_70016_h((double)facingv.func_176730_m().func_177958_n() * OpenRadio.instance.settings.EntitySpeed, (double)facingv.func_176730_m().func_177956_o() * OpenRadio.instance.settings.EntitySpeed, (double)facingv.func_176730_m().func_177952_p() * OpenRadio.instance.settings.EntitySpeed);
            laserEntity.addDistance(OpenRadio.instance.settings.MirrorDistancePenalty);
        } else {
            laserEntity.func_70106_y();
        }
    }
}

