/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.openradio.integration.actuallyAdditions;

import at.chaosfield.openradio.OpenRadio;
import at.chaosfield.openradio.integration.Init;
import at.chaosfield.openradio.interfaces.ILaserAddon;
import at.chaosfield.openradio.tileentity.LaserTileEntity;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.ConnectionPair;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class LaserRelay
implements ILaserAddon {
    private TileEntity laserRelayTile;
    private LaserTileEntity laserTileEntity;
    private boolean connected = false;
    private String addonName;

    public LaserRelay(TileEntity laserRelayTile) {
        this.laserRelayTile = laserRelayTile;
        String tileName = laserRelayTile.func_145838_q().getRegistryName().toString();
        for (String name : Init.actAddLaserRelayEnergy) {
            if (!name.equals(tileName)) continue;
            this.addonName = "LaserRelayEnergy";
        }
        for (String name : Init.actAddLaserRelayItem) {
            if (!name.equals(tileName)) continue;
            this.addonName = "LaserRelayItem";
        }
    }

    @Override
    public void connectToLaser(LaserTileEntity laser) {
        this.laserTileEntity = laser;
        if (laser != null) {
            if (laser.isConnected()) {
                this.connectLaserRelays(laser);
            } else {
                this.disconnectLaserRelays(laser);
            }
        }
    }

    @Override
    public void disconnectFromLaser(LaserTileEntity laser) {
        if (this.laserTileEntity != null) {
            this.disconnectLaserRelays(this.laserTileEntity);
        }
    }

    @Override
    public void laserConnectionStatusChanged(boolean connected) {
        if (connected != this.connected && this.laserTileEntity != null) {
            if (connected) {
                this.connectLaserRelays(this.laserTileEntity);
            } else {
                this.disconnectLaserRelays(this.laserTileEntity);
            }
            this.connected = connected;
        }
    }

    private void connectLaserRelays(LaserTileEntity laser) {
        TileEntity tile;
        if (this.laserRelayTile != null && laser != null && (tile = laser.func_145831_w().func_175625_s(laser.getOtherLaser().getPos())) instanceof LaserTileEntity && ((LaserTileEntity)tile).isConnected()) {
            for (ILaserAddon addon : ((LaserTileEntity)tile).getAddons()) {
                if (addon == null || !addon.getAddonName().equals(this.addonName) || addon.getTile() == null) continue;
                ActuallyAdditionsAPI.connectionHandler.addConnection(this.laserRelayTile.func_174877_v(), addon.getTile().func_174877_v(), laser.func_145831_w(), true);
            }
        }
    }

    private void disconnectLaserRelays(LaserTileEntity laser) {
        if (this.laserRelayTile != null && laser != null) {
            TileEntity tile;
            ArrayList<BlockPos> otherRelays = new ArrayList<BlockPos>();
            if (laser.getOtherLaser() != null && (tile = laser.func_145831_w().func_175625_s(laser.getOtherLaser().getPos())) != null) {
                if (tile instanceof LaserTileEntity) {
                    for (ILaserAddon addon : ((LaserTileEntity)tile).getAddons()) {
                        if (addon == null || !addon.getAddonName().equals(this.addonName) || addon.getTile() == null) continue;
                        otherRelays.add(addon.getTile().func_174877_v());
                    }
                }
                ConcurrentSet connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.laserRelayTile.func_174877_v(), this.laserRelayTile.func_145831_w());
                ArrayList<ConnectionPair> newConnections = new ArrayList<ConnectionPair>();
                for (ConnectionPair connectionPair : connections) {
                    for (BlockPos otherRelay : otherRelays) {
                        if (connectionPair.contains(otherRelay)) continue;
                        newConnections.add(connectionPair);
                    }
                }
                ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.laserRelayTile.func_174877_v(), this.laserRelayTile.func_145831_w());
                for (ConnectionPair connectionPair : newConnections) {
                    ActuallyAdditionsAPI.connectionHandler.addConnection(connectionPair.positions[0], connectionPair.positions[1], this.laserRelayTile.func_145831_w());
                }
            }
        }
    }

    @Override
    public int getEnergyUsage() {
        return OpenRadio.instance.settings.ActAddLaserRelayUsage;
    }

    @Override
    public TileEntity getTile() {
        return this.laserRelayTile;
    }

    @Override
    public String getAddonName() {
        return this.addonName;
    }
}

