/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.openradio.tileentity;

import at.chaosfield.openradio.OpenRadio;
import at.chaosfield.openradio.entity.LaserEntity;
import at.chaosfield.openradio.init.Items;
import at.chaosfield.openradio.integration.Init;
import at.chaosfield.openradio.integration.actuallyAdditions.LaserRelay;
import at.chaosfield.openradio.interfaces.ILaserAddon;
import at.chaosfield.openradio.util.Location;
import li.cil.oc.api.API;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.TileEntityEnvironment;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class LaserTileEntity
extends TileEntityEnvironment
implements IInventory {
    public static final int SLOT_DSP = 0;
    public static final int SLOT_PHOTO_RECEPTOR = 1;
    public static final int SLOT_MIRROR = 2;
    public static final int SLOT_LASER = 3;
    private boolean powered;
    private double distance;
    private Location otherLaser;
    private int addonEnergyUsage = 0;
    private ILaserAddon[] connectedAddons = new ILaserAddon[]{null, null, null, null, null, null};
    private String[] connectedAddonsType = new String[]{null, null, null, null, null, null};
    private boolean first = true;
    private ItemStack[] inv;
    private int counter = 0;

    public LaserTileEntity() {
        this.node = API.network.newNode((Environment)this, Visibility.Network).withComponent(this.getComponentName()).withConnector((double)OpenRadio.instance.settings.EnergyBuffer).create();
        this.inv = new ItemStack[4];
        if (this.otherLaser != null && !this.field_145850_b.field_72995_K) {
            TileEntity otherLaserTe = DimensionManager.getWorld((int)this.otherLaser.getDim()).func_175625_s(this.otherLaser.getPos());
            if (otherLaserTe instanceof LaserTileEntity) {
                ((LaserTileEntity)otherLaserTe).setDestination(this.func_145831_w().field_73011_w.getDimension(), this.func_174877_v(), this.distance);
            } else {
                this.disconnect();
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public String func_70005_c_() {
        return "openradio.laser";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void sendEntity() {
        double accZ;
        double accY;
        double accX;
        double posZ;
        double posY;
        double posX;
        switch (this.func_145832_p()) {
            case 0: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5 - 1.0;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                accX = 0.0;
                accY = -OpenRadio.instance.settings.EntitySpeed;
                accZ = 0.0;
                break;
            }
            case 1: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5 + 1.0;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                accX = 0.0;
                accY = OpenRadio.instance.settings.EntitySpeed;
                accZ = 0.0;
                break;
            }
            case 2: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5 - 1.0;
                accX = 0.0;
                accY = 0.0;
                accZ = -OpenRadio.instance.settings.EntitySpeed;
                break;
            }
            case 3: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5 + 1.0;
                accX = 0.0;
                accY = 0.0;
                accZ = OpenRadio.instance.settings.EntitySpeed;
                break;
            }
            case 4: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5 - 1.0;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                accX = -OpenRadio.instance.settings.EntitySpeed;
                accY = 0.0;
                accZ = 0.0;
                break;
            }
            case 5: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5 + 1.0;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                accX = OpenRadio.instance.settings.EntitySpeed;
                accY = 0.0;
                accZ = 0.0;
                break;
            }
            default: {
                posX = (double)this.func_174877_v().func_177958_n() + 0.5;
                posY = (double)this.func_174877_v().func_177956_o() + 0.5 + 1.0;
                posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                accX = 0.0;
                accY = 0.0;
                accZ = 0.0;
            }
        }
        LaserEntity laserEntity = new LaserEntity(this.field_145850_b, posX, posY, posZ, accX, accY, accZ, this.func_145831_w().field_73011_w.getDimension(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.getMaxDistance(), this.getItemTier(3, (Object)Items.laserItem));
        this.func_145831_w().func_72838_d((Entity)laserEntity);
    }

    public void setDestination(int dim, BlockPos pos, double distance) {
        if (!this.func_145831_w().field_72995_K) {
            this.otherLaser = new Location(dim, pos);
            this.distance = distance;
            for (ILaserAddon addon : this.getAddons()) {
                if (addon == null) continue;
                addon.laserConnectionStatusChanged(true);
            }
            this.func_70296_d();
        }
    }

    public void disconnect() {
        for (ILaserAddon addon : this.getAddons()) {
            if (addon == null) continue;
            addon.laserConnectionStatusChanged(false);
        }
        this.otherLaser = null;
    }

    public void breakLaser() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.disconnectAddon(side);
        }
    }

    public Location getOtherLaser() {
        return this.otherLaser;
    }

    public boolean isConnected() {
        return this.otherLaser != null && this.isPowered() && this.hasNeededComponents();
    }

    public boolean hasNeededComponents() {
        return this.inv[0] != null && this.inv[1] != null && this.inv[2] != null && this.inv[3] != null && this.inv[0].func_77973_b() == Items.dspItem && this.inv[1].func_77973_b() == Items.photoReceptorItem && this.inv[2].func_77973_b() == Items.mirrorItem && this.inv[3].func_77973_b() == Items.laserItem;
    }

    public void connectAddon(String name, ILaserAddon addon, EnumFacing side) {
        if (this.connectedAddonsType[side.func_176745_a()] == null || !this.connectedAddonsType[side.func_176745_a()].equals(name)) {
            this.connectedAddons[side.func_176745_a()] = addon;
            this.connectedAddonsType[side.func_176745_a()] = addon.getAddonName();
            addon.connectToLaser(this);
        }
    }

    public void disconnectAddon(EnumFacing side) {
        if (this.connectedAddons[side.func_176745_a()] != null) {
            this.connectedAddons[side.func_176745_a()].disconnectFromLaser(this);
            this.connectedAddons[side.func_176745_a()] = null;
            this.connectedAddonsType[side.func_176745_a()] = null;
        }
    }

    public ILaserAddon[] getAddons() {
        return this.connectedAddons;
    }

    public int getItemTier(int slot, Object item) {
        if (this.inv[slot] != null && this.inv[slot].func_77973_b() == item && this.inv[slot].func_77952_i() <= 2 && this.inv[slot].func_77952_i() >= 0) {
            return this.inv[slot].func_77952_i() + 1;
        }
        return 0;
    }

    public double getMaxDistance() {
        if (this.hasNeededComponents()) {
            return OpenRadio.instance.settings.LaserMaxDistanceTier[this.getItemTier(3, (Object)Items.laserItem) - 1];
        }
        return 0.0;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void tryUsePower(int energy) {
        this.powered = this.node() != null && ((Connector)this.node()).tryChangeBuffer((double)((float)energy / -10.0f));
    }

    public double calculateBasicEnergyUsage() {
        int usage = 0;
        if (this.hasNeededComponents()) {
            usage += OpenRadio.instance.settings.EnergyUseLaserTier[this.getItemTier(3, (Object)Items.laserItem) - 1];
        }
        return usage;
    }

    public String getComponentName() {
        return "laser";
    }

    @Callback(direct=true, doc="function():double -- Get the current latency")
    public Object[] getLatency(Context context, Arguments args) {
        return new Object[]{this.distance};
    }

    public void onMessage(Message message) {
        super.onMessage(message);
        if (message.name().equals("network.message") && this.isConnected()) {
            TileEntity tileEntity = DimensionManager.getWorld((int)this.otherLaser.getDim()).func_175625_s(this.otherLaser.getPos());
            if (tileEntity instanceof LaserTileEntity) {
                ((LaserTileEntity)tileEntity).node.sendToReachable("network.message", message.data());
            } else {
                this.disconnect();
            }
        }
    }

    public void onNeighbourChanged() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177974_f());
        String name = this.checkAddon(tile, EnumFacing.EAST);
        if (name != null) {
            this.connectAddon(name, this.getAddon(tile, EnumFacing.EAST), EnumFacing.EAST);
        } else {
            this.disconnectAddon(EnumFacing.EAST);
        }
        tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177976_e());
        name = this.checkAddon(tile, EnumFacing.WEST);
        if (name != null) {
            this.connectAddon(name, this.getAddon(tile, EnumFacing.WEST), EnumFacing.WEST);
        } else {
            this.disconnectAddon(EnumFacing.WEST);
        }
        tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177968_d());
        name = this.checkAddon(tile, EnumFacing.SOUTH);
        if (name != null) {
            this.connectAddon(name, this.getAddon(tile, EnumFacing.SOUTH), EnumFacing.SOUTH);
        } else {
            this.disconnectAddon(EnumFacing.SOUTH);
        }
        tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177978_c());
        name = this.checkAddon(tile, EnumFacing.NORTH);
        if (name != null) {
            this.connectAddon(name, this.getAddon(tile, EnumFacing.NORTH), EnumFacing.NORTH);
        } else {
            this.disconnectAddon(EnumFacing.NORTH);
        }
        tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        name = this.checkAddon(tile, EnumFacing.UP);
        if (name != null) {
            this.connectAddon(name, this.getAddon(tile, EnumFacing.UP), EnumFacing.UP);
        } else {
            this.disconnectAddon(EnumFacing.UP);
        }
        tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        name = this.checkAddon(tile, EnumFacing.DOWN);
        if (name != null) {
            this.connectAddon(name, this.getAddon(tile, EnumFacing.DOWN), EnumFacing.DOWN);
        } else {
            this.disconnectAddon(EnumFacing.DOWN);
        }
        this.addonEnergyUsage = 0;
        for (ILaserAddon addon : this.connectedAddons) {
            if (addon == null) continue;
            this.addonEnergyUsage += addon.getEnergyUsage();
        }
        for (ILaserAddon addon : this.getAddons()) {
            if (addon == null) continue;
            addon.laserConnectionStatusChanged(this.isConnected());
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasNeededComponents()) {
                this.tryUsePower((int)(this.calculateBasicEnergyUsage() + (double)this.addonEnergyUsage));
            }
            if (this.first) {
                this.onNeighbourChanged();
                this.first = false;
            }
            if (this.hasNeededComponents() && this.isPowered()) {
                ++this.counter;
                if (this.counter >= 20) {
                    this.counter = 0;
                    this.sendEntity();
                }
            } else {
                for (ILaserAddon addon : this.getAddons()) {
                    if (addon == null) continue;
                    addon.laserConnectionStatusChanged(false);
                }
                this.disconnect();
            }
        }
    }

    private String checkAddon(TileEntity tile, EnumFacing side) {
        if (tile instanceof ILaserAddon) {
            return ((ILaserAddon)tile).getAddonName();
        }
        if (tile != null && Init.isActAddLoaded && side == EnumFacing.UP) {
            if (tile.func_145838_q().getRegistryName().toString().equals("actuallyadditions:blockLaserRelay")) {
                return "LaserRelay";
            }
            if (tile.func_145838_q().getRegistryName().toString().equals("actuallyadditions:blockLaserRelayAdvanced")) {
                return "LaserRelay";
            }
            if (tile.func_145838_q().getRegistryName().toString().equals("actuallyadditions:blockLaserRelayExtreme")) {
                return "LaserRelay";
            }
            if (tile.func_145838_q().getRegistryName().toString().equals("actuallyadditions:blockLaserRelayItem")) {
                return "LaserRelay";
            }
            if (tile.func_145838_q().getRegistryName().toString().equals("actuallyadditions:blockLaserRelayItemWhitelist")) {
                return "LaserRelay";
            }
        }
        return null;
    }

    private ILaserAddon getAddon(TileEntity tile, EnumFacing side) {
        if (tile instanceof ILaserAddon) {
            return (ILaserAddon)tile;
        }
        if (tile != null && Init.isActAddLoaded && side == EnumFacing.UP) {
            String tileName = tile.func_145838_q().getRegistryName().toString();
            for (String name : Init.actAddLaserRelayEnergy) {
                if (!name.equals(tileName)) continue;
                return new LaserRelay(tile);
            }
            for (String name : Init.actAddLaserRelayItem) {
                if (!name.equals(tileName)) continue;
                return new LaserRelay(tile);
            }
        }
        return null;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                return itemStack.func_77973_b() == Items.dspItem;
            }
            case 1: {
                return itemStack.func_77973_b() == Items.photoReceptorItem;
            }
            case 2: {
                return itemStack.func_77973_b() == Items.mirrorItem;
            }
            case 3: {
                return itemStack.func_77973_b() == Items.laserItem;
            }
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74767_n("otherLaserConnected")) {
            this.distance = tagCompound.func_74769_h("distance");
            this.otherLaser = new Location(tagCompound.func_74762_e("otherLaserDimId"), tagCompound.func_74762_e("otherLaserX"), tagCompound.func_74762_e("otherLaserY"), tagCompound.func_74762_e("otherLaserZ"));
        } else {
            this.disconnect();
        }
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", (int)tagCompound.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.isConnected()) {
            tagCompound.func_74780_a("distance", this.distance);
            tagCompound.func_74757_a("otherLaserConnected", true);
            tagCompound.func_74768_a("otherLaserDimId", this.otherLaser.getDim());
            tagCompound.func_74768_a("otherLaserX", this.otherLaser.getX());
            tagCompound.func_74768_a("otherLaserY", this.otherLaser.getY());
            tagCompound.func_74768_a("otherLaserZ", this.otherLaser.getZ());
        } else {
            tagCompound.func_74757_a("otherLaserConnected", false);
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

