/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.openradio.util;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Settings {
    public double EntitySpeed = 1.0;
    public double DistancePerAir = 1.0;
    public double DistancePerTransparent = 2.0;
    public int MirrorDistancePenalty = 8;
    public double[] LaserMaxDistanceTier = new double[]{64.0, 128.0, 256.0};
    public double[] LensMultiplierTier = new double[]{1.0, 3.0, 7.0};
    public int[] EnergyUseLaserTier = new int[]{25, 50, 100};
    public int AEEnergyMultiplier = 10;
    public int ActAddLaserRelayUsage = 10;
    public int EnergyBuffer = 100;
    public float[][] LaserColor = new float[][]{{1.0f, 0.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f, 0.25f}, {0.0f, 1.0f, 0.0f, 1.0f}};

    public Settings(File configFile) {
        Configuration config = new Configuration(configFile);
        config.load();
        this.EntitySpeed = config.getFloat("LaserEntitySpeed", "misc", 1.0f, 0.1f, 1.0f, "speed of the connection-check entity (blocks/tick. max 1 for reliable block checking)");
        this.DistancePerAir = config.getFloat("LaserDistancePerAir", "distances", 1.0f, 0.0f, 2048.0f, "added distance per air block");
        this.DistancePerTransparent = config.getFloat("LaserDistancePerTransparent", "distances", 2.0f, 0.0f, 2048.0f, "added distance per transparent non-air block");
        this.MirrorDistancePenalty = config.getInt("MirrorDistancePenalty", "distances", 8, 0, 2048, "added distance per mirror block");
        this.LaserMaxDistanceTier[0] = config.getFloat("LaserTier1MasDistance", "distances", 64.0f, 0.0f, 16384.0f, "maximum distance of a tier 1 laser");
        this.LaserMaxDistanceTier[1] = config.getFloat("LaserTier2MasDistance", "distances", 128.0f, 0.0f, 16384.0f, "maximum distance of a tier 2 laser");
        this.LaserMaxDistanceTier[2] = config.getFloat("LaserTier3MasDistance", "distances", 256.0f, 0.0f, 16384.0f, "maximum distance of a tier 3 laser");
        this.LensMultiplierTier[0] = config.getFloat("LensMultiplierTier1", "distances", 1.0f, 0.0f, 100.0f, "distance multiplier of a tier 1 lens");
        this.LensMultiplierTier[1] = config.getFloat("LensMultiplierTier2", "distances", 3.0f, 0.0f, 100.0f, "distance multiplier of a tier 2 lens");
        this.LensMultiplierTier[2] = config.getFloat("LensMultiplierTier3", "distances", 7.0f, 0.0f, 100.0f, "distance multiplier of a tier 3 lens");
        this.EnergyUseLaserTier[0] = config.getInt("EnergyUseLaserTier1", "energy", 25, 0, 100000, "energy usage of a tier 1 laser");
        this.EnergyUseLaserTier[1] = config.getInt("EnergyUseLaserTier2", "energy", 50, 0, 100000, "energy usage of a tier 2 laser");
        this.EnergyUseLaserTier[2] = config.getInt("EnergyUseLaserTier3", "energy", 100, 0, 100000, "energy usage of a tier 3 laser");
        this.AEEnergyMultiplier = config.getInt("AEEncoderMultiplier", "energy", 10, 1, 10000, "energy usage multiplier if an AE Encoder is connected");
        this.ActAddLaserRelayUsage = config.getInt("ActAddLaserRelayUsage", "energy", 10, 0, 10000, "additional energy usage if a ActuallyAdditions Laser Relay is connected");
        this.EnergyBuffer = config.getInt("EnergyBuffer", "energy", 100, 10, 100000, "internal energy buffer size");
        config.save();
    }
}

