/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.breedingframe;

import com.google.common.base.Predicate;
import edgarallen.mods.scf.blocks.common.BlockBaseFrame;
import edgarallen.mods.scf.network.ThePacketeer;
import edgarallen.mods.scf.network.messages.MessageSpawnBreedingHeartParticles;
import edgarallen.mods.scf.network.messages.MessageSpawnResizeHeartParticles;
import edgarallen.mods.scf.util.EnumPlacement;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBreedingFrame
extends TileEntity {
    private static final Predicate<Entity> BREEDABLE_ANIMALS = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70089_S() && entity instanceof EntityAnimal && !((EntityAnimal)entity).func_70631_g_();
        }
    };
    private static final String NBT_SIZE_TAG = "aoe_size";
    private static final int DEFAULT_SIZE = 9;
    private static final int MIN_SIZE = 1;
    private static final int MAX_SIZE = 15;
    private static final int height = 5;
    private int size = 9;

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.size = data.func_74764_b(NBT_SIZE_TAG) ? data.func_74762_e(NBT_SIZE_TAG) : 9;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74768_a(NBT_SIZE_TAG, this.size);
        return data;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = super.func_189517_E_();
        data.func_74768_a(NBT_SIZE_TAG, this.size);
        return data;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int getSize() {
        return this.size;
    }

    public int getHeight() {
        return 5;
    }

    void resizeArea(EntityPlayer player, boolean shrinkArea) {
        this.size += shrinkArea ? -2 : 2;
        this.size = MathHelper.func_76125_a((int)this.size, (int)1, (int)15);
        ThePacketeer.INSTANCE.sendToAllAround((IMessage)new MessageSpawnResizeHeartParticles(this.field_174879_c, this.size, 5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.super_breeding_frame.resize", new Object[]{this.size, 5, this.size}));
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnBreedingParticles() {
        for (int i = 0; i < 7; ++i) {
            Random rand = this.field_145850_b.field_73012_v;
            this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, (double)((float)this.field_174879_c.func_177958_n() + rand.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + rand.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + rand.nextFloat()), rand.nextGaussian() * 0.002, rand.nextGaussian() * 0.002, rand.nextGaussian() * 0.002, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnResizeParticles(int size, int height) {
        BlockPos minBB = this.getMinBB(size, height);
        BlockPos maxBB = this.getMaxBB(size, height);
        for (int y = minBB.func_177956_o(); y <= maxBB.func_177956_o(); ++y) {
            for (int x = minBB.func_177958_n(); x <= maxBB.func_177958_n(); ++x) {
                for (int z = minBB.func_177952_p(); z <= maxBB.func_177952_p(); ++z) {
                    this.spawnHeartParticle((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnHeartParticle(double posX, double posY, double posZ) {
        Random rand = this.field_145850_b.field_73012_v;
        double d0 = rand.nextGaussian() * 0.002;
        double d1 = rand.nextGaussian() * 0.002;
        double d2 = rand.nextGaussian() * 0.002;
        this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, posX, posY, posZ, d0, d1, d2, new int[0]);
    }

    private BlockPos getMinBB(int size, int height) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        switch ((EnumPlacement)((Object)state.func_177229_b(BlockBaseFrame.PLACEMENT))) {
            case CEILING: {
                return new BlockPos(this.field_174879_c.func_177958_n() - (size - 1) / 2, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - (size - 1) / 2);
            }
            case FLOOR: {
                return new BlockPos(this.field_174879_c.func_177958_n() - (size - 1) / 2, this.field_174879_c.func_177956_o() - 1 - height, this.field_174879_c.func_177952_p() - (size - 1) / 2);
            }
            case WALL: {
                switch ((EnumFacing)state.func_177229_b((IProperty)BlockBaseFrame.FACING)) {
                    case NORTH: {
                        return new BlockPos(this.field_174879_c.func_177958_n() - (size - 1) / 2, this.field_174879_c.func_177956_o() - (height - 1) / 2, this.field_174879_c.func_177952_p() - size);
                    }
                    case SOUTH: {
                        return new BlockPos(this.field_174879_c.func_177958_n() - (size - 1) / 2, this.field_174879_c.func_177956_o() - (height - 1) / 2, this.field_174879_c.func_177952_p() + 1);
                    }
                    case EAST: {
                        return new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - (height - 1) / 2, this.field_174879_c.func_177952_p() - (size - 1) / 2);
                    }
                    case WEST: {
                        return new BlockPos(this.field_174879_c.func_177958_n() - size, this.field_174879_c.func_177956_o() - (height - 1) / 2, this.field_174879_c.func_177952_p() - (size - 1) / 2);
                    }
                }
            }
        }
        return BlockPos.field_177992_a;
    }

    private BlockPos getMaxBB(int size, int height) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        switch ((EnumPlacement)((Object)state.func_177229_b(BlockBaseFrame.PLACEMENT))) {
            case CEILING: {
                return new BlockPos(this.field_174879_c.func_177958_n() + (size - 1) / 2, this.field_174879_c.func_177956_o() + 1 + height, this.field_174879_c.func_177952_p() + (size - 1) / 2);
            }
            case FLOOR: {
                return new BlockPos(this.field_174879_c.func_177958_n() + (size - 1) / 2, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + (size - 1) / 2);
            }
            case WALL: {
                switch ((EnumFacing)state.func_177229_b((IProperty)BlockBaseFrame.FACING)) {
                    case NORTH: {
                        return new BlockPos(this.field_174879_c.func_177958_n() + (size - 1) / 2, this.field_174879_c.func_177956_o() + (height - 1) / 2, this.field_174879_c.func_177952_p() - 1);
                    }
                    case SOUTH: {
                        return new BlockPos(this.field_174879_c.func_177958_n() + (size - 1) / 2, this.field_174879_c.func_177956_o() + (height - 1) / 2, this.field_174879_c.func_177952_p() + size);
                    }
                    case EAST: {
                        return new BlockPos(this.field_174879_c.func_177958_n() + size, this.field_174879_c.func_177956_o() + (height - 1) / 2, this.field_174879_c.func_177952_p() + (size - 1) / 2);
                    }
                    case WEST: {
                        return new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() + (height - 1) / 2, this.field_174879_c.func_177952_p() + (size - 1) / 2);
                    }
                }
            }
        }
        return BlockPos.field_177992_a;
    }

    void makeLove(EntityPlayer player, EnumHand hand, ItemStack heldItem, boolean all) {
        List<EntityAnimal> animals = this.getAnimals(this.getCenterPos());
        boolean spawnBreedingHearts = false;
        for (EntityAnimal animal : animals) {
            if (!animal.func_70877_b(heldItem) || !animal.func_184645_a(player, hand, heldItem)) continue;
            spawnBreedingHearts = true;
            if (all && heldItem != null && heldItem.field_77994_a > 0) continue;
            break;
        }
        if (spawnBreedingHearts) {
            ThePacketeer.INSTANCE.sendToAllAround((IMessage)new MessageSpawnBreedingHeartParticles(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
        }
    }

    private BlockPos getCenterPos() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        switch ((EnumPlacement)((Object)state.func_177229_b(BlockBaseFrame.PLACEMENT))) {
            case CEILING: {
                return new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1 + 2, this.field_174879_c.func_177952_p());
            }
            case FLOOR: {
                return new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1 - 2, this.field_174879_c.func_177952_p());
            }
            case WALL: {
                switch ((EnumFacing)state.func_177229_b((IProperty)BlockBaseFrame.FACING)) {
                    case NORTH: {
                        return new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1 - (this.size - 1) / 2);
                    }
                    case SOUTH: {
                        return new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1 + (this.size - 1) / 2);
                    }
                    case EAST: {
                        return new BlockPos(this.field_174879_c.func_177958_n() + 1 + (this.size - 1) / 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    }
                    case WEST: {
                        return new BlockPos(this.field_174879_c.func_177958_n() - 1 - (this.size - 1) / 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    }
                }
            }
        }
        return BlockPos.field_177992_a;
    }

    private List<EntityAnimal> getAnimals(BlockPos pos) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos);
        aabb = aabb.func_72314_b((double)((this.size - 1) / 2), 2.0, (double)((this.size - 1) / 2));
        return this.field_145850_b.func_175647_a(EntityAnimal.class, aabb, BREEDABLE_ANIMALS);
    }
}

